/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.CustomFlow;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.Properties;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.util.HashMap;
import java.util.Map;

public final class PurchaseFlow
extends CustomFlow {
    static final String MOMENT_ADD_TO_CART = "_add-to-cart";
    static final String MOMENT_PURCHASE = "_purchase";
    static final String PROP_AMOUNT = "amount";
    static final String PROP_ITEM_ID = "item-id";
    static final String PROP_MESSAGE = "message";
    static final String PROP_MOMENT_ID = "moment-id";
    static final String PROP_NUM_ITEMS = "num-items";
    static final String PROP_ORDER_ID = "order-id";
    static final String PROP_PAYMENT_TYPE = "payment-type";
    static final String PROP_PRICE = "price";
    static final String PROP_QUANTITY = "quantity";
    final Map<String, Map<String, Object>> addToCartPropsMap = new HashMap<String, Map<String, Object>>();
    Map<String, Object> purchaseProps = new HashMap<String, Object>();
    Status status = Status.OPEN;
    String purchaseMomentId;

    public synchronized String addToCartStart(String itemId, Number quantity, Number price, Map<String, Object> properties) {
        if (this.status != Status.OPEN) {
            this.logError("Purchase flow is not in a state where an add-to-cart moment can be started.", true, null);
            return null;
        }
        properties = Properties.normalizeProperties(properties);
        String momentId = Uuid.getEmbUuid();
        if (itemId != null) {
            properties.put(PROP_ITEM_ID, itemId);
        }
        if (quantity != null) {
            properties.put(PROP_QUANTITY, quantity.toString());
        }
        if (price != null) {
            properties.put(PROP_PRICE, price.toString());
        }
        this.momentStart(MOMENT_ADD_TO_CART, momentId, true, properties);
        this.addToCartPropsMap.put(momentId, properties);
        return momentId;
    }

    public synchronized boolean addToCartComplete(String momentId) {
        if (TextUtils.isEmpty((CharSequence)momentId) || !this.addToCartPropsMap.containsKey(momentId)) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(PROP_MOMENT_ID, momentId);
            this.logError("Purchase flow does not recognize add-to-cart moment identifier.", true, properties);
            return false;
        }
        if (this.status != Status.OPEN) {
            this.logError("Purchase flow is not in a state where the add-to-cart moment can be completed.", true, this.purchaseProps);
            return false;
        }
        this.momentEnd(MOMENT_ADD_TO_CART, momentId);
        this.addToCartPropsMap.remove(momentId);
        return true;
    }

    public synchronized boolean addToCartFail(String momentId, String msg) {
        if (TextUtils.isEmpty((CharSequence)momentId) || !this.addToCartPropsMap.containsKey(momentId)) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(PROP_MOMENT_ID, momentId);
            this.logError("Purchase flow does not recognize add-to-cart moment identifier.", true, properties);
            return false;
        }
        if (this.status != Status.OPEN) {
            this.logError("Purchase flow is not in a state where the add-to-cart moment can be failed.", true, this.purchaseProps);
            return false;
        }
        Map<String, Object> properties = this.addToCartPropsMap.get(momentId);
        if (msg != null) {
            properties.put(PROP_MESSAGE, msg);
        }
        this.logError("A failure occurred while adding an item to the cart.", true, properties);
        this.momentEnd(MOMENT_ADD_TO_CART, momentId);
        this.addToCartPropsMap.remove(momentId);
        return true;
    }

    public synchronized boolean purchaseStart(String orderId, Number numItems, Number amount, String paymentType, Map<String, Object> properties) {
        if (this.status != Status.OPEN) {
            this.logError("Purchase flow is not in a state where the purchase moment can be started.", false, null);
            return false;
        }
        properties = Properties.normalizeProperties(properties);
        if (orderId != null) {
            properties.put(PROP_ORDER_ID, orderId);
        }
        if (numItems != null) {
            properties.put(PROP_NUM_ITEMS, numItems.toString());
        }
        if (amount != null) {
            properties.put(PROP_AMOUNT, amount.toString());
        }
        if (paymentType != null) {
            properties.put(PROP_PAYMENT_TYPE, paymentType);
        }
        this.purchaseMomentId = Uuid.getEmbUuid();
        this.purchaseProps = properties;
        this.momentStart(MOMENT_PURCHASE, this.purchaseMomentId, false, properties);
        this.status = Status.PURCHASING;
        return true;
    }

    public synchronized boolean purchaseComplete() {
        if (this.status != Status.PURCHASING) {
            this.logError("Purchase flow is not in a state where the purchase moment can be completed.", false, this.purchaseProps);
            return false;
        }
        this.logInfo("Purchase was completed.", this.purchaseProps);
        this.momentEnd(MOMENT_PURCHASE, this.purchaseMomentId);
        Embrace.getInstance().setUserAsPayer();
        this.status = Status.CLOSED;
        return true;
    }

    public synchronized boolean purchaseFail(String msg) {
        if (this.status != Status.PURCHASING) {
            this.logError("Purchase flow is not in a state where the purchase moment can be failed.", false, this.purchaseProps);
            return false;
        }
        if (msg != null) {
            this.purchaseProps.put(PROP_MESSAGE, msg);
        }
        this.logError("A failure occurred during purchase.", true, this.purchaseProps);
        this.momentEnd(MOMENT_PURCHASE, this.purchaseMomentId);
        this.status = Status.CLOSED;
        return true;
    }

    static enum Status {
        OPEN,
        PURCHASING,
        CLOSED;

    }
}

