/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import android.util.Base64;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.IInterval;
import io.embrace.android.embracesdk.NetworkUtils;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class NetworkCall
implements IInterval {
    private final String url;
    private final String httpMethod;
    private final Integer statusCode;
    private final long startTime;
    private final long endTime;
    private final Long bytesSent;
    private final Long bytesReceived;
    private final String requestId;
    private final boolean didClientError;
    private final String errorType;
    private final String errorMessage;

    NetworkCall(String url, String httpMethod, Integer statusCode, long startTime, long endTime, Long bytesSent, Long bytesReceived) {
        this(url, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived, false, null, null);
    }

    NetworkCall(String url, String httpMethod, long startTime, long endTime, String errorType, String errorMessage) {
        this(url, httpMethod, null, startTime, endTime, null, null, true, errorType, errorMessage);
    }

    private NetworkCall(String url, String httpMethod, Integer statusCode, long startTime, long endTime, Long bytesSent, Long bytesReceived, boolean didClientError, String errorType, String errorMessage) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.statusCode = statusCode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
        this.requestId = String.format("%.6s", Base64.encodeToString((byte[])UUID.randomUUID().toString().getBytes(), (int)2).replace('+', '0').replace(' ', '0'));
        this.didClientError = didClientError;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
    }

    JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("rid", (Object)(!TextUtils.isEmpty((CharSequence)this.requestId) ? this.requestId : ""));
            jsonObject.put("x", (Object)(!TextUtils.isEmpty((CharSequence)this.httpMethod) ? this.httpMethod : ""));
            jsonObject.put("dur", Math.max(this.endTime - this.startTime, -1L));
            if (this.bytesReceived != null) {
                jsonObject.put("bi", (Object)this.bytesReceived);
            }
            if (this.bytesSent != null) {
                jsonObject.put("bo", (Object)this.bytesSent);
            }
            jsonObject.put("url", (Object)(!TextUtils.isEmpty((CharSequence)this.url) ? this.url : ""));
            jsonObject.put("st", this.startTime);
            jsonObject.put("et", this.endTime);
            if (this.statusCode != null) {
                jsonObject.put("rc", (Object)this.statusCode);
            }
            if (this.didClientError) {
                jsonObject.put("er", this.didClientError);
                if (this.errorType != null) {
                    jsonObject.put("ed", (Object)this.errorType);
                }
                if (this.errorMessage != null) {
                    jsonObject.put("de", (Object)this.errorMessage);
                }
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    String getUrl() {
        return this.url;
    }

    String getUrlOriginPath() {
        return NetworkUtils.getUrlOriginPath(this.url);
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    Integer getStatusCode() {
        return this.statusCode;
    }

    long getBytesSent() {
        return this.bytesSent;
    }

    long getBytesReceived() {
        return this.bytesReceived;
    }

    long getElapsedTime() {
        return this.endTime - this.startTime;
    }

    boolean didClientError() {
        return this.didClientError;
    }

    static boolean validateNetworkCall(Integer statusCode, long startTime, long endTime) {
        if (statusCode != null && (statusCode < 100 || statusCode > 599)) {
            EmbraceLogger.logError("Failed to log network call: Invalid status code (valid ranges: 100 ~ 599 inclusive).");
            return false;
        }
        if (startTime < 0L) {
            EmbraceLogger.logError("Failed to log network call: Start time is a negative value.");
            return false;
        }
        if (endTime < 0L) {
            EmbraceLogger.logError("Failed to log network call: End time is a negative value.");
            return false;
        }
        return true;
    }
}

