/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.SessionManager;
import java.util.Map;

abstract class CustomFlow {
    protected final EmbraceManager embraceMgr = EmbraceManager.getInstance();

    CustomFlow() {
    }

    protected synchronized void momentStart(String momentName, String momentId, boolean doesAllowScreenshot, Map<String, Object> properties) {
        try {
            this.embraceMgr.startEvent(momentName, momentId, doesAllowScreenshot, properties);
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError(String.format("An error occurred trying to start moment: %s - %s", momentName, momentId), e);
        }
    }

    protected synchronized void momentEnd(String momentName, String momentId) {
        try {
            this.embraceMgr.endEvent(momentName, momentId);
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError(String.format("An error occurred trying to end moment: %s - %s", momentName, momentId), e);
        }
    }

    protected synchronized void logInfo(String msg, Map<String, Object> properties) {
        try {
            this.embraceMgr.logMessage(msg, EmbraceEvent.Type.INFO_LOG, false, properties, SessionManager.manager.getStackTraceForCurrentThread());
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError(String.format("An error occurred sending log info message: %s", msg), e);
        }
    }

    protected synchronized void logError(String msg, boolean doesAllowScreenshot, Map<String, Object> properties) {
        try {
            this.embraceMgr.logMessage(msg, EmbraceEvent.Type.ERROR_LOG, doesAllowScreenshot, properties, SessionManager.manager.getStackTraceForCurrentThread());
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logError(String.format("An error occurred sending log error message: %s", msg), e);
        }
    }
}

