/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import io.embrace.android.embracesdk.AppBuildConfig;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.EmbraceServer;
import io.embrace.android.embracesdk.EmbraceSharedPreferences;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class User {
    private static final int USER_UPDATED_MESSAGE_DELAY_IN_MILISECONDS = 1000;
    private static final Integer PERSONA_MAX_ALLOWED_LENGTH = 16;
    private static final String PERSONA_REGEX = "^[a-zA-Z0-9_]{1," + PERSONA_MAX_ALLOWED_LENGTH + "}$";
    private static final String PERSONA_NEW_USER = "new_user";
    private static final String PERSONA_POWER_USER = "power_user";
    private static final String PERSONA_LOGGED_IN = "logged_in";
    private static final String PERSONA_VIP = "vip";
    private static final String PERSONA_CREATOR = "content_creator";
    private static final String PERSONA_TESTER = "tester";
    private static final String PERSONA_PAYER = "payer";
    private static final String PERSONA_FIRST_DAY_USER = "first_day";
    private static Set<String> globalPersonas = null;
    private String internalIdentifier;
    private String emailAddress;
    private String username;
    private boolean payer;
    private boolean hasServerPersonas = false;
    private boolean userMessagePending;
    private Set<String> allPersonas;
    private Set<String> userPersonas;
    private Set<String> invalidPersonas;
    private final EmbraceSharedPreferences embraceSharedPreferences = EmbraceSharedPreferences.getInstance();
    final AppBuildConfig buildConfig;
    private static final User singleton;

    static User getInstance() {
        return singleton;
    }

    private User() {
        Embrace.getInstance();
        this.buildConfig = new AppBuildConfig(Embrace.getContext());
        this.internalIdentifier = this.embraceSharedPreferences.userIdentifier();
        this.emailAddress = this.embraceSharedPreferences.userEmailAddress();
        this.payer = this.embraceSharedPreferences.isUserPayer();
        this.allPersonas = new HashSet<String>(globalPersonas);
        Set<String> cachedCustomPersonas = this.embraceSharedPreferences.customPersonas();
        if (cachedCustomPersonas != null) {
            this.allPersonas.addAll(cachedCustomPersonas);
        }
        this.userPersonas = this.embraceSharedPreferences.userPersonas();
        if (this.userPersonas == null) {
            this.userPersonas = new HashSet<String>();
        }
        this.invalidPersonas = new HashSet<String>();
    }

    void updateInternalIdentifier(String identifier, EmbraceSharedPreferences embraceSharedPreferences) throws EmbraceSdkException {
        if (!TextUtils.equals((CharSequence)identifier, (CharSequence)embraceSharedPreferences.userIdentifier())) {
            this.internalIdentifier = identifier;
            this.triggerUserUpdateMessage();
            embraceSharedPreferences.setUserIdentifier(identifier);
        }
    }

    void updateEmailAddress(String emailAddress, EmbraceSharedPreferences embraceSharedPreferences) throws EmbraceSdkException {
        if (!TextUtils.equals((CharSequence)emailAddress, (CharSequence)embraceSharedPreferences.userEmailAddress())) {
            this.emailAddress = emailAddress;
            this.triggerUserUpdateMessage();
            embraceSharedPreferences.setUserEmailAddress(emailAddress);
        }
    }

    void updatePayingUser(boolean payer, EmbraceSharedPreferences embraceSharedPreferences) throws EmbraceSdkException {
        if (payer != embraceSharedPreferences.isUserPayer()) {
            this.payer = payer;
            if (!payer) {
                this.removePersona(PERSONA_PAYER, embraceSharedPreferences);
            }
            this.triggerUserUpdateMessage();
            embraceSharedPreferences.setUserPayer(payer);
        }
    }

    Map<String, Object> mapRepresentation() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.internalIdentifier != null ? this.internalIdentifier : "");
        map.put("em", this.emailAddress != null ? this.emailAddress : "");
        Set<String> personas = this.userPersonas;
        if (this.payer) {
            personas.add(PERSONA_PAYER);
        }
        if (EmbraceSharedPreferences.getInstance().isFirstDay()) {
            personas.add(PERSONA_FIRST_DAY_USER);
            map.put("per", personas);
        }
        return map;
    }

    synchronized void updateServerPersonas(Set<String> personas, EmbraceSharedPreferences embraceSharedPreferences) throws EmbraceSdkException {
        this.allPersonas.addAll(personas);
        this.hasServerPersonas = true;
        embraceSharedPreferences.setCustomPersonas(personas);
        boolean personasChanged = false;
        HashSet<String> validPersonas = new HashSet<String>();
        for (String persona : this.invalidPersonas) {
            if (!personas.contains(persona)) continue;
            validPersonas.add(persona);
            personasChanged = true;
        }
        this.userPersonas.addAll(validPersonas);
        for (String nowValid : validPersonas) {
            this.invalidPersonas.remove(nowValid);
        }
        Iterator<String> iter = this.userPersonas.iterator();
        while (iter.hasNext()) {
            if (this.allPersonas.contains(iter.next())) continue;
            iter.remove();
            personasChanged = true;
        }
        embraceSharedPreferences.setUserPersonas(this.userPersonas);
        if (personasChanged) {
            this.triggerUserUpdateMessage();
        }
    }

    void setPersona(String persona, EmbraceSharedPreferences embraceSharedPreferences) throws EmbraceSdkException {
        if (this.userPersonas.contains(persona)) {
            return;
        }
        if (this.hasServerPersonas) {
            if (!this.allPersonas.contains(persona)) {
                if (this.buildConfig.isDebug()) {
                    EmbraceLogger.logWarning(String.format("persona %s is not on the registered list, ignoring", persona));
                }
                return;
            }
        } else if (!this.allPersonas.contains(persona)) {
            if (!this.personaIsAllowed(persona) && this.buildConfig.isDebug()) {
                EmbraceLogger.logWarning("personas must only consist of alphanumeric characters or underscores and be at most 16 characters");
                return;
            }
            this.invalidPersonas.add(persona);
            return;
        }
        this.userPersonas.add(persona);
        this.triggerUserUpdateMessage();
        embraceSharedPreferences.setUserPersonas(this.userPersonas);
    }

    void removePersona(String persona, EmbraceSharedPreferences embraceSharedPreferences) throws EmbraceSdkException {
        if (this.userPersonas.contains(persona)) {
            this.userPersonas.remove(persona);
            this.triggerUserUpdateMessage();
            embraceSharedPreferences.setUserPersonas(this.userPersonas);
        } else if (this.invalidPersonas.contains(persona)) {
            this.invalidPersonas.remove(persona);
        } else {
            EmbraceLogger.logDebug(String.format("persona %s is not currently set, ignoring", persona));
            return;
        }
    }

    private boolean personaIsAllowed(String persona) {
        return !TextUtils.isEmpty((CharSequence)persona) && persona.matches(PERSONA_REGEX);
    }

    void updateUsername(String username, EmbraceSharedPreferences embraceSharedPreferences) throws EmbraceSdkException {
        if (!TextUtils.equals((CharSequence)username, (CharSequence)embraceSharedPreferences.getUsername())) {
            this.username = username;
            this.triggerUserUpdateMessage();
            embraceSharedPreferences.setUsername(username);
            EmbraceLogger.logInfo(String.format("current user username updated: %s", username));
        }
    }

    private void triggerUserUpdateMessage() throws EmbraceSdkException {
        if (!this.userMessagePending) {
            this.userMessagePending = true;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.postDelayed(this.sendUserMessageCompletionRunnable(), 1000L);
        }
    }

    private Runnable sendUserMessageCompletionRunnable() throws EmbraceSdkException {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    EmbraceServer.getInstance().sendUserMessageCompletion(null);
                    User.this.userMessagePending = false;
                }
                catch (EmbraceSdkException e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, new EmbraceSdkException("error sending user message completion: " + e.getLocalizedMessage(), e));
                }
            }
        };
    }

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.internalIdentifier);
            jsonObject.put("em", (Object)this.emailAddress);
            jsonObject.put("un", (Object)this.username);
            JSONArray array = new JSONArray();
            if (this.payer) {
                this.userPersonas.add(PERSONA_PAYER);
            }
            if (this.embraceSharedPreferences.isFirstDay()) {
                this.userPersonas.add(PERSONA_FIRST_DAY_USER);
            }
            for (String s : this.userPersonas) {
                array.put((Object)s);
            }
            jsonObject.put("per", (Object)array);
        }
        catch (JSONException object) {
            jsonObject = null;
        }
        return jsonObject;
    }

    static {
        globalPersonas = new HashSet<String>(Arrays.asList(PERSONA_NEW_USER, PERSONA_POWER_USER, PERSONA_LOGGED_IN, PERSONA_VIP, PERSONA_CREATOR, PERSONA_TESTER));
        singleton = new User();
    }
}

