/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.EmbraceSharedPreferences;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SdkConfig {
    private static final int DEFAULT_THRESHOLD = 100;
    private static final int DEFAULT_OFFSET = 0;
    private int threshold = 100;
    private int offset = 0;
    private boolean screenshotsEnabled;
    private final Set<String> appPersonas = new HashSet<String>();
    private final Map<String, Long> eventLimits = new HashMap<String, Long>();
    private final Set<String> disabledMessageTypes = new HashSet<String>();
    private final Set<String> disabledEventAndLogPatterns = new HashSet<String>();
    private final Set<String> disabledUrlPatterns = new HashSet<String>();
    private final Set<String> disabledScreenshotPatterns = new HashSet<String>();

    int getThreshold() {
        return this.threshold;
    }

    boolean isScreenshotsEnabled() {
        return this.screenshotsEnabled;
    }

    Set<String> getAppPersonas() {
        return this.appPersonas;
    }

    Map<String, Long> getEventLimits() {
        return this.eventLimits;
    }

    Set<String> getDisabledMessageTypes() {
        return this.disabledMessageTypes;
    }

    Set<String> getDisabledEventAndLogPatterns() {
        return this.disabledEventAndLogPatterns;
    }

    Set<String> getDisabledUrlPatterns() {
        return this.disabledUrlPatterns;
    }

    Set<String> getDisabledScreenshotPatterns() {
        return this.disabledScreenshotPatterns;
    }

    SdkConfig(JSONObject config) throws EmbraceSdkException {
        try {
            int idx;
            JSONArray array;
            if (config.has("threshold")) {
                this.threshold = config.getInt("threshold");
            }
            if (config.has("offset")) {
                this.offset = config.getInt("offset");
            }
            if (config.has("screenshots_enabled")) {
                this.screenshotsEnabled = config.getBoolean("screenshots_enabled");
            } else {
                EmbraceLogger.logWarning("enable screenshot field not present in config");
                this.screenshotsEnabled = true;
            }
            if (config.has("personas")) {
                array = config.getJSONArray("personas");
                for (idx = 0; idx < array.length(); ++idx) {
                    this.appPersonas.add(array.getString(idx));
                }
            }
            if (config.has("event_limits")) {
                JSONObject eventLimitsJsonObject = config.getJSONObject("event_limits");
                Iterator eventLimitKeysIterator = eventLimitsJsonObject.keys();
                while (eventLimitKeysIterator.hasNext()) {
                    String key = (String)eventLimitKeysIterator.next();
                    this.eventLimits.put(key, eventLimitsJsonObject.getLong(key));
                }
            }
            if (config.has("disabled_message_types")) {
                array = config.getJSONArray("disabled_message_types");
                for (idx = 0; idx < array.length(); ++idx) {
                    this.disabledMessageTypes.add(array.getString(idx));
                }
            }
            if (config.has("disabled_event_and_log_patterns")) {
                array = config.getJSONArray("disabled_event_and_log_patterns");
                for (idx = 0; idx < array.length(); ++idx) {
                    this.disabledEventAndLogPatterns.add(array.getString(idx));
                }
            }
            if (config.has("disabled_url_patterns")) {
                array = config.getJSONArray("disabled_url_patterns");
                for (idx = 0; idx < array.length(); ++idx) {
                    this.disabledUrlPatterns.add(array.getString(idx));
                }
            }
            if (config.has("disabled_screenshot_patterns")) {
                array = config.getJSONArray("disabled_screenshot_patterns");
                for (idx = 0; idx < array.length(); ++idx) {
                    this.disabledScreenshotPatterns.add(array.getString(idx));
                }
            }
        }
        catch (JSONException e) {
            EmbraceLogger.logWarning("Unable to convert JSON to object");
            throw new EmbraceSdkException("Unable to convert JSON to object", e);
        }
    }

    String encodeObjectForSaving() throws EmbraceSdkException {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("threshold", this.threshold);
            jsonObject.put("offset", this.offset);
            jsonObject.put("screenshots_enabled", this.screenshotsEnabled);
            jsonObject.put("event_limits", (Object)new JSONObject(this.eventLimits));
            JSONArray appPersonasArray = new JSONArray();
            for (String string : this.appPersonas) {
                appPersonasArray.put((Object)string);
            }
            jsonObject.put("personas", (Object)appPersonasArray);
            JSONArray disabledMessageTypesArray = new JSONArray();
            for (String string : this.disabledMessageTypes) {
                disabledMessageTypesArray.put((Object)string);
            }
            jsonObject.put("disabled_message_types", (Object)disabledMessageTypesArray);
            JSONArray jSONArray = new JSONArray();
            for (String string : this.disabledEventAndLogPatterns) {
                jSONArray.put((Object)string);
            }
            jsonObject.put("disabled_event_and_log_patterns", (Object)jSONArray);
            JSONArray jSONArray2 = new JSONArray();
            for (String disabledUrlPattern : this.disabledUrlPatterns) {
                jSONArray2.put((Object)disabledUrlPattern);
            }
            jsonObject.put("disabled_url_patterns", (Object)jSONArray2);
            JSONArray jSONArray3 = new JSONArray();
            for (String disabledEventAndLogPattern : this.disabledScreenshotPatterns) {
                jSONArray.put((Object)disabledEventAndLogPattern);
            }
            jsonObject.put("disabled_screenshot_patterns", (Object)jSONArray3);
        }
        catch (JSONException e) {
            EmbraceLogger.logWarning("Unable to convert object to JSON");
            throw new EmbraceSdkException("Unable to convert object to JSON", e);
        }
        return jsonObject.toString();
    }

    boolean isEnabled(EmbraceSharedPreferences embraceSharedPreferences) {
        int upperBound;
        String deviceId = embraceSharedPreferences.getDeviceId();
        if (deviceId == null || deviceId.length() < 2) {
            return false;
        }
        String finalChars = deviceId.substring(deviceId.length() - 2);
        float result = (float)Integer.valueOf(finalChars, 16).intValue() / 255.0f * 100.0f;
        int lowerBound = Math.max(0, this.offset);
        return lowerBound != (upperBound = Math.min(this.offset + this.threshold, 100)) && (float)lowerBound <= result && (float)upperBound >= result;
    }
}

