/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceServer;
import io.embrace.android.embracesdk.FilterableUtils;
import io.embrace.android.embracesdk.FixedSizeDeque;
import io.embrace.android.embracesdk.IInterval;
import io.embrace.android.embracesdk.IntervalMeasurement;
import io.embrace.android.embracesdk.NetworkCall;
import io.embrace.android.embracesdk.NetworkChangeBroadcastReceiver;
import io.embrace.android.embracesdk.Session;
import java.util.ArrayList;
import java.util.List;

class NetworkManager {
    private static final NetworkManager manager = new NetworkManager();
    private static final int NETWORK_LOG_MAX = 500;
    private NetworkStatus networkStatus;
    private boolean isManagerEnabled = false;
    private List<IInterval> reachabilityIntervals = new ArrayList<IInterval>();
    private FixedSizeDeque<IInterval> networkPerformances = new FixedSizeDeque(500);
    private BroadcastReceiver broadcastReceiver;

    static NetworkManager getManager() {
        return manager;
    }

    private NetworkManager() {
    }

    void logNetworkCall(String url, String httpMethod, Integer statusCode, long startTime, long endTime, Long bytesSent, Long bytesReceived) throws InterruptedException {
        if (NetworkCall.validateNetworkCall(statusCode, startTime, endTime)) {
            this.networkPerformances.forcePutLast(new NetworkCall(url, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived));
        }
    }

    void logNetworkError(String url, String httpMethod, long startTime, long endTime, String errorType, String errorMessage) throws InterruptedException {
        if (NetworkCall.validateNetworkCall(null, startTime, endTime)) {
            this.networkPerformances.forcePutLast(new NetworkCall(url, httpMethod, startTime, endTime, errorType, errorMessage));
        }
    }

    private void updateConnectivityWithStatus(NetworkStatus networkStatus) {
        IntervalMeasurement interval;
        if (this.networkStatus == networkStatus) {
            return;
        }
        this.networkStatus = networkStatus;
        if (!this.reachabilityIntervals.isEmpty()) {
            interval = (IntervalMeasurement)this.reachabilityIntervals.get(this.reachabilityIntervals.size() - 1);
            interval.endInterval();
        }
        interval = new IntervalMeasurement(this.getNameForNetworkStatus(networkStatus));
        this.reachabilityIntervals.add(interval);
    }

    private void handleReachabilityChange(String reachability) {
        this.updateConnectivityWithStatus(this.getNetworkStatusForName(reachability));
    }

    List<IntervalMeasurement> getReachabilityIntervalsBetween(long startTime, long endTime) {
        return FilterableUtils.filter(this.reachabilityIntervals, startTime, endTime);
    }

    List<IntervalMeasurement> getReachabilityIntervalsDuringSession(Session session) {
        return this.getReachabilityIntervalsBetween(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    List<NetworkCall> getRequestsBetween(long startTime, long endTime) {
        return FilterableUtils.filter(new ArrayList<IInterval>(this.networkPerformances), startTime, endTime);
    }

    List<NetworkCall> getRequestsDuringSession(Session session) {
        return this.getRequestsBetween(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    private String getNameForNetworkStatus(NetworkStatus networkStatus) {
        switch (networkStatus) {
            case NOT_REACHABLE: {
                return "none";
            }
            case WIFI: {
                return "wifi";
            }
            case WAN: {
                return "wan";
            }
        }
        return "";
    }

    private NetworkStatus getNetworkStatusForName(String name) {
        switch (name) {
            case "wifi": {
                return NetworkStatus.WIFI;
            }
            case "wan": {
                return NetworkStatus.WAN;
            }
        }
        return NetworkStatus.NOT_REACHABLE;
    }

    private void registerReceiver() {
        if (this.broadcastReceiver == null) {
            this.broadcastReceiver = new NetworkChangeBroadcastReceiver();
            IntentFilter iFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            Embrace.getContext().registerReceiver(this.broadcastReceiver, iFilter);
        }
    }

    private void unregisterReceiver() {
        if (this.broadcastReceiver != null) {
            Embrace.getContext().unregisterReceiver(this.broadcastReceiver);
            this.broadcastReceiver = null;
        }
    }

    synchronized void enable() {
        if (!this.isManagerEnabled) {
            this.isManagerEnabled = true;
            this.updateNetworkState((ConnectivityManager)Embrace.getContext().getSystemService("connectivity"));
            this.registerReceiver();
        }
    }

    synchronized void disable() {
        if (this.isManagerEnabled) {
            this.unregisterReceiver();
            this.networkPerformances.clear();
            this.reachabilityIntervals.clear();
            this.networkStatus = null;
            this.isManagerEnabled = false;
        }
    }

    synchronized void updateNetworkState(ConnectivityManager connectivityManager) {
        if (this.isManagerEnabled) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                EmbraceServer.getInstance().handleNetworkReachable();
                switch (networkInfo.getType()) {
                    case 1: {
                        this.handleReachabilityChange("wifi");
                        break;
                    }
                    case 0: {
                        this.handleReachabilityChange("wan");
                        break;
                    }
                }
            } else {
                this.handleReachabilityChange("none");
            }
        }
    }

    private static enum NetworkStatus {
        NOT_REACHABLE,
        WIFI,
        WAN;

    }
}

