/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceManager;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class Device {
    private static final String OS_VERSION = "Android OS";
    private static final String SDK_SIMPLE_VERSION = "16";
    private Calendar calendar = Calendar.getInstance();
    private static final Device singleton = new Device();

    private Device() {
    }

    static Device getInstance() {
        return singleton;
    }

    String getAppVersion() {
        try {
            PackageManager packageManager = Embrace.getContext().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(Embrace.getContext().getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    String getAppPackageName() {
        try {
            PackageManager packageManager = Embrace.getContext().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(Embrace.getContext().getPackageName(), 0);
            return packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private String getEnvironment() {
        boolean isDebuggable = 0 != (Embrace.getContext().getApplicationInfo().flags & 2);
        return isDebuggable ? "dev" : "prod";
    }

    private String getBundleVersion() {
        try {
            PackageManager packageManager = Embrace.getContext().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(Embrace.getContext().getPackageName(), 0);
            return String.valueOf(packageInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private String getManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getModel() {
        return Build.MODEL;
    }

    private String getArchitecture() {
        return Build.VERSION.SDK_INT >= 21 ? Build.SUPPORTED_ABIS[0] : Build.CPU_ABI;
    }

    private String getLocale() {
        return Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
    }

    private String getOperatingSystemType() {
        return OS_VERSION;
    }

    public String getOperatingSystemVersion() {
        return String.valueOf(Build.VERSION.RELEASE);
    }

    public int getOperatingSystemVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    public String getOperatingSystemVersionForRequest() {
        return String.format(Locale.US, "%d.0.0", Build.VERSION.SDK_INT);
    }

    private Long getSystemUptime() {
        return SystemClock.uptimeMillis();
    }

    private String getScreenResolution() {
        WindowManager manager = (WindowManager)Embrace.getContext().getSystemService("window");
        Display display = manager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return String.format(Locale.US, "%dx%d", displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    private String getTimezoneDescription() {
        return this.calendar.getTimeZone().getID();
    }

    JSONObject getSystemMemoryAsJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("fs", this.getInternalStorageFreeCapacity());
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    private long getInternalStorageTotalCapacity() {
        StatFs statFsInternal = Device.getStats();
        if (Build.VERSION.SDK_INT >= 18) {
            return statFsInternal.getTotalBytes();
        }
        return (long)statFsInternal.getBlockCount() * (long)statFsInternal.getBlockSize();
    }

    private long getInternalStorageFreeCapacity() {
        StatFs statFsInternal = Device.getStats();
        if (Build.VERSION.SDK_INT >= 18) {
            return statFsInternal.getFreeBytes();
        }
        return (long)statFsInternal.getFreeBlocks() * (long)statFsInternal.getBlockSize();
    }

    private static StatFs getStats() {
        return new StatFs(Environment.getDataDirectory().getPath());
    }

    private static boolean getIsJailbroken() {
        String[] places;
        if (Device.isEmulator()) {
            return false;
        }
        boolean found = false;
        for (String where : places = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"}) {
            if (!new File(where + "su").exists()) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    String getVersionCodeForRequest() {
        try {
            PackageManager packageManager = Embrace.getContext().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(Embrace.getContext().getPackageName(), 0);
            return String.format(Locale.US, "%d.0.0", packageInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    JSONObject getTelephonyInfo() {
        TelephonyManager telephonyManager = (TelephonyManager)Embrace.getContext().getSystemService("phone");
        JSONObject infoObject = new JSONObject();
        try {
            infoObject.put("cn", (Object)telephonyManager.getNetworkOperatorName());
            infoObject.put("ci", (Object)telephonyManager.getNetworkCountryIso());
            infoObject.put("cc", (Object)(!TextUtils.isEmpty((CharSequence)telephonyManager.getNetworkOperator()) ? telephonyManager.getNetworkOperator().substring(0, 3) : ""));
            infoObject.put("ce", (Object)(!TextUtils.isEmpty((CharSequence)telephonyManager.getNetworkOperator()) ? telephonyManager.getNetworkOperator().substring(3) : ""));
        }
        catch (JSONException e) {
            infoObject = null;
        }
        return infoObject;
    }

    JSONObject getDeviceInfoJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("dm", (Object)this.getManufacturer());
            jsonObject.put("do", (Object)this.getModel());
            jsonObject.put("da", (Object)this.getArchitecture());
            jsonObject.put("jb", Device.getIsJailbroken());
            jsonObject.put("lc", (Object)this.getLocale());
            jsonObject.put("ms", this.getInternalStorageTotalCapacity());
            jsonObject.put("os", (Object)this.getOperatingSystemType());
            jsonObject.put("ov", (Object)this.getOperatingSystemVersion());
            jsonObject.put("oc", this.getOperatingSystemVersionCode());
            jsonObject.put("sr", (Object)this.getScreenResolution());
            jsonObject.put("tz", (Object)this.getTimezoneDescription());
            jsonObject.put("up", (Object)this.getSystemUptime());
        }
        catch (JSONException exception) {
            jsonObject = null;
        }
        return jsonObject;
    }

    JSONObject getAppInfoJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("v", (Object)this.getAppVersion());
            jsonObject.put("e", (Object)this.getEnvironment());
            jsonObject.put("vu", EmbraceManager.getInstance().isAppUpdated());
            jsonObject.put("bv", (Object)(this.getBundleVersion() != null ? this.getBundleVersion() : ""));
            jsonObject.put("ou", EmbraceManager.getInstance().osUpdated());
            jsonObject.put("sdk", (Object)EmbraceManager.getInstance().getEmbraceVersionString());
            jsonObject.put("sdc", (Object)SDK_SIMPLE_VERSION);
        }
        catch (JSONException exception) {
            jsonObject = null;
        }
        return jsonObject;
    }

    Map getDeviceInfoMapObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dm", this.getManufacturer());
        map.put("do", this.getModel());
        map.put("da", this.getArchitecture());
        map.put("jb", Device.getIsJailbroken());
        map.put("lc", this.getLocale());
        map.put("ms", this.getInternalStorageTotalCapacity());
        map.put("os", this.getOperatingSystemType());
        map.put("ov", this.getOperatingSystemVersion());
        map.put("sr", this.getScreenResolution());
        map.put("tz", this.getTimezoneDescription());
        map.put("up", this.getSystemUptime());
        return map;
    }

    Map getAppInfoMapObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("v", this.getAppVersion());
        map.put("e", this.getEnvironment());
        map.put("vu", EmbraceManager.getInstance().isAppUpdated());
        map.put("bv", this.getBundleVersion() != null ? this.getBundleVersion() : "");
        map.put("ou", EmbraceManager.getInstance().osUpdated());
        map.put("sdk", EmbraceManager.getInstance().getEmbraceVersionString());
        map.put("sdc", SDK_SIMPLE_VERSION);
        return map;
    }
}

