/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.swazzle.callback.android.app;

import android.os.Bundle;
import android.support.v4.view.GestureDetectorCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import io.embrace.android.embracesdk.ApplicationStateManager;
import io.embrace.android.embracesdk.BreadcrumbManager;
import io.embrace.android.embracesdk.GestureListener;
import io.embrace.android.embracesdk.swazzle.SwazzleContext;
import java.util.Calendar;

public final class Activity {
    private static GestureDetectorCompat gestureDetectorCompat;

    public static void _preDispatchTouchEvent(android.app.Activity activity, MotionEvent event) {
        if (gestureDetectorCompat != null) {
            gestureDetectorCompat.onTouchEvent(event);
        }
    }

    public static void _preOnCreate(android.app.Activity activity, Bundle bundle) {
        Activity.enableApplicationStateManager(activity.getComponentName().getClassName());
    }

    public static void _preOnStart(android.app.Activity activity) {
        Activity.enableApplicationStateManager(activity.getComponentName().getClassName());
        if (SwazzleContext.containsKey("breadcrumb_manager")) {
            ((BreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).logView(activity.getClass().getName(), Calendar.getInstance().getTimeInMillis());
        }
    }

    public static void _preOnPause(android.app.Activity activity) {
        gestureDetectorCompat = null;
    }

    public static void _preOnResume(android.app.Activity activity) {
        if (gestureDetectorCompat == null) {
            GestureListener gestureListener = new GestureListener(activity);
            gestureDetectorCompat = new GestureDetectorCompat(activity.getApplicationContext(), (GestureDetector.OnGestureListener)gestureListener);
            gestureDetectorCompat.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)gestureListener);
        }
    }

    public static void _postOnStop(android.app.Activity activity) {
        Activity.disableApplicationStateManager(activity.getComponentName().getClassName());
    }

    public static void _postOnDestroy(android.app.Activity activity) {
        Activity.disableApplicationStateManager(activity.getComponentName().getClassName());
    }

    private static void disableApplicationStateManager(String activityName) {
        if (SwazzleContext.containsKey("application_state_manager")) {
            ApplicationStateManager applicationStateManager = (ApplicationStateManager)SwazzleContext.get("application_state_manager");
            applicationStateManager.disable(activityName);
        }
    }

    private static void enableApplicationStateManager(String activityName) {
        if (SwazzleContext.containsKey("application_state_manager")) {
            ApplicationStateManager applicationStateManager = (ApplicationStateManager)SwazzleContext.get("application_state_manager");
            applicationStateManager.enable(activityName);
        }
    }
}

