/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import io.embrace.android.embracesdk.Device;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.helpers.SharedPreferencesUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class EmbraceSharedPreferences {
    static final long DAY_IN_MS = 86400000L;
    static final String PREVIOUS_APP_VERSION_KEY = "io.embrace.lastappversion";
    static final String PREVIOUS_OS_VERSION_KEY = "io.embrace.lastosversion";
    static final String INSTALL_DATE_KEY = "io.embrace.installtimestamp";
    private static final String USER_IDENTIFIER_KEY = "io.embrace.userid";
    private static final String USER_EMAIL_ADDRESS_KEY = "io.embrace.useremail";
    private static final String USER_USERNAME_KEY = "io.embrace.username";
    private static final String USER_IS_PAYER_KEY = "io.embrace.userispayer";
    private static final String USER_PERSONAS_KEY = "io.embrace.userpersonas";
    private static final String CUSTOM_PERSONAS_KEY = "io.embrace.custompersonas";
    private static final String LAST_USER_MESSAGE_FAILED_KEY = "io.embrace.userupdatefailed";
    private static final String DEVICE_IDENTIFIER_KEY = "io.embrace.deviceid";
    private static final String SDK_DISABLED_KEY = "io.embrace.disabled";
    private static final String SDK_STARTUP_STATUS_KEY = "io.embrace.sdkstartup";
    private static final String SDK_STARTUP_IN_PROGRESS = "startup_entered";
    private static final String SDK_CONFIG_FETCHED_TIMESTAMP = "io.embrace.sdkfetchedtimestamp";
    private static final String SDK_STARTUP_COMPLETED = "startup_completed";
    private static final EmbraceSharedPreferences singleton = new EmbraceSharedPreferences();
    private String deviceId;

    private EmbraceSharedPreferences() {
        if (Embrace.getContext() != null) {
            String secureId = Settings.Secure.getString((ContentResolver)Embrace.getContext().getContentResolver(), (String)"android_id");
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (messageDigest != null && secureId != null) {
                messageDigest.update(secureId.getBytes(), 0, secureId.length());
                this.deviceId = new BigInteger(1, messageDigest.digest()).toString(16).toUpperCase(Locale.getDefault());
            } else {
                this.deviceId = secureId;
            }
        }
    }

    static EmbraceSharedPreferences getInstance() {
        return singleton;
    }

    String getDeviceId() {
        return this.deviceId;
    }

    boolean isUserPayer() {
        return SharedPreferencesUtils.getBooleanPreference(Embrace.getContext(), USER_IS_PAYER_KEY, false);
    }

    String userIdentifier() {
        return SharedPreferencesUtils.getStringPreference(Embrace.getContext(), USER_IDENTIFIER_KEY);
    }

    String userEmailAddress() {
        return SharedPreferencesUtils.getStringPreference(Embrace.getContext(), USER_EMAIL_ADDRESS_KEY);
    }

    Set<String> userPersonas() {
        return SharedPreferencesUtils.getArrayPreference(Embrace.getContext(), USER_PERSONAS_KEY, null);
    }

    Set<String> customPersonas() {
        return SharedPreferencesUtils.getArrayPreference(Embrace.getContext(), CUSTOM_PERSONAS_KEY, null);
    }

    String getUsername() {
        return SharedPreferencesUtils.getStringPreference(Embrace.getContext(), USER_USERNAME_KEY);
    }

    void setUserPayer(boolean payer) {
        SharedPreferencesUtils.setBooleanPreference(Embrace.getContext(), USER_IS_PAYER_KEY, payer);
    }

    void setUserIdentifier(String identifier) {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), USER_IDENTIFIER_KEY, identifier);
    }

    void setUserEmailAddress(String emailAddress) {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), USER_EMAIL_ADDRESS_KEY, emailAddress);
    }

    void setUserPersonas(Set<String> personas) {
        SharedPreferencesUtils.setArrayPreference(Embrace.getContext(), USER_PERSONAS_KEY, personas);
    }

    void setCustomPersonas(Set<String> personas) {
        SharedPreferencesUtils.setArrayPreference(Embrace.getContext(), CUSTOM_PERSONAS_KEY, personas);
    }

    void setUsername(String username) {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), USER_USERNAME_KEY, username);
    }

    public Map<String, Object> appAndUserData(Context context) {
        String appVersion = SharedPreferencesUtils.getStringPreference(context, PREVIOUS_APP_VERSION_KEY);
        Integer osVersion = SharedPreferencesUtils.getIntegerPreference(context, PREVIOUS_OS_VERSION_KEY, -1);
        String userDefaultsDeviceIdentifier = SharedPreferencesUtils.getStringPreference(context, DEVICE_IDENTIFIER_KEY);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (appVersion != null) {
            map.put("av", appVersion);
        }
        if (osVersion != -1) {
            map.put("os", osVersion);
        }
        if (userDefaultsDeviceIdentifier != null) {
            map.put("uid", userDefaultsDeviceIdentifier);
        }
        return map;
    }

    void updateAppAndUserData() {
        Device device = Device.getInstance();
        String appVersion = device.getAppVersion();
        String osVersion = device.getOperatingSystemVersion();
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), PREVIOUS_APP_VERSION_KEY, appVersion);
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), PREVIOUS_OS_VERSION_KEY, osVersion);
        if (SharedPreferencesUtils.getLongPreference(Embrace.getContext(), INSTALL_DATE_KEY, -1L) == -1L) {
            SharedPreferencesUtils.setLongPreference(Embrace.getContext(), INSTALL_DATE_KEY, Calendar.getInstance().getTimeInMillis());
        }
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), DEVICE_IDENTIFIER_KEY, this.getDeviceId());
    }

    boolean isAppUpdated() {
        String cachedVersion;
        String currentVersion = Device.getInstance().getAppVersion();
        return !currentVersion.equals(cachedVersion = SharedPreferencesUtils.getStringPreference(Embrace.getContext(), PREVIOUS_APP_VERSION_KEY));
    }

    boolean osUpdated() {
        String osVersion = Device.getInstance().getOperatingSystemVersion();
        String cachedVersion = SharedPreferencesUtils.getStringPreference(Embrace.getContext(), PREVIOUS_OS_VERSION_KEY);
        return cachedVersion != null && !osVersion.equals(cachedVersion);
    }

    boolean isFirstDay() {
        long installDate = SharedPreferencesUtils.getLongPreference(Embrace.getContext(), INSTALL_DATE_KEY, -1L);
        return installDate != -1L ? Calendar.getInstance().getTimeInMillis() - installDate <= 86400000L : false;
    }

    boolean sdkDisabledFromSavedConfig() {
        return SharedPreferencesUtils.getBooleanPreference(Embrace.getContext(), SDK_DISABLED_KEY, false);
    }

    boolean sdkStartupFailedLastSession() {
        String lastSessionProgress = SharedPreferencesUtils.getStringPreference(Embrace.getContext(), SDK_STARTUP_STATUS_KEY);
        if (lastSessionProgress == null) {
            return false;
        }
        return !lastSessionProgress.equals(SDK_STARTUP_COMPLETED);
    }

    void recordStartupBegun() {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), SDK_STARTUP_STATUS_KEY, SDK_STARTUP_IN_PROGRESS);
    }

    void recordStartupCompleted() {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), SDK_STARTUP_STATUS_KEY, SDK_STARTUP_COMPLETED);
    }

    synchronized void setSdkDisabled(boolean disabled) {
        SharedPreferencesUtils.setBooleanPreference(Embrace.getContext(), SDK_DISABLED_KEY, disabled);
    }

    boolean userMessageNeedsRetry() {
        return SharedPreferencesUtils.getBooleanPreference(Embrace.getContext(), LAST_USER_MESSAGE_FAILED_KEY, false);
    }

    synchronized void setUserMessageNeedsRetry(boolean needsRetry) {
        SharedPreferencesUtils.setBooleanPreference(Embrace.getContext(), LAST_USER_MESSAGE_FAILED_KEY, needsRetry);
    }

    synchronized void updateSdkConfigFetchedTimestamp(long timestamp) {
        SharedPreferencesUtils.setLongPreference(Embrace.getContext(), SDK_CONFIG_FETCHED_TIMESTAMP, timestamp);
    }

    long getConfigFetchTimestamp() {
        return SharedPreferencesUtils.getLongPreference(Embrace.getContext(), SDK_CONFIG_FETCHED_TIMESTAMP, -1L);
    }
}

