/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import android.annotation.TargetApi;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class EmbraceHttpsUrlConnection<Connection extends HttpsURLConnection>
extends HttpsURLConnection {
    protected final Connection connection;
    final long createdTime;
    volatile boolean didLogNetworkCall = false;

    public EmbraceHttpsUrlConnection(Connection connection) {
        super(((URLConnection)connection).getURL());
        this.connection = connection;
        this.createdTime = System.currentTimeMillis();
    }

    @Override
    public void addRequestProperty(String key, String value) {
        ((URLConnection)this.connection).addRequestProperty(key, value);
    }

    @Override
    public void connect() throws IOException {
        ((URLConnection)this.connection).connect();
    }

    @Override
    public void disconnect() {
        ((HttpURLConnection)this.connection).disconnect();
        this.logNetworkCall(this.createdTime);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return ((URLConnection)this.connection).getAllowUserInteraction();
    }

    @Override
    public String getCipherSuite() {
        return ((HttpsURLConnection)this.connection).getCipherSuite();
    }

    @Override
    public int getConnectTimeout() {
        return ((URLConnection)this.connection).getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        return ((URLConnection)this.connection).getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return ((URLConnection)this.connection).getContent(classes);
    }

    @Override
    public String getContentEncoding() {
        return ((URLConnection)this.connection).getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return ((URLConnection)this.connection).getContentLength();
    }

    @Override
    @TargetApi(value=24)
    public long getContentLengthLong() {
        return ((URLConnection)this.connection).getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return ((URLConnection)this.connection).getContentType();
    }

    @Override
    public long getDate() {
        return ((URLConnection)this.connection).getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return ((URLConnection)this.connection).getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return ((URLConnection)this.connection).getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return ((URLConnection)this.connection).getDoOutput();
    }

    @Override
    public InputStream getErrorStream() {
        long startTime = System.currentTimeMillis();
        InputStream in = ((HttpURLConnection)this.connection).getErrorStream();
        this.logNetworkCall(startTime);
        return in;
    }

    @Override
    public long getExpiration() {
        return ((URLConnection)this.connection).getExpiration();
    }

    @Override
    public String getHeaderField(int n) {
        long startTime = System.currentTimeMillis();
        String headerField = ((HttpURLConnection)this.connection).getHeaderField(n);
        this.logNetworkCall(startTime);
        return headerField;
    }

    @Override
    public String getHeaderField(String name) {
        long startTime = System.currentTimeMillis();
        String headerField = ((URLConnection)this.connection).getHeaderField(name);
        this.logNetworkCall(startTime);
        return headerField;
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        return ((HttpURLConnection)this.connection).getHeaderFieldDate(name, defaultValue);
    }

    @Override
    public int getHeaderFieldInt(String name, int defaultValue) {
        return ((URLConnection)this.connection).getHeaderFieldInt(name, defaultValue);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        long startTime = System.currentTimeMillis();
        String headerFieldKey = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        this.logNetworkCall(startTime);
        return headerFieldKey;
    }

    @Override
    @TargetApi(value=24)
    public long getHeaderFieldLong(String name, long defaultValue) {
        return ((URLConnection)this.connection).getHeaderFieldLong(name, defaultValue);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        long startTime = System.currentTimeMillis();
        Map<String, List<String>> headerFields = ((URLConnection)this.connection).getHeaderFields();
        this.logNetworkCall(startTime);
        return headerFields;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return ((HttpsURLConnection)this.connection).getHostnameVerifier();
    }

    @Override
    public long getIfModifiedSince() {
        return ((URLConnection)this.connection).getIfModifiedSince();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        long startTime = System.currentTimeMillis();
        InputStream in = ((URLConnection)this.connection).getInputStream();
        this.logNetworkCall(startTime);
        return in;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return ((HttpURLConnection)this.connection).getInstanceFollowRedirects();
    }

    @Override
    public long getLastModified() {
        return ((URLConnection)this.connection).getLastModified();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return ((HttpsURLConnection)this.connection).getLocalCertificates();
    }

    @Override
    public Principal getLocalPrincipal() {
        return ((HttpsURLConnection)this.connection).getLocalPrincipal();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return ((URLConnection)this.connection).getOutputStream();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return ((HttpsURLConnection)this.connection).getPeerPrincipal();
    }

    @Override
    public Permission getPermission() throws IOException {
        return ((HttpURLConnection)this.connection).getPermission();
    }

    @Override
    public int getReadTimeout() {
        return ((URLConnection)this.connection).getReadTimeout();
    }

    @Override
    public String getRequestMethod() {
        return ((HttpURLConnection)this.connection).getRequestMethod();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return ((URLConnection)this.connection).getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return ((URLConnection)this.connection).getRequestProperty(key);
    }

    @Override
    public int getResponseCode() throws IOException {
        long startTime = System.currentTimeMillis();
        int responseCode = ((HttpURLConnection)this.connection).getResponseCode();
        this.logNetworkCall(startTime);
        return responseCode;
    }

    @Override
    public String getResponseMessage() throws IOException {
        long startTime = System.currentTimeMillis();
        String responseMsg = ((HttpURLConnection)this.connection).getResponseMessage();
        this.logNetworkCall(startTime);
        return responseMsg;
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return ((HttpsURLConnection)this.connection).getServerCertificates();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return ((HttpsURLConnection)this.connection).getSSLSocketFactory();
    }

    @Override
    public URL getURL() {
        return ((URLConnection)this.connection).getURL();
    }

    @Override
    public boolean getUseCaches() {
        return ((URLConnection)this.connection).getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        ((URLConnection)this.connection).setAllowUserInteraction(allowUserInteraction);
    }

    @Override
    public void setChunkedStreamingMode(int chunkLen) {
        ((HttpURLConnection)this.connection).setChunkedStreamingMode(chunkLen);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        ((URLConnection)this.connection).setConnectTimeout(timeout);
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        ((URLConnection)this.connection).setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public void setDoInput(boolean doInput) {
        ((URLConnection)this.connection).setDoInput(doInput);
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        ((URLConnection)this.connection).setDoOutput(doOutput);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
    }

    @Override
    @TargetApi(value=19)
    public void setFixedLengthStreamingMode(long contentLength) {
        ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier verifier) {
        ((HttpsURLConnection)this.connection).setHostnameVerifier(verifier);
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        ((URLConnection)this.connection).setIfModifiedSince(ifModifiedSince);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        ((HttpURLConnection)this.connection).setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void setReadTimeout(int timeout) {
        ((URLConnection)this.connection).setReadTimeout(timeout);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        ((HttpURLConnection)this.connection).setRequestMethod(method);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        ((URLConnection)this.connection).setRequestProperty(key, value);
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory factory) {
        ((HttpsURLConnection)this.connection).setSSLSocketFactory(factory);
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        ((URLConnection)this.connection).setUseCaches(useCaches);
    }

    @Override
    public String toString() {
        return ((URLConnection)this.connection).toString();
    }

    @Override
    public boolean usingProxy() {
        return ((HttpURLConnection)this.connection).usingProxy();
    }

    synchronized void logNetworkCall(long startTime) {
        this.logNetworkCall(startTime, System.currentTimeMillis());
    }

    synchronized void logNetworkCall(long startTime, long endTime) {
        if (!this.didLogNetworkCall) {
            this.didLogNetworkCall = true;
            try {
                Embrace.getInstance().logNetworkCall(this.getURL().toString(), HttpMethod.fromString(this.getRequestMethod()), this.getResponseCode(), startTime, endTime, 0L, Math.max(this.getContentLength(), 0));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

