/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import io.embrace.android.embracesdk.ApplicationStateManager;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.BreadcrumbManager;
import io.embrace.android.embracesdk.Device;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.EmbraceServer;
import io.embrace.android.embracesdk.FileUtils;
import io.embrace.android.embracesdk.IntervalMeasurement;
import io.embrace.android.embracesdk.MemoryManager;
import io.embrace.android.embracesdk.MemorySample;
import io.embrace.android.embracesdk.NetworkInfo;
import io.embrace.android.embracesdk.NetworkManager;
import io.embrace.android.embracesdk.NetworkPerformance;
import io.embrace.android.embracesdk.PowerManager;
import io.embrace.android.embracesdk.ProcessManager;
import io.embrace.android.embracesdk.Screenshot;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SystemEvent;
import io.embrace.android.embracesdk.SystemUtils;
import io.embrace.android.embracesdk.User;
import io.embrace.android.embracesdk.constants.EmbraceApiConstants;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import io.embrace.android.embracesdk.helpers.FileCache;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SessionManager {
    private static final long SHUTDOWN_TIMEOUT_MS = 2000L;
    private static final String SESSION_INFO_UUID_KEY = "id";
    private static final String SESSION_INFO_NUMBER_KEY = "num";
    private static final String SESSION_TERMINATION_RECEIVED_STRING = "yes";
    private static final int SESSION_HEARTBEAT_INTERVAL_IN_SECONDS = 5;
    private static final int SCREENSHOT_COOLDOWN_INTERVAL_IN_MILLISECONDS = 3000;
    private static final int SCREENSHOT_JPEG_COMPRESSION_VALUE = 70;
    static final SessionManager manager = new SessionManager();
    private boolean lastSessionReceivedTermination;
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private final Map<String, Session> unsentSessions = new HashMap<String, Session>();
    private Session currentSession;
    private Session lastSession;
    private boolean recentScreenshotTaken;
    private boolean isManagerEnabled = false;
    private Future sessionHeartbeatTimer;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private Runnable sendSessionRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                SessionManager.this.sendPreviousSession();
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("Error while sending session", e);
            }
        }
    };
    private Runnable processSessionHeartbeatRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                SessionManager.this.processSessionHeartbeat();
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("error while processing session heartbeat", e);
            }
        }
    };

    private SessionManager() {
    }

    synchronized void performStartup(boolean inBackground) throws EmbraceSdkException {
        String terminationLog = FileUtils.readStringFromFile(FileCache.TERMINATION_MESSAGE);
        if (SESSION_TERMINATION_RECEIVED_STRING.equals(terminationLog)) {
            this.lastSessionReceivedTermination = true;
        }
        FileUtils.removeFileAtPath(FileCache.TERMINATION_MESSAGE);
        this.checkForUnsentSessions(this.lastSessionReceivedTermination);
        if (!inBackground) {
            this.createSession();
        }
    }

    private void createSession() throws EmbraceSdkException {
        Session newSession;
        if (this.currentSession != null) {
            EmbraceLogger.logWarning("tried to create a new session but a current session exists");
            this.unsentSessions.put(this.currentSession.getSessionId(), this.currentSession);
            return;
        }
        this.getUnsentSessions();
        this.currentSession = newSession = new Session(this.numberForNextSession());
        this.sessions.put(newSession.getSessionId(), newSession);
        this.unsentSessions.put(newSession.getSessionId(), newSession);
        Future sessionTimer = this.sessionHeartbeatTimer;
        if (sessionTimer != null) {
            sessionTimer.cancel(true);
        }
        if (EmbraceManager.getInstance().isSdkInitialized()) {
            this.scheduleAndSendSessionStart();
        }
        EmbraceLogger.logDebug(String.format("created new session with id %s", newSession.getSessionId()));
    }

    private void endCurrentSession() {
        Session current = this.currentSession;
        if (current == null) {
            EmbraceLogger.logWarning("can't end current session because current session is null");
            return;
        }
        current.endSession();
        if (this.sessionHeartbeatTimer != null) {
            this.sessionHeartbeatTimer.cancel(true);
        }
        this.lastSession = current;
        try {
            this.saveUnsentSessions();
        }
        catch (EmbraceSdkException e) {
            EmbraceLogger.logWarning("error while saving unsent sessions", e);
        }
        this.currentSession = null;
        if (this.shouldRecordSessionMessageType()) {
            this.executorService.schedule(this.sendSessionRunnable, 0L, TimeUnit.MILLISECONDS);
        }
    }

    private Integer numberForNextSession() throws EmbraceSdkException {
        Object uuid;
        Map<String, Object> sessionInfo = FileUtils.readSessionInfoFile();
        Integer sessionNumber = 0;
        if (sessionInfo != null) {
            EmbraceLogger.logDebug(String.format("got session info %s", sessionInfo.toString()));
            uuid = sessionInfo.get(SESSION_INFO_UUID_KEY).toString();
            if (((String)uuid).equals(SystemUtils.getInstance().getDeviceId())) {
                sessionNumber = (Integer)sessionInfo.get(SESSION_INFO_NUMBER_KEY);
            }
        } else {
            EmbraceLogger.logDebug("session info was null");
        }
        uuid = sessionNumber;
        Integer n = sessionNumber = Integer.valueOf(sessionNumber + 1);
        HashMap<String, Object> updatedSessionInfo = new HashMap<String, Object>();
        updatedSessionInfo.put(SESSION_INFO_NUMBER_KEY, sessionNumber);
        updatedSessionInfo.put(SESSION_INFO_UUID_KEY, SystemUtils.getInstance().getDeviceId());
        FileUtils.updateSessionInfoFileContents(updatedSessionInfo);
        return sessionNumber;
    }

    private void sendPreviousSession() throws EmbraceSdkException {
        final Session previousSession = this.lastSession;
        if (previousSession == null) {
            EmbraceLogger.logWarning("can't send previous session because it's null");
            return;
        }
        this.lastSession = null;
        previousSession.addPayload(User.getInstance().toJsonObject(), "u");
        previousSession.addPayload(Device.getInstance().getAppInfoJsonObject(), "a");
        previousSession.addPayload(Device.getInstance().getDeviceInfoJsonObject(), "d");
        this.addPerformanceMetaDataToSession(previousSession);
        this.addBreadcrumbsToSession(previousSession);
        EmbraceServer.getInstance().sendSession(previousSession, new EmbraceApiCallback(){

            @Override
            public void onSuccess(String response) throws Exception {
                SessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                SessionManager.this.saveUnsentSessions();
            }

            @Override
            public void onError(String error, int statusCode) throws Exception {
                SessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                SessionManager.this.saveUnsentSessions();
            }

            @Override
            public void onException(Exception e) {
                SessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                try {
                    SessionManager.this.saveUnsentSessions();
                }
                catch (EmbraceSdkException e1) {
                    EmbraceLogger.logError("Error saving unsent sessions %s", e1);
                }
            }
        });
    }

    void scheduleAndSendSessionStart() throws EmbraceSdkException {
        if (this.shouldRecordSessionMessageType()) {
            this.sessionHeartbeatTimer = this.executorService.scheduleAtFixedRate(this.processSessionHeartbeatRunnable, 0L, 5L, TimeUnit.SECONDS);
            if (this.currentSession != null) {
                this.sendSessionStart(this.currentSession);
            }
        }
    }

    private void sendSessionStart(Session session) throws EmbraceSdkException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("s", session.startMessagePayload());
        payload.put("d", Device.getInstance().getDeviceInfoMapObject());
        payload.put("a", Device.getInstance().getAppInfoMapObject());
        payload.put("v", EmbraceApiConstants.MESSAGE_FORMAT_VERSION);
        EmbraceServer.getInstance().sendStartOfSession(payload, null);
    }

    void sendSessionStartAfterReactivating() {
        if (this.currentSession != null && this.shouldRecordSessionMessageType()) {
            try {
                this.sendSessionStart(this.currentSession);
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("Error while sending start of session.", e);
            }
        }
    }

    private void processSessionHeartbeat() throws EmbraceSdkException {
        Session current = this.currentSession;
        if (current == null) {
            EmbraceLogger.logWarning("tried to process session heartbeat without current session");
            return;
        }
        current.recordHeartbeat();
        current.setCachedAppData(Device.getInstance().getAppInfoJsonObject());
        current.setCachedPerformanceData(this.getPerformanceDataForSession(current));
        current.setCachedBreadcrumbData(this.getBreadcrumbDataForSession());
        current.setCachedDeviceData(Device.getInstance().getDeviceInfoJsonObject());
        current.setCachedUserData(User.getInstance().toJsonObject());
        this.saveUnsentSessions();
    }

    void recordColdStart() {
        this.currentSession.setColdStart(true);
    }

    void applicationEnteredBackground() {
        this.currentSession.recordStateChange();
        this.endCurrentSession();
        EmbraceManager.getInstance().deactivateDataManagers();
    }

    void applicationEnteredForeground() throws EmbraceSdkException {
        EmbraceManager.getInstance().activateDataManagers();
        this.createSession();
    }

    String getCurrentSessionId() {
        if (this.currentSession == null) {
            return null;
        }
        return this.currentSession.getSessionId();
    }

    void recordNewStory(String storyId) {
        if (this.currentSession == null) {
            EmbraceLogger.logWarning("no current session, session manager ignoring new story id");
            return;
        }
        this.currentSession.addStoryId(storyId);
    }

    void recordInfoLog(String messageId) {
        if (this.currentSession == null) {
            EmbraceLogger.logWarning("no current session, session manager ignoring new info log id");
            return;
        }
        this.currentSession.addInfoLogId(messageId);
    }

    void recordErrorLog(String messageId) {
        if (this.currentSession == null) {
            EmbraceLogger.logWarning("no current session, session manager ignoring new error log id");
            return;
        }
        this.currentSession.addErrorLogId(messageId);
    }

    synchronized void enable() {
        if (!this.isManagerEnabled) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.sessionHeartbeatTimer = this.executorService.scheduleAtFixedRate(this.processSessionHeartbeatRunnable, 0L, 5L, TimeUnit.SECONDS);
            this.isManagerEnabled = true;
        }
    }

    synchronized void disable(boolean isDiabledFromConfig) {
        if (this.isManagerEnabled) {
            try {
                if (this.sessionHeartbeatTimer != null) {
                    this.sessionHeartbeatTimer.cancel(true);
                }
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                    EmbraceLogger.logWarning("Executor service was not safely terminated.");
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                EmbraceLogger.logWarning("Error while shutting down executor", e);
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            if (isDiabledFromConfig && this.currentSession != null) {
                this.unsentSessions.remove(this.currentSession.getSessionId());
                try {
                    this.saveUnsentSessions();
                }
                catch (EmbraceSdkException e) {
                    EmbraceLogger.logWarning("Error while saving unsent sessions", e);
                }
            }
            this.isManagerEnabled = false;
        }
    }

    boolean triggerEventSnapshot(String messageId, EmbScreenshotReason embScreenshotReason) throws EmbraceSdkException {
        if (!EmbraceManager.getInstance().isScreenshotsEnabled() || ApplicationStateManager.getManager().isInBackground() || this.recentScreenshotTaken) {
            EmbraceLogger.logDebug("screenshots disabled or cooling down");
            return false;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SessionManager.this.recentScreenshotTaken = false;
            }
        }, 3000L);
        this.sendScreenshot(messageId, embScreenshotReason, EmbraceManager.getInstance().getForegroundActivity());
        this.recentScreenshotTaken = true;
        return true;
    }

    byte[] processScreenshot(Bitmap screenshot) {
        if (screenshot == null) {
            EmbraceLogger.logWarning("asked to process null screenshot, aborting");
            return null;
        }
        EmbraceLogger.logDebug("processing screenshot");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        screenshot.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)stream);
        screenshot.recycle();
        return stream.toByteArray();
    }

    void sendScreenshot(String messageId, EmbScreenshotReason reason, Activity activity) throws EmbraceSdkException {
        byte[] data = this.processScreenshot(this.takeScreenshot(activity));
        EmbraceServer.getInstance().sendScreenshot(new Screenshot(reason == EmbScreenshotReason.LATE ? messageId : null, reason == EmbScreenshotReason.LATE ? null : messageId, data), null);
    }

    Bitmap takeScreenshot(Activity activity) throws EmbraceSdkException {
        View view;
        if (activity != null && (view = activity.getWindow().getDecorView()) != null) {
            Bitmap screenshot = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(screenshot);
            view.draw(canvas);
            return screenshot;
        }
        return null;
    }

    List<String> getStackTraceForCurrentThread() {
        ArrayList<String> augmentedStackReturnAddresses = new ArrayList<String>();
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            augmentedStackReturnAddresses.add(ste.toString());
        }
        return augmentedStackReturnAddresses;
    }

    private void checkForUnsentSessions(boolean terminationMessage) throws EmbraceSdkException {
        this.getUnsentSessions();
        if (this.currentSession != null && this.unsentSessions.containsKey(this.currentSession.getSessionId())) {
            this.unsentSessions.remove(this.currentSession.getSessionId());
        }
        if (!this.unsentSessions.isEmpty() && !this.shouldRecordSessionMessageType()) {
            EmbraceLogger.logDebug(String.format("found %s unsent sessions in cache, sending to server", this.unsentSessions.size()));
            for (Session session : this.unsentSessions.values()) {
                session.setReceivedTermination(terminationMessage);
                session.addPayload(session.getCachedAppData(), "a");
                session.addPayload(session.getCachedUserData(), "u");
                session.addPayload(session.getCachedDeviceData(), "d");
                session.addPayload(session.getCachedPerformanceData(), "p");
                session.addPayload(session.getCachedBreadcrumbData(), "br");
            }
            EmbraceServer.getInstance().addFailedSessions(this.unsentSessions.values());
            this.unsentSessions.clear();
            this.saveUnsentSessions();
        }
    }

    void saveSessionAfterCrash() throws EmbraceSdkException {
        this.unsentSessions.put(this.currentSession.getSessionId(), this.currentSession);
        this.saveUnsentSessions();
    }

    private void addBreadcrumbsToSession(Session session) {
        JSONObject breadcrumbData = this.getBreadcrumbDataForSession();
        session.addPayload(breadcrumbData, "br");
    }

    private void addPerformanceMetaDataToSession(Session session) {
        JSONObject performanceData = this.getPerformanceDataForSession(session);
        session.addPayload(performanceData, "p");
    }

    private JSONObject getBreadcrumbDataForSession() {
        JSONObject jsonObject = new JSONObject();
        List<Breadcrumb> viewBreadcrumbs = BreadcrumbManager.getManager().getRecentViewBreadcrumbs(5);
        JSONArray viewBreadcrumbPayloads = new JSONArray();
        for (Breadcrumb breadcrumb : viewBreadcrumbs) {
            viewBreadcrumbPayloads.put((Object)breadcrumb.toJsonObject());
        }
        List<Breadcrumb> tapBreadcrumbs = BreadcrumbManager.getManager().getRecentTapBreadcrumbs(20);
        JSONArray tapBreadcrumbPayloads = new JSONArray();
        for (Breadcrumb breadcrumb : tapBreadcrumbs) {
            tapBreadcrumbPayloads.put((Object)breadcrumb.toJsonObject());
        }
        try {
            jsonObject.put("vb", (Object)viewBreadcrumbPayloads);
            jsonObject.put("tb", (Object)tapBreadcrumbPayloads);
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    private JSONObject getPerformanceDataForSession(Session session) {
        if (session == null) {
            EmbraceLogger.logWarning("can't compute performance data without session");
            return null;
        }
        JSONObject performance = new JSONObject();
        try {
            performance.put("bt", (double)PowerManager.getManager().getBatteryLevel());
            performance.put("ds", (Object)Device.getInstance().getSystemMemoryAsJson());
            JSONArray cpuPayload = new JSONArray();
            for (IntervalMeasurement interval : ProcessManager.getManager().getCriticalIntervalsDuringSession(session)) {
                cpuPayload.put((Object)interval.getServerPayload());
            }
            performance.put("cp", (Object)cpuPayload);
            List<MemorySample> memorySamples = MemoryManager.getManager().getMemorySamplesDuringSession(session);
            JSONArray memoryPayload = new JSONArray();
            for (MemorySample memorySample : memorySamples) {
                memoryPayload.put((Object)memorySample.toJson());
            }
            performance.put("me", (Object)memoryPayload);
            List<SystemEvent> lowMemoryWarnings = MemoryManager.getManager().getMemoryWarningsDuringSession(session);
            JSONArray lowMemoryPayload = new JSONArray();
            for (SystemEvent systemEvent : lowMemoryWarnings) {
                lowMemoryPayload.put((Object)systemEvent.toJson());
            }
            performance.put("mw", (Object)lowMemoryPayload);
            List<IntervalMeasurement> chargingIntervals = PowerManager.getManager().getChargingIntervalsDuringSession(session);
            JSONArray chargingPayload = new JSONArray();
            for (IntervalMeasurement interval : chargingIntervals) {
                chargingPayload.put((Object)interval.getServerPayload());
            }
            performance.put("bc", (Object)chargingPayload);
            List<SystemEvent> batteryMeasurements = PowerManager.getManager().getBatteryMeasurementsDuringSession(session);
            JSONArray batteryPayload = new JSONArray();
            for (SystemEvent measurement : batteryMeasurements) {
                batteryPayload.put((Object)measurement.toJson());
            }
            performance.put("bm", (Object)batteryPayload);
            List<IntervalMeasurement> netInterfaceIntervals = NetworkManager.getManager().getReachabilityIntervalsDuringSession(session);
            JSONArray netInterfacePayload = new JSONArray();
            for (IntervalMeasurement interval : netInterfaceIntervals) {
                netInterfacePayload.put((Object)interval.getServerPayload());
            }
            performance.put("ns", (Object)netInterfacePayload);
            List<NetworkPerformance> networkPerformances = NetworkManager.getManager().getRequestsDuringSession(session);
            performance.put("nr", (Object)this.getNetworkRequestDataWithPerformance(networkPerformances));
        }
        catch (JSONException e) {
            performance = null;
        }
        return performance;
    }

    private synchronized void saveUnsentSessions() throws EmbraceSdkException {
        HashMap<String, String> unsentSessions = new HashMap<String, String>();
        for (Map.Entry<String, Session> entry : this.unsentSessions.entrySet()) {
            unsentSessions.put(entry.getKey(), entry.getValue().toJson());
        }
        FileUtils.saveMapToFile(unsentSessions, FileCache.UNSENT_SESSIONS);
    }

    private synchronized void getUnsentSessions() throws EmbraceSdkException {
        Map unsentSessions = FileUtils.readMapFromFile(FileCache.UNSENT_SESSIONS);
        for (Map.Entry entry : unsentSessions.entrySet()) {
            this.unsentSessions.put(entry.getKey(), new Session((String)entry.getValue()));
        }
    }

    private JSONObject getNetworkRequestDataWithPerformance(List<NetworkPerformance> performanceInfo) {
        JSONObject jsonObject = new JSONObject();
        int timeThreshold = EmbraceManager.getInstance().getProblematicRequestLatency();
        HashMap requestStats = new HashMap();
        HashMap requestStatsCurrent = new HashMap();
        JSONArray performanceLogs = new JSONArray();
        for (NetworkPerformance networkPerformance : performanceInfo) {
            if (networkPerformance.getStatusCode() <= 0) continue;
            if (networkPerformance.getFormattedUrl() != null) {
                ArrayList<NetworkInfo> networkInfos = requestStats.get(networkPerformance.getFormattedUrl()) != null ? (List)requestStats.get(networkPerformance.getFormattedUrl()) : new ArrayList<NetworkInfo>();
                networkInfos.add(new NetworkInfo(networkPerformance.getElapsedTime(), networkPerformance.getStatusCode(), networkPerformance.getStartTime()));
                requestStats.put(networkPerformance.getFormattedUrl(), networkInfos);
                HashMap<String, Integer> statusCodeCounts = (HashMap<String, Integer>)requestStatsCurrent.get(networkPerformance.getUrl());
                String statusCodeString = String.valueOf(networkPerformance.getStatusCode());
                if (statusCodeCounts != null) {
                    if (statusCodeCounts.get(statusCodeString) != null) {
                        statusCodeCounts.put(statusCodeString, (Integer)statusCodeCounts.get(statusCodeString) + 1);
                    } else {
                        statusCodeCounts.put(statusCodeString, 1);
                    }
                } else {
                    statusCodeCounts = new HashMap<String, Integer>();
                    statusCodeCounts.put(statusCodeString, 1);
                    requestStatsCurrent.put(networkPerformance.getUrl(), statusCodeCounts);
                }
            }
            if (networkPerformance.getStatusCode() < 300 && networkPerformance.getElapsedTime() < (long)timeThreshold) continue;
            performanceLogs.put((Object)networkPerformance.toJson());
        }
        JSONObject resultNetworkInfo = new JSONObject();
        for (String key : requestStats.keySet()) {
            List networkInfos = (List)requestStats.get(key);
            JSONObject networkInfo = new JSONObject();
            JSONArray networkInfoArray = new JSONArray();
            for (NetworkInfo info : networkInfos) {
                networkInfoArray.put((Object)info.toJson());
            }
            try {
                networkInfo.put("rq", (Object)networkInfoArray);
                networkInfo.put("rc", networkInfoArray.length());
                resultNetworkInfo.put(key, (Object)networkInfo);
            }
            catch (JSONException e) {
                networkInfo = new JSONObject();
            }
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("rs", (Object)new JSONObject(requestStatsCurrent));
            jSONObject.put("rd", (Object)resultNetworkInfo);
            jSONObject.put("pr", (Object)performanceLogs);
            jsonObject.put("hr", (Object)jSONObject);
        }
        catch (JSONException e) {
            Object var8_11 = null;
            jsonObject = null;
        }
        return jsonObject;
    }

    private boolean shouldRecordSessionMessageType() {
        if (!EmbraceManager.getInstance().shouldRecordEvents()) {
            EmbraceLogger.logWarning("Sdk is disabled, ignoring sending of session");
            return false;
        }
        if (!EmbraceManager.getInstance().shouldRecordMessageType(EmbraceManager.MessageType.SESSION)) {
            EmbraceLogger.logWarning("Session messages are disabled, ignoring unsent session sending.");
            return false;
        }
        return true;
    }

    static enum EmbScreenshotReason {
        LATE,
        LOG;

    }
}

