/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import io.embrace.android.embracesdk.BatteryBroadcastReceiver;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.FilterableUtils;
import io.embrace.android.embracesdk.FixedSizeDeque;
import io.embrace.android.embracesdk.IInterval;
import io.embrace.android.embracesdk.ITimestamp;
import io.embrace.android.embracesdk.IntervalMeasurement;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SystemEvent;
import io.embrace.android.embracesdk.TimestampUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class PowerManager {
    private static final String BATTERY_LEVEL_KEY = "bt";
    private static final String BATTERY_CHARGING_KEY = "bc";
    private static final int BATTERY_MEASUREMENTS_LOG_MAX = 600;
    private static final Integer BATTERY_MEASUREMENT_INTERVAL_IN_SECONDS = 60;
    private static final long SHUTDOWN_TIMEOUT_MS = 2000L;
    private List<IInterval> chargingIntervals;
    private FixedSizeDeque<SystemEvent> batteryMeasurements;
    private IntervalMeasurement currentChargingInterval;
    private boolean isBatteryCharging;
    private boolean isSdkDisabled;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private BatteryBroadcastReceiver batteryBroadcastReceiver = new BatteryBroadcastReceiver();
    private Future batteryInfoFuture;
    private Runnable batteryInfoRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                PowerManager.this.recordBatteryLevel();
            }
            catch (InterruptedException exception) {
                EmbraceLogger.logError("Error while adding battery measurement", exception);
            }
        }
    };
    private static final PowerManager manager = new PowerManager();

    static PowerManager getManager() {
        return manager;
    }

    private PowerManager() {
        this.chargingIntervals = new ArrayList<IInterval>();
        this.batteryMeasurements = new FixedSizeDeque(600);
        Intent batteryStatus = this.registerBroadcastReceiver();
        int status = batteryStatus.getIntExtra("status", -1);
        boolean bl = this.isBatteryCharging = status == 2 || status == 5;
        if (this.isBatteryCharging) {
            IntervalMeasurement chargingInterval = new IntervalMeasurement();
            this.chargingIntervals.add(chargingInterval);
            this.currentChargingInterval = chargingInterval;
        }
        this.startObservingBatteryLevel();
    }

    private void startObservingBatteryLevel() {
        this.batteryInfoFuture = this.executorService.scheduleAtFixedRate(this.batteryInfoRunnable, 0L, BATTERY_MEASUREMENT_INTERVAL_IN_SECONDS.intValue(), TimeUnit.SECONDS);
    }

    private Intent registerBroadcastReceiver() {
        this.batteryBroadcastReceiver = new BatteryBroadcastReceiver();
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        return Embrace.getContext().registerReceiver((BroadcastReceiver)this.batteryBroadcastReceiver, ifilter);
    }

    float getBatteryLevel() {
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = Embrace.getContext().registerReceiver(null, ifilter);
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        return (float)level / (float)scale;
    }

    List<IntervalMeasurement> getChargingIntervalsBetween(long startTime, long endTime) {
        return FilterableUtils.filter(this.chargingIntervals, startTime, endTime);
    }

    List<IntervalMeasurement> getChargingIntervalsDuringSession(Session session) {
        return this.getChargingIntervalsBetween(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    private List<SystemEvent> getBatteryMeasurementsBetween(long startTime, long endTime) {
        return TimestampUtils.getWithinInterval(new ArrayList<ITimestamp>(this.batteryMeasurements), startTime, endTime);
    }

    List<SystemEvent> getBatteryMeasurementsDuringSession(Session session) {
        return this.getBatteryMeasurementsBetween(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    private synchronized void recordBatteryLevel() throws InterruptedException {
        SystemEvent batteryLog = new SystemEvent(Float.valueOf(this.getBatteryLevel()));
        this.batteryMeasurements.forcePutLast(batteryLog);
    }

    private boolean isBatteryCharging(int batteryStatus) {
        return batteryStatus == 2 || batteryStatus == 5;
    }

    private BatteryChargingStatusUpdate didBatteryChargingStatusChange(int batteryStatus) {
        if (this.isBatteryCharging(batteryStatus)) {
            return !this.isBatteryCharging ? BatteryChargingStatusUpdate.BATTERY_STARTED_CHARGING : BatteryChargingStatusUpdate.NO_CHANGE;
        }
        return this.isBatteryCharging ? BatteryChargingStatusUpdate.BATTERY_STOPPED_CHARGING : BatteryChargingStatusUpdate.NO_CHANGE;
    }

    private void onBatteryStateChanged(int batteryStatus) {
        switch (this.didBatteryChargingStatusChange(batteryStatus)) {
            case BATTERY_STARTED_CHARGING: {
                IntervalMeasurement chargingInterval = new IntervalMeasurement();
                this.chargingIntervals.add(chargingInterval);
                this.currentChargingInterval = chargingInterval;
                break;
            }
            case BATTERY_STOPPED_CHARGING: {
                if (this.currentChargingInterval == null) break;
                this.currentChargingInterval.endInterval();
                this.currentChargingInterval = null;
                EmbraceLogger.logDebug("Ending previous charging interval");
                break;
            }
        }
        this.isBatteryCharging = this.isBatteryCharging(batteryStatus);
    }

    synchronized void handleBatteryStateChange(final Intent batteryStatus) {
        if (!this.executorService.isShutdown()) {
            this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    PowerManager.this.onBatteryStateChanged(batteryStatus.getIntExtra("status", -1));
                }
            }, 0L, TimeUnit.SECONDS);
        }
    }

    private SdkStatusUpdate didSdkStatusChanged(boolean sdkStatus) {
        if (this.isSdkDisabled == sdkStatus) {
            return SdkStatusUpdate.NO_CHANGE;
        }
        if (sdkStatus && !this.isSdkDisabled) {
            return SdkStatusUpdate.SDK_ENABLED;
        }
        return SdkStatusUpdate.SDK_DISABLED;
    }

    void onSdkStatusChanged(boolean sdkStatus) {
        switch (this.didSdkStatusChanged(sdkStatus)) {
            case SDK_DISABLED: {
                this.batteryInfoFuture.cancel(true);
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                        EmbraceLogger.logWarning("Executor service was not safely terminated.");
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    EmbraceLogger.logWarning("Error while shutting down executor", e);
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                this.batteryMeasurements.clear();
                this.chargingIntervals.clear();
                break;
            }
            case SDK_ENABLED: {
                if (this.executorService.isShutdown()) {
                    this.executorService = Executors.newSingleThreadScheduledExecutor();
                }
                this.startObservingBatteryLevel();
                break;
            }
        }
        this.isSdkDisabled = sdkStatus;
    }

    JSONObject toJson() {
        JSONObject payload = new JSONObject();
        try {
            payload.put(BATTERY_LEVEL_KEY, (double)this.getBatteryLevel());
            payload.put(BATTERY_CHARGING_KEY, this.isBatteryCharging);
        }
        catch (JSONException e) {
            EmbraceLogger.logError("error creating battery event object", (Exception)((Object)e));
            payload = null;
        }
        return payload;
    }

    private static enum SdkStatusUpdate {
        NO_CHANGE,
        SDK_ENABLED,
        SDK_DISABLED;

    }

    private static enum BatteryChargingStatusUpdate {
        NO_CHANGE,
        BATTERY_STARTED_CHARGING,
        BATTERY_STOPPED_CHARGING;

    }
}

