/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Log;
import io.embrace.android.embracesdk.DebugMessage;
import io.embrace.android.embracesdk.EmbraceException;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.helpers.LogLevel;
import java.util.Map;
import java.util.Stack;

final class EmbraceLogger {
    private EmbraceLogger() {
    }

    static void logDebug(String msg) {
        EmbraceLogger.logDebug(msg, null, null);
    }

    static void logDebug(String msg, Exception e) {
        EmbraceLogger.logDebug(msg, e, null);
    }

    static void logDebug(String msg, Exception e, Map<String, Object> data) {
        if (EmbraceManager.logLevel.ordinal() <= LogLevel.DEBUG.ordinal()) {
            Log.d((String)"[Embrace] ", (String)String.format(msg + " %s", e != null ? e : ""));
            EmbraceLogger.addDebugMessage(DebugMessage.Type.DEBUG, msg, e, data);
        }
    }

    static void logInfo(String msg) {
        EmbraceLogger.logInfo(msg, null, null);
    }

    static void logInfo(String msg, Exception e) {
        EmbraceLogger.logInfo(msg, e, null);
    }

    static void logInfo(String msg, Exception e, Map<String, Object> data) {
        if (EmbraceManager.logLevel.ordinal() <= LogLevel.INFO.ordinal()) {
            Log.i((String)"[Embrace] ", (String)String.format(msg + " %s", e != null ? e : ""));
            EmbraceLogger.addDebugMessage(DebugMessage.Type.INFO, msg, e, data);
        }
    }

    static void logWarning(String msg) {
        EmbraceLogger.logWarning(msg, null, null);
    }

    static void logWarning(String msg, Exception e) {
        EmbraceLogger.logWarning(msg, e, null);
    }

    static void logWarning(String msg, Exception e, Map<String, Object> data) {
        if (EmbraceManager.logLevel.ordinal() <= LogLevel.WARNING.ordinal()) {
            Log.w((String)"[Embrace] ", (String)String.format(msg + " %s", e != null ? e : ""));
            EmbraceLogger.addDebugMessage(DebugMessage.Type.WARNING, msg, e, data);
        }
    }

    static void logError(String msg) {
        EmbraceLogger.logError(msg, null, null);
    }

    static void logError(String msg, Exception e) {
        EmbraceLogger.logError(msg, e, null);
    }

    static void logError(String msg, Exception e, Map<String, Object> data) {
        if (EmbraceManager.logLevel.ordinal() <= LogLevel.ERROR.ordinal()) {
            Log.e((String)"[Embrace] ", (String)String.format(msg + " %s", e != null ? e : ""));
            EmbraceLogger.addDebugMessage(DebugMessage.Type.ERROR, msg, e, data);
        }
    }

    private static void addDebugMessage(DebugMessage.Type messageType, String msg, Exception exception, Map<String, Object> additionalInfo) {
        Stack<EmbraceException> embraceExceptions = EmbraceManager.getInstance().getCrashPayload(exception);
        DebugMessage logMessage = new DebugMessage(messageType, msg, embraceExceptions, additionalInfo);
    }
}

