/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.ApplicationStateManager;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.constants.EmbraceApiConstants;
import io.embrace.android.embracesdk.helpers.Uuid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class EmbraceEvent
implements Serializable {
    private static final int MAX_PROPERTY_COUNT = 10;
    private String name;
    private String storyId;
    private String sessionId;
    private Type type;
    private Long timestamp;
    private Long lateThreshold;
    private boolean late;
    private boolean screenshotTaken;
    private Long duration;
    private String appState;
    private Map<String, Object> customProperties;
    private final Map<String, Object> additionalPayloads = new HashMap<String, Object>();

    EmbraceEvent(String jsonString) {
        String key;
        Iterator iter;
        JSONObject json;
        try {
            json = new JSONObject(jsonString);
        }
        catch (JSONException e) {
            EmbraceLogger.logWarning("Failed to initialize EmbraceEvent from JSON string.");
            json = new JSONObject();
        }
        JSONObject eventBodyPayload = json.optJSONObject("et");
        this.type = this.eventTypeForString(eventBodyPayload.optString("t", null));
        this.name = eventBodyPayload.optString("n", null);
        this.timestamp = json.isNull("ts") ? Calendar.getInstance().getTimeInMillis() : eventBodyPayload.optLong("ts");
        this.duration = eventBodyPayload.optLong("du", 0L);
        this.appState = eventBodyPayload.optString("st", ApplicationStateManager.getManager().isInBackground() ? "inactive" : "active");
        this.lateThreshold = json.isNull("th") ? null : Long.valueOf(eventBodyPayload.optLong("th"));
        this.screenshotTaken = eventBodyPayload.optBoolean("sc");
        this.storyId = this.type == Type.ERROR_LOG || this.type == Type.INFO_LOG ? eventBodyPayload.optString("li", null) : eventBodyPayload.optString("id", null);
        this.sessionId = eventBodyPayload.optString("si", null);
        JSONObject customPropertiesJsonObject = eventBodyPayload.optJSONObject("pr");
        this.customProperties = new HashMap<String, Object>();
        if (customPropertiesJsonObject != null) {
            iter = customPropertiesJsonObject.keys();
            while (iter.hasNext()) {
                key = (String)iter.next();
                this.customProperties.put(key, customPropertiesJsonObject.opt(key));
            }
        }
        iter = json.keys();
        while (iter.hasNext()) {
            key = (String)iter.next();
            JSONObject additionalPayload = json.optJSONObject(key);
            if (additionalPayload == null || key.equals("et")) continue;
            this.additionalPayloads.put(key, additionalPayload);
        }
    }

    EmbraceEvent(Type type, String name) {
        this(type, name, Uuid.getEmbUuid(UUID.randomUUID().toString()), null);
    }

    EmbraceEvent(Type type, String name, Map properties) {
        this(type, name, Uuid.getEmbUuid(UUID.randomUUID().toString()), properties);
    }

    EmbraceEvent(Type type, String name, String storyId) {
        this(type, name, storyId, null);
    }

    private EmbraceEvent(Type type, String name, String storyId, Map properties) {
        this.storyId = storyId;
        this.name = name;
        this.type = type;
        this.late = false;
        this.screenshotTaken = false;
        this.timestamp = Calendar.getInstance().getTimeInMillis();
        this.appState = ApplicationStateManager.getManager().isInBackground() ? "inactive" : "active";
        this.customProperties = properties != null ? this.getPropertiesMap(properties) : new HashMap();
    }

    private Map<String, Object> getPropertiesMap(Map<String, Object> properties) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String key : properties.keySet()) {
            if (key != null) {
                if (!this.isInstanceTypeAllowed(properties.get(key)) || this.addProperty(key, properties.get(key), resultMap)) continue;
                EmbraceLogger.logError(String.format("EmbraceEvent config must have at most 10 values. Object %s with key %s won't be added.", key, properties.get(key)));
                continue;
            }
            EmbraceLogger.logError("Property key must not be null");
        }
        return resultMap;
    }

    private boolean isInstanceTypeAllowed(Object value) {
        if (value != null && (value instanceof String || value instanceof Long || value instanceof Integer || value instanceof Float || value instanceof Double || value instanceof Boolean)) {
            return true;
        }
        EmbraceLogger.logError("Property value must be either String, Long, Integer, Float, Double or Boolean.");
        return false;
    }

    private boolean addProperty(String key, Object value, Map<String, Object> resultMap) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null || resultMap.size() >= 10) {
            return false;
        }
        resultMap.put(key, value);
        return true;
    }

    void updateWithStartTime(Long startTime) {
        if (this.timestamp == null) {
            EmbraceLogger.logWarning("can't set duration for event without timestamp");
            return;
        }
        this.duration = this.timestamp - startTime;
    }

    void addPayload(JSONObject payload, String bodyKey) {
        if (payload == null || bodyKey == null) {
            EmbraceLogger.logWarning("can't add additional event payload with a null key or body");
            return;
        }
        this.additionalPayloads.put(bodyKey, payload);
    }

    private JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            String eventTypeString = this.stringForEventType(this.type);
            if (eventTypeString != null) {
                jsonObject.put("t", (Object)eventTypeString);
            }
            jsonObject.put("si", (Object)this.sessionIdPayload());
            jsonObject.put("sc", this.screenshotTaken);
            if (this.storyId != null) {
                if (this.type == Type.ERROR_LOG || this.type == Type.INFO_LOG) {
                    jsonObject.put("li", (Object)this.storyId);
                } else {
                    jsonObject.put("id", (Object)this.storyId);
                }
            }
            if (this.name != null) {
                jsonObject.put("n", (Object)this.name);
            }
            if (this.timestamp != null) {
                jsonObject.put("ts", (Object)this.timestamp);
            }
            if (this.duration != null) {
                jsonObject.put("du", (Object)this.duration);
            }
            if (this.appState != null) {
                jsonObject.put("st", (Object)this.appState);
            }
            if (this.lateThreshold != null) {
                jsonObject.put("th", (Object)this.lateThreshold);
            }
            if (this.customProperties != null) {
                jsonObject.put("pr", (Object)new JSONObject(this.customProperties));
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    JSONObject serverPayload() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("v", (Object)EmbraceApiConstants.MESSAGE_FORMAT_VERSION);
            jsonObject.put("et", (Object)this.toJsonObject());
            for (String key : this.additionalPayloads.keySet()) {
                jsonObject.put(key, this.additionalPayloads.get(key));
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    private String sessionIdPayload() {
        ArrayList<String> sessionIds = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)this.sessionId)) {
            sessionIds.add(this.sessionId);
        }
        return TextUtils.join((CharSequence)",", sessionIds);
    }

    String getTypeAbbreviation() {
        switch (this.type) {
            case START: {
                return "s";
            }
            case LATE: {
                return "l";
            }
            case END: {
                return "e";
            }
            case INTERRUPT: {
                return "i";
            }
            case CRASH: {
                return "c";
            }
            case INFO_LOG: {
                return "il";
            }
            case ERROR_LOG: {
                return "el";
            }
        }
        return null;
    }

    private String stringForEventType(Type type) {
        switch (type) {
            case START: {
                return "start";
            }
            case LATE: {
                return "late";
            }
            case INTERRUPT: {
                return "interrupt";
            }
            case CRASH: {
                return "crash";
            }
            case END: {
                return "end";
            }
            case INFO_LOG: {
                return "info";
            }
            case ERROR_LOG: {
                return "error";
            }
        }
        return null;
    }

    private Type eventTypeForString(String stringName) {
        switch (stringName) {
            case "start": {
                return Type.START;
            }
            case "late": {
                return Type.LATE;
            }
            case "interrupt": {
                return Type.INTERRUPT;
            }
            case "crash": {
                return Type.CRASH;
            }
            case "end": {
                return Type.END;
            }
            case "info": {
                return Type.INFO_LOG;
            }
            case "error": {
                return Type.ERROR_LOG;
            }
        }
        return null;
    }

    void setStoryId(String storyId) {
        this.storyId = storyId;
    }

    String getStoryId() {
        return this.storyId;
    }

    void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    Type getType() {
        return this.type;
    }

    Long getTimestamp() {
        return this.timestamp;
    }

    boolean isLate() {
        return this.late;
    }

    void setLate(boolean late) {
        this.late = late;
    }

    void setLateThreshold(Long lateThreshold) {
        this.lateThreshold = lateThreshold;
    }

    void setScreenshotTaken(boolean screenshotTaken) {
        this.screenshotTaken = screenshotTaken;
    }

    static boolean validateEventName(String name, String identifier) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            EmbraceLogger.logWarning("EmbraceEvent name must not be blank");
            return false;
        }
        if (name.startsWith("_")) {
            EmbraceLogger.logWarning("EmbraceEvent name must not begin with an underscore");
            return false;
        }
        if (name.contains("#")) {
            EmbraceLogger.logWarning(String.format("EmbraceEvent name must not contain the %s character", "#"));
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return true;
        }
        if (identifier.startsWith("_")) {
            EmbraceLogger.logWarning("EmbraceEvent identifier must not begin with an underscore");
            return false;
        }
        if (identifier.contains("#")) {
            EmbraceLogger.logWarning(String.format("EmbraceEvent identifier must not contain the %s character", "#"));
            return false;
        }
        return true;
    }

    static enum Type {
        START,
        LATE,
        INTERRUPT,
        CRASH,
        END,
        INFO_LOG,
        ERROR_LOG;

    }
}

