/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.text.TextUtils;
import io.embrace.android.embracesdk.ApplicationStateManager;
import io.embrace.android.embracesdk.BreadcrumbManager;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.SessionManager;
import io.embrace.android.embracesdk.helpers.LogLevel;
import io.embrace.android.embracesdk.network.EmbraceUrlStreamHandlerFactory;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.swazzle.SwazzleContext;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Embrace {
    private static final String STARTUP_EVENT_NAME = "_startup";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Embrace singleton = new Embrace();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application application;

    private Embrace() {
        SwazzleContext.put("breadcrumb_manager", BreadcrumbManager.getManager());
        SwazzleContext.put("application_state_manager", ApplicationStateManager.getManager());
    }

    public static Embrace getInstance() {
        return singleton;
    }

    static Context getContext() {
        return application;
    }

    public synchronized void start(Application application) {
        if (application == null) {
            EmbraceLogger.logError("Failed to start Embrace SDK: Application instance is null.");
            return;
        }
        Embrace.application = application;
        if (!EmbraceManager.getInstance().setupApiKey()) {
            EmbraceLogger.logError("Failed to start Embrace SDK: Embrace SDK API key is null or blank.");
            return;
        }
        Embrace.getContext().registerComponentCallbacks((ComponentCallbacks)ApplicationStateManager.getManager());
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ApplicationStateManager.getManager());
        try {
            ApplicationStateManager.getManager().enable();
            EmbraceManager.getInstance().performStartup();
            EmbraceManager.getInstance().startEvent(STARTUP_EVENT_NAME, null, true, null);
            EmbraceLogger.logDebug(String.format("Embrace SDK started successfully with key %s", EmbraceManager.getInstance().getApiKey()));
        }
        catch (Exception e) {
            EmbraceLogger.logError("Error while starting Embrace SDK", e);
        }
        URL.setURLStreamHandlerFactory(new EmbraceUrlStreamHandlerFactory());
    }

    public synchronized void setLogLevel(LogLevel logLevel) {
        if (logLevel == null) {
            EmbraceLogger.logError("Failed to set log level: Log level is null.");
        } else {
            EmbraceManager.logLevel = logLevel;
        }
    }

    public synchronized void setUserIdentifier(String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            EmbraceLogger.logError("Failed to set user identifier: User identifier is null or blank.");
            return;
        }
        try {
            EmbraceManager.getInstance().setUserIdentifier(userId);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("Error while setting user identifier %s", userId), e);
        }
    }

    public synchronized void clearUserIdentifier() {
        try {
            EmbraceManager.getInstance().setUserIdentifier(null);
        }
        catch (Exception e) {
            EmbraceLogger.logError("Error while clearing user identifier", e);
        }
    }

    public synchronized void setUserEmail(String email) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            EmbraceLogger.logError("Failed to set user email: User email is null or blank.");
            return;
        }
        try {
            EmbraceManager.getInstance().setUserEmailAddress(email);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("Error while setting user email %s", email), e);
        }
    }

    public synchronized void clearUserEmail() {
        try {
            EmbraceManager.getInstance().setUserEmailAddress(null);
        }
        catch (Exception e) {
            EmbraceLogger.logError("Error while clearing user email", e);
        }
    }

    public synchronized void setUserAsPayer() {
        try {
            EmbraceManager.getInstance().setUserIsPayer(true);
        }
        catch (Exception e) {
            EmbraceLogger.logError("Error while setting user as payer", e);
        }
    }

    public void clearUserAsPayer() {
        try {
            EmbraceManager.getInstance().setUserIsPayer(false);
        }
        catch (Exception e) {
            EmbraceLogger.logError("Error while clearing user as payer", e);
        }
    }

    public synchronized void setUserPersona(String persona) {
        if (TextUtils.isEmpty((CharSequence)persona)) {
            EmbraceLogger.logError("Failed to set user persona: User persona is null or blank.");
            return;
        }
        try {
            EmbraceManager.getInstance().setUserPersona(persona);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("Error while clearing setting persona %s", persona), e);
        }
    }

    public synchronized void clearUserPersona(String persona) {
        if (TextUtils.isEmpty((CharSequence)persona)) {
            EmbraceLogger.logError("Failed to clear user persona: User persona is null or blank.");
            return;
        }
        try {
            EmbraceManager.getInstance().removeUserPersona(persona);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("Error while clearing user persona %s", persona), e);
        }
    }

    public synchronized void setUsername(String username) {
        if (TextUtils.isEmpty((CharSequence)username)) {
            EmbraceLogger.logError("Failed to clear username: Username is null or blank.");
            return;
        }
        try {
            EmbraceManager.getInstance().setUsername(username);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("Error while setting username %s", username), e);
        }
    }

    public synchronized void clearUsername() {
        try {
            EmbraceManager.getInstance().setUsername(null);
        }
        catch (Exception e) {
            EmbraceLogger.logError("Error while clearing username", e);
        }
    }

    public synchronized void endAppStartup() {
        try {
            EmbraceManager.getInstance().endEvent(STARTUP_EVENT_NAME, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void startEvent(String name) {
        this.startEvent(name, null, true);
    }

    public synchronized void startEvent(String name, String identifier) {
        this.startEvent(name, identifier, true);
    }

    public synchronized void startEvent(String name, String identifier, boolean allowScreenshot) {
        this.startEvent(name, identifier, allowScreenshot, null);
    }

    public synchronized void startEvent(String name, String identifier, boolean allowScreenshot, Map properties) {
        if (properties == null) {
            properties = new HashMap();
        }
        if (EmbraceEvent.validateEventName(name, identifier)) {
            try {
                EmbraceManager.getInstance().startEvent(name, identifier, allowScreenshot, properties);
            }
            catch (Exception e) {
                EmbraceLogger.logError(String.format("Error while starting event with name %s", name), e);
            }
        }
    }

    public synchronized void endEvent(String name) {
        this.endEvent(name, null);
    }

    public synchronized void endEvent(String name, String identifier) {
        if (EmbraceEvent.validateEventName(name, identifier)) {
            try {
                EmbraceManager.getInstance().endEvent(name, identifier);
            }
            catch (Exception e) {
                EmbraceLogger.logError(String.format("Error while ending event with name %s", name), e);
            }
        }
    }

    public synchronized void logNetworkCall(String url, HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            EmbraceLogger.logError("Failed to log network call: URL is null or blank.");
            return;
        }
        if (httpMethod == null) {
            EmbraceLogger.logError("Failed to log network call: HTTP method is null.");
            return;
        }
        if (statusCode < 100 || statusCode > 599) {
            EmbraceLogger.logError("Failed to log network call: Invalid status code (valid ranges: 100 ~ 599 inclusive).");
            return;
        }
        if (startTime < 0L) {
            EmbraceLogger.logError("Failed to log network call: Start time is a negative value.");
            return;
        }
        if (endTime < 0L) {
            EmbraceLogger.logError("Failed to log network call: End time is a negative value.");
            return;
        }
        try {
            EmbraceManager.getInstance().logNetworkCall(url, httpMethod.name(), statusCode, startTime, endTime, bytesSent, bytesReceived);
        }
        catch (InterruptedException exception) {
            EmbraceLogger.logError("Could not log network call", exception);
        }
    }

    public synchronized void logInfo(String message, Map properties) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            EmbraceLogger.logError("Failed to log info message: Message is null or blank.");
            return;
        }
        if (properties == null) {
            properties = new HashMap();
        }
        List<String> stackTrace = SessionManager.manager.getStackTraceForCurrentThread();
        try {
            EmbraceManager.getInstance().logMessage(message, EmbraceEvent.Type.INFO_LOG, false, properties, stackTrace);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("Error while sending info message %s", message), e);
        }
    }

    public synchronized void logError(String message, Map properties) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            EmbraceLogger.logError("Failed to log error message: Message is null or blank.");
            return;
        }
        if (properties == null) {
            properties = new HashMap();
        }
        List<String> stackTrace = SessionManager.manager.getStackTraceForCurrentThread();
        try {
            EmbraceManager.getInstance().logMessage(message, EmbraceEvent.Type.ERROR_LOG, true, properties, stackTrace);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("Error while sending error message %s", message), e);
        }
    }
}

