/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Pair;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.FixedSizeDeque;
import io.embrace.android.embracesdk.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;

public class BreadcrumbManager {
    private static final Integer BREADCRUMB_VIEW_LOG_MAX = 50;
    private static final Integer BREADCRUMB_TAP_LOG_MAX = 100;
    private static final BreadcrumbManager manager = new BreadcrumbManager();
    private final FixedSizeDeque<Breadcrumb> viewLogsDeque = new FixedSizeDeque(BREADCRUMB_VIEW_LOG_MAX);
    private final FixedSizeDeque<Breadcrumb> tapLogsDeque = new FixedSizeDeque(BREADCRUMB_TAP_LOG_MAX);

    static BreadcrumbManager getManager() {
        return manager;
    }

    private BreadcrumbManager() {
    }

    public void logView(String screen, long timestamp) {
        Breadcrumb breadcrumb = (Breadcrumb)this.viewLogsDeque.peekLast();
        String string = screen = screen != null ? screen : "unknown";
        if (breadcrumb == null || !breadcrumb.getScreen().equals(screen)) {
            try {
                this.viewLogsDeque.forcePutLast(new Breadcrumb(screen, timestamp));
            }
            catch (InterruptedException e) {
                EmbraceLogger.logError("Thread was interrupted while attempting to register view breadcrumb.", e);
            }
        }
    }

    public void log(Pair<Float, Float> point, String element, long timestamp, Breadcrumb.BreadcrumbType type) {
        try {
            this.tapLogsDeque.forcePutLast(new Breadcrumb(point, element, timestamp, type));
        }
        catch (InterruptedException e) {
            EmbraceLogger.logError("Thread was interrupted while attempting to register tap breadcrumb.", e);
        }
    }

    private List<Breadcrumb> getViewBreadcrumbsAfterTime(long startTime, long endTime) {
        return this.filterListByStartAndEndTime(this.viewLogsDeque, startTime, endTime);
    }

    List<Breadcrumb> getViewBreadcrumbsDuringSession(Session session) {
        return this.getViewBreadcrumbsAfterTime(session.getStartTime().getTime(), session.getEndTime().getTime());
    }

    List<Breadcrumb> getRecentViewBreadcrumbs(int count) {
        return this.getLastElements(this.viewLogsDeque, count);
    }

    private List<Breadcrumb> getTapBreadcrumbsAfterTime(long startTime, long endTime) {
        return this.filterListByStartAndEndTime(this.tapLogsDeque, startTime, endTime);
    }

    List<Breadcrumb> getTapBreadcrumbsDuringSession(Session session) {
        return this.getTapBreadcrumbsAfterTime(session.getStartTime().getTime(), session.getEndTime().getTime());
    }

    List<Breadcrumb> getRecentTapBreadcrumbs(int count) {
        return this.getLastElements(this.tapLogsDeque, count);
    }

    private List<Breadcrumb> filterListByStartAndEndTime(Queue<Breadcrumb> listToFilter, long startTime, long endTime) {
        ArrayList<Breadcrumb> result = new ArrayList<Breadcrumb>();
        for (Breadcrumb breadcrumb : listToFilter) {
            if (breadcrumb.getTimestamp() < startTime || breadcrumb.getTimestamp() > endTime) continue;
            result.add(breadcrumb);
        }
        return result;
    }

    private List<Breadcrumb> getLastElements(Queue<Breadcrumb> listToFilter, int count) {
        ArrayList<Breadcrumb> result = new ArrayList<Breadcrumb>();
        Stack<Breadcrumb> queue = new Stack<Breadcrumb>();
        queue.addAll(listToFilter);
        for (int i = listToFilter.size() - 1; i > listToFilter.size() - 1 - count && i >= 0; --i) {
            result.add((Breadcrumb)queue.pop());
        }
        return result;
    }
}

