/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Pair;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

class Breadcrumb {
    private final String screen;
    private final Long timestamp;
    private final String element;
    private final String location;
    private final BreadcrumbType type;

    Breadcrumb(String screen, long timestamp) {
        this(screen, null, null, timestamp, BreadcrumbType.VIEW);
    }

    Breadcrumb(Pair<Float, Float> point, String element, long timestamp, BreadcrumbType type) {
        this(null, point, element, timestamp, type);
    }

    private Breadcrumb(String screen, Pair<Float, Float> point, String element, long timestamp, BreadcrumbType type) {
        this.type = type;
        this.screen = screen;
        this.element = element;
        this.timestamp = timestamp;
        this.location = this.getStringForPoint(point);
    }

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.timestamp != null) {
                jsonObject.put("ts", (Object)this.timestamp);
            }
            if (this.screen != null) {
                jsonObject.put("vn", (Object)this.screen);
            }
            if (this.element != null) {
                jsonObject.put("tt", (Object)this.element);
            }
            if (this.location != null && this.type != BreadcrumbType.VIEW) {
                jsonObject.put("tl", (Object)this.location);
                if (this.getStringForTapType(this.type) != null) {
                    jsonObject.put("t", (Object)this.getStringForTapType(this.type));
                }
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    Long getTimestamp() {
        return this.timestamp;
    }

    String getScreen() {
        return this.screen;
    }

    private String getStringForPoint(Pair<Float, Float> point) {
        return String.format(Locale.US, "%d,%d", point != null ? ((Float)point.first).intValue() : 0, point != null ? ((Float)point.second).intValue() : 0);
    }

    private String getStringForTapType(BreadcrumbType type) {
        switch (type) {
            case TAP: {
                return "s";
            }
            case DOUBLE_TAP: {
                return "d";
            }
            case LONG_PRESS: {
                return "l";
            }
        }
        return null;
    }

    static enum BreadcrumbType {
        VIEW,
        TAP,
        DOUBLE_TAP,
        LONG_PRESS;

    }
}

