/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import io.embrace.android.embracesdk.BreadcrumbManager;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceManager;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.MemoryManager;
import io.embrace.android.embracesdk.SessionManager;
import java.util.Calendar;

public class ApplicationStateManager
implements ComponentCallbacks2,
Application.ActivityLifecycleCallbacks {
    private boolean isInBackground = true;
    private boolean foreground = false;
    private boolean paused = true;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable checkRunnable;
    private static final ApplicationStateManager manager = new ApplicationStateManager();

    static ApplicationStateManager getManager() {
        return manager;
    }

    private ApplicationStateManager() {
    }

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            MemoryManager.getManager().handleMemoryWarning();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    public void enable() {
        if (this.isInBackground) {
            try {
                this.isInBackground = false;
                SessionManager.manager.applicationEnteredForeground();
                this.removeHandlerCallbacks();
                this.setForeground(true);
                this.setPaused(false);
            }
            catch (EmbraceSdkException e) {
                EmbraceLogger.logError("Error while entering foreground", e);
            }
        }
    }

    private void disable() {
        if (!this.isInBackground) {
            SessionManager.manager.applicationEnteredBackground();
            this.isInBackground = true;
        }
    }

    boolean isInBackground() {
        return this.isInBackground;
    }

    public void removeHandlerCallbacks() {
        if (this.checkRunnable != null) {
            this.handler.removeCallbacks(this.checkRunnable);
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    public void setForeground(boolean foreground) {
        this.foreground = foreground;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setCallbacks() {
        this.checkRunnable = new Runnable(){

            @Override
            public void run() {
                if (ApplicationStateManager.this.foreground && ApplicationStateManager.this.paused) {
                    ApplicationStateManager.this.foreground = false;
                    ApplicationStateManager.this.disable();
                }
            }
        };
        this.handler.postDelayed(this.checkRunnable, 500L);
    }

    public void setBackgroundCallbacks() {
        if (this.isPaused()) {
            this.removeHandlerCallbacks();
            this.setCallbacks();
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.enable();
    }

    public void onActivityStarted(Activity activity) {
        this.enable();
        BreadcrumbManager.getManager().logView(activity.getClass().getName(), Calendar.getInstance().getTimeInMillis());
    }

    public void onActivityResumed(Activity activity) {
        this.setPaused(false);
        EmbraceManager.getInstance().setForegroundActivity(activity);
    }

    public void onActivityPaused(Activity activity) {
        this.setPaused(true);
        EmbraceManager.getInstance().setForegroundActivity(null);
    }

    public void onActivityStopped(Activity activity) {
        this.setBackgroundCallbacks();
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.setBackgroundCallbacks();
    }
}

