/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.lang.reflect.Field;

final class AppBuildConfig {
    private static final String BUILD_CONFIG_MANIFEST_KEY = "io.embrace.android.embracesdk.build.config";
    private static final String FIELD_DEBUG = "DEBUG";
    Class clazz = null;
    boolean isDebug = false;

    AppBuildConfig(Context context) {
        this(AppBuildConfig.getBuildConfigClassName(context));
    }

    AppBuildConfig(String className) {
        if (className != null) {
            try {
                this.clazz = Class.forName(className);
            }
            catch (Exception e) {
                EmbraceLogger.logError("Could not obtain handle to class: " + className, e);
                return;
            }
            this.isDebug = AppBuildConfig.getField(this.clazz, FIELD_DEBUG, this.isDebug);
        }
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    static <T> T getField(Class clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(null);
    }

    static <T> T getField(Class clazz, String fieldName, T defaultValue) {
        try {
            return AppBuildConfig.getField(clazz, fieldName);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("An exception was thrown while accessing field in class {class=%s, field=%s}.", clazz, fieldName), e);
            return defaultValue;
        }
    }

    static String getBuildConfigClassName(Context context) {
        if (context != null) {
            ApplicationInfo appInfo = null;
            try {
                appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            }
            catch (PackageManager.NameNotFoundException e) {
                EmbraceLogger.logError("Unable to get build config class from manifest.", (Exception)((Object)e));
                return null;
            }
            if (appInfo != null && appInfo.metaData.get(BUILD_CONFIG_MANIFEST_KEY) != null) {
                String className = AppBuildConfig.getBuildConfigClassNameFromMetadata(appInfo);
                return !TextUtils.isEmpty((CharSequence)className) ? className : AppBuildConfig.getBuildConfigClassNameFromAppId(appInfo);
            }
        }
        return null;
    }

    static String getBuildConfigClassNameFromMetadata(ApplicationInfo appInfo) {
        CharSequence className = appInfo.metaData.getCharSequence(BUILD_CONFIG_MANIFEST_KEY);
        return className != null ? className.toString() : null;
    }

    static String getBuildConfigClassNameFromAppId(ApplicationInfo appInfo) {
        return String.format("%s.BuildConfig", appInfo.metaData.getString("hostAppId"));
    }
}

