/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbRequest;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

class EmbraceAsyncTask
extends AsyncTask<Void, Void, Integer> {
    private final EmbRequest request;
    private final HttpURLConnection connection;
    private final EmbraceApiCallback callback;

    public EmbraceAsyncTask(HttpURLConnection connection, EmbRequest request, EmbraceApiCallback callback) {
        this.connection = connection;
        this.request = request;
        this.callback = callback;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.request.getCallbackHandler() == null) {
            this.request.setCallbackHandler(new Handler(Looper.getMainLooper()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doInBackground(Void ... voids) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream os = null;
        BufferedReader in = null;
        try {
            String inputLine;
            if (this.request.getPayload() != null) {
                boolean isImage;
                boolean bl = isImage = this.request.getHeaders() != null && this.request.getHeaders().containsKey("internal_content_type") && this.request.getHeaders().get("internal_content_type").equals("application/octet-stream");
                if (!isImage) {
                    os = new GZIPOutputStream(baos);
                    os.write(this.request.getPayload());
                    ((GZIPOutputStream)os).finish();
                    this.connection.getOutputStream().write(baos.toByteArray());
                } else {
                    this.connection.getOutputStream().write(this.request.getPayload());
                }
            }
            this.connection.connect();
            in = this.connection.getResponseCode() == 200 ? new BufferedReader(new InputStreamReader(this.connection.getInputStream())) : new BufferedReader(new InputStreamReader(this.connection.getErrorStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            if (this.connection.getResponseCode() == 200) {
                this.callback.onSuccess(response.toString());
            } else {
                this.callback.onError(response.toString(), this.connection.getResponseCode());
            }
        }
        catch (IOException e) {
            this.callback.onException(e);
        }
        catch (Exception e) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        EmbLogger.logWarning("Error while closing output stream", e);
                    }
                }
            }
        }
        return null;
    }
}

