/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import io.embrace.android.embracesdk.AppBuildConfig;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbServer;
import io.embrace.android.embracesdk.EmbSystemUtils;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceSdkException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbUser {
    private static final int EmbUserUpdatedMessageDelayInMiliseconds = 1000;
    private static final Integer EMB_PERSONA_MAX_ALLOWED_LENGTH = 16;
    private static final String PERSONA_REGEX = "^[a-zA-Z0-9_]{1," + EMB_PERSONA_MAX_ALLOWED_LENGTH + "}$";
    private static final String EmbPersonaNewUser = "new_user";
    private static final String EmbPersonaPowerUser = "power_user";
    private static final String EmbPersonaLoggedIn = "logged_in";
    private static final String EmbPersonaVip = "vip";
    private static final String EmbPersonaCreator = "content_creator";
    private static final String EmbPersonaTester = "tester";
    private static final String EmbPersonaPayer = "payer";
    private static final String EmbPersonaFirstDayUser = "first_day";
    private static Set<String> globalPersonas = null;
    private String internalIdentifier;
    private String emailAddress;
    private String username;
    private boolean payer;
    private boolean hasServerPersonas = false;
    private boolean userMessagePending;
    private Set<String> allPersonas;
    private Set<String> userPersonas;
    private Set<String> invalidPersonas;
    private final EmbSystemUtils systemUtils = EmbSystemUtils.getInstance();
    final AppBuildConfig buildConfig;
    private static final EmbUser singleton;

    static EmbUser getInstance() {
        return singleton;
    }

    private EmbUser() {
        Embrace.getInstance();
        this.buildConfig = new AppBuildConfig(Embrace.getContext());
        this.internalIdentifier = this.systemUtils.userIdentifier();
        this.emailAddress = this.systemUtils.userEmailAddress();
        this.payer = this.systemUtils.isUserPayer();
        this.allPersonas = new HashSet<String>(globalPersonas);
        Set<String> cachedCustomPersonas = this.systemUtils.customPersonas();
        if (cachedCustomPersonas != null) {
            this.allPersonas.addAll(cachedCustomPersonas);
        }
        this.userPersonas = this.systemUtils.userPersonas();
        if (this.userPersonas == null) {
            this.userPersonas = new HashSet<String>();
        }
        this.invalidPersonas = new HashSet<String>();
    }

    void updateInternalIdentifier(String identifier, EmbSystemUtils systemUtils) throws EmbraceSdkException {
        if (!TextUtils.equals((CharSequence)identifier, (CharSequence)systemUtils.userIdentifier())) {
            this.internalIdentifier = identifier;
            this.triggerUserUpdateMessage();
            systemUtils.setUserIdentifier(identifier);
        }
    }

    void updateEmailAddress(String emailAddress, EmbSystemUtils systemUtils) throws EmbraceSdkException {
        if (!TextUtils.equals((CharSequence)emailAddress, (CharSequence)systemUtils.userEmailAddress())) {
            this.emailAddress = emailAddress;
            this.triggerUserUpdateMessage();
            systemUtils.setUserEmailAddress(emailAddress);
        }
    }

    void updatePayingUser(boolean payer, EmbSystemUtils systemUtils) throws EmbraceSdkException {
        if (payer != systemUtils.isUserPayer()) {
            this.payer = payer;
            if (!payer) {
                this.removePersona(EmbPersonaPayer, systemUtils);
            }
            this.triggerUserUpdateMessage();
            systemUtils.setUserPayer(payer);
        }
    }

    Map<String, Object> mapRepresentation() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.internalIdentifier != null ? this.internalIdentifier : "");
        map.put("em", this.emailAddress != null ? this.emailAddress : "");
        Set<String> personas = this.userPersonas;
        if (this.payer) {
            personas.add(EmbPersonaPayer);
        }
        if (EmbSystemUtils.getInstance().isFirstDay()) {
            personas.add(EmbPersonaFirstDayUser);
            map.put("per", personas);
        }
        return map;
    }

    synchronized void updateServerPersonas(Set<String> personas, EmbSystemUtils systemUtils) throws EmbraceSdkException {
        this.allPersonas.addAll(personas);
        this.hasServerPersonas = true;
        systemUtils.setCustomPersonas(personas);
        boolean personasChanged = false;
        HashSet<String> validPersonas = new HashSet<String>();
        for (String persona : this.invalidPersonas) {
            if (!personas.contains(persona)) continue;
            validPersonas.add(persona);
            personasChanged = true;
        }
        this.userPersonas.addAll(validPersonas);
        for (String nowValid : validPersonas) {
            this.invalidPersonas.remove(nowValid);
        }
        Iterator<String> iter = this.userPersonas.iterator();
        while (iter.hasNext()) {
            if (this.allPersonas.contains(iter.next())) continue;
            iter.remove();
            personasChanged = true;
        }
        systemUtils.setUserPersonas(this.userPersonas);
        if (personasChanged) {
            this.triggerUserUpdateMessage();
        }
    }

    void setPersona(String persona, EmbSystemUtils systemUtils) throws EmbraceSdkException {
        if (this.userPersonas.contains(persona)) {
            return;
        }
        if (this.hasServerPersonas) {
            if (!this.allPersonas.contains(persona)) {
                if (this.buildConfig.isDebug()) {
                    EmbLogger.logWarning(String.format("persona %s is not on the registered list, ignoring", persona));
                }
                return;
            }
        } else if (!this.allPersonas.contains(persona)) {
            if (!this.personaIsAllowed(persona) && this.buildConfig.isDebug()) {
                EmbLogger.logWarning("personas must only consist of alphanumeric characters or underscores and be at most 16 characters");
                return;
            }
            this.invalidPersonas.add(persona);
            return;
        }
        this.userPersonas.add(persona);
        this.triggerUserUpdateMessage();
        systemUtils.setUserPersonas(this.userPersonas);
    }

    void removePersona(String persona, EmbSystemUtils systemUtils) throws EmbraceSdkException {
        if (this.userPersonas.contains(persona)) {
            this.userPersonas.remove(persona);
            this.triggerUserUpdateMessage();
            systemUtils.setUserPersonas(this.userPersonas);
        } else if (this.invalidPersonas.contains(persona)) {
            this.invalidPersonas.remove(persona);
        } else {
            EmbLogger.logDebug(String.format("persona %s is not currently set, ignoring", persona));
            return;
        }
    }

    private boolean personaIsAllowed(String persona) {
        return !TextUtils.isEmpty((CharSequence)persona) && persona.matches(PERSONA_REGEX);
    }

    void updateUsername(String username, EmbSystemUtils systemUtils) throws EmbraceSdkException {
        if (!TextUtils.equals((CharSequence)username, (CharSequence)systemUtils.getUsername())) {
            this.username = username;
            this.triggerUserUpdateMessage();
            systemUtils.setUsername(username);
            EmbLogger.logInfo(String.format("current user username updated: %s", username));
        }
    }

    private void triggerUserUpdateMessage() throws EmbraceSdkException {
        if (!this.userMessagePending) {
            this.userMessagePending = true;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.postDelayed(this.sendUserMessageCompletionRunnable(), 1000L);
        }
    }

    private Runnable sendUserMessageCompletionRunnable() throws EmbraceSdkException {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    EmbServer.getInstance().sendUserMessageCompletion(null);
                    EmbUser.this.userMessagePending = false;
                }
                catch (EmbraceSdkException e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, new EmbraceSdkException("error sending user message completion: " + e.getLocalizedMessage(), e));
                }
            }
        };
    }

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.internalIdentifier);
            jsonObject.put("em", (Object)this.emailAddress);
            jsonObject.put("un", (Object)this.username);
            JSONArray array = new JSONArray();
            if (this.payer) {
                this.userPersonas.add(EmbPersonaPayer);
            }
            if (this.systemUtils.isFirstDay()) {
                this.userPersonas.add(EmbPersonaFirstDayUser);
            }
            for (String s : this.userPersonas) {
                array.put((Object)s);
            }
            jsonObject.put("per", (Object)array);
        }
        catch (JSONException object) {
            jsonObject = null;
        }
        return jsonObject;
    }

    static {
        globalPersonas = new HashSet<String>(Arrays.asList(EmbPersonaNewUser, EmbPersonaPowerUser, EmbPersonaLoggedIn, EmbPersonaVip, EmbPersonaCreator, EmbPersonaTester));
        singleton = new EmbUser();
    }
}

