/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import io.embrace.android.embracesdk.EmbDevice;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.helpers.SharedPreferencesUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class EmbSystemUtils {
    static final long DAY_IN_MS = 86400000L;
    static String EmbPreviousAppVersionKey = "io.embrace.lastappversion";
    static String EmbPreviousOsVersionKey = "io.embrace.lastosversion";
    static String EmbInstallDateKey = "io.embrace.installtimestamp";
    private static String EmbUserIdentifierKey = "io.embrace.userid";
    private static String EmbUserEmailAddressKey = "io.embrace.useremail";
    private static String EmbUserUsernameKey = "io.embrace.username";
    private static String EmbUserIsPayerKey = "io.embrace.userispayer";
    private static String EmbUserPersonasKey = "io.embrace.userpersonas";
    private static String EmbCustomPersonasKey = "io.embrace.custompersonas";
    private static String EmbLastUserMessageFailedKey = "io.embrace.userupdatefailed";
    private static String EmbDeviceIdentifierKey = "io.embrace.deviceid";
    private static String EmbSdkDisabledKey = "io.embrace.disabled";
    private static String EmbSdkStartupStatusKey = "io.embrace.sdkstartup";
    private static String EmbSdkStartupInProgress = "startup_entered";
    private static String EmbSdkStartupCompleted = "startup_completed";
    private static EmbSystemUtils singleton = new EmbSystemUtils();
    private String deviceId;

    private EmbSystemUtils() {
        if (Embrace.getContext() != null) {
            String secureId = Settings.Secure.getString((ContentResolver)Embrace.getContext().getContentResolver(), (String)"android_id");
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (messageDigest != null && secureId != null) {
                messageDigest.update(secureId.getBytes(), 0, secureId.length());
                this.deviceId = new BigInteger(1, messageDigest.digest()).toString(16).toUpperCase(Locale.getDefault());
            } else {
                this.deviceId = secureId;
            }
        }
    }

    static EmbSystemUtils getInstance() {
        return singleton;
    }

    String getDeviceId() {
        return this.deviceId;
    }

    boolean isUserPayer() {
        return SharedPreferencesUtils.getBooleanPreference(Embrace.getContext(), EmbUserIsPayerKey, false);
    }

    String userIdentifier() {
        return SharedPreferencesUtils.getStringPreference(Embrace.getContext(), EmbUserIdentifierKey);
    }

    String userEmailAddress() {
        return SharedPreferencesUtils.getStringPreference(Embrace.getContext(), EmbUserEmailAddressKey);
    }

    Set<String> userPersonas() {
        return SharedPreferencesUtils.getArrayPreference(Embrace.getContext(), EmbUserPersonasKey, null);
    }

    Set<String> customPersonas() {
        return SharedPreferencesUtils.getArrayPreference(Embrace.getContext(), EmbCustomPersonasKey, null);
    }

    String getUsername() {
        return SharedPreferencesUtils.getStringPreference(Embrace.getContext(), EmbUserUsernameKey);
    }

    void setUserPayer(boolean payer) {
        SharedPreferencesUtils.setBooleanPreference(Embrace.getContext(), EmbUserIsPayerKey, payer);
    }

    void setUserIdentifier(String identifier) {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), EmbUserIdentifierKey, identifier);
    }

    void setUserEmailAddress(String emailAddress) {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), EmbUserEmailAddressKey, emailAddress);
    }

    void setUserPersonas(Set<String> personas) {
        SharedPreferencesUtils.setArrayPreference(Embrace.getContext(), EmbUserPersonasKey, personas);
    }

    void setCustomPersonas(Set<String> personas) {
        SharedPreferencesUtils.setArrayPreference(Embrace.getContext(), EmbCustomPersonasKey, personas);
    }

    void setUsername(String username) {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), EmbUserUsernameKey, username);
    }

    public Map<String, Object> appAndUserData(Context context) {
        String appVersion = SharedPreferencesUtils.getStringPreference(context, EmbPreviousAppVersionKey);
        Integer osVersion = SharedPreferencesUtils.getIntegerPreference(context, EmbPreviousOsVersionKey, -1);
        String userDefaultsDeviceIdentifier = SharedPreferencesUtils.getStringPreference(context, EmbDeviceIdentifierKey);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (appVersion != null) {
            map.put("av", appVersion);
        }
        if (osVersion != -1) {
            map.put("os", osVersion);
        }
        if (userDefaultsDeviceIdentifier != null) {
            map.put("uid", userDefaultsDeviceIdentifier);
        }
        return map;
    }

    void updateAppAndUserData() {
        EmbDevice device = EmbDevice.getInstance();
        String appVersion = device.getAppVersion();
        String osVersion = device.getOperatingSystemVersion();
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), EmbPreviousAppVersionKey, appVersion);
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), EmbPreviousOsVersionKey, osVersion);
        if (SharedPreferencesUtils.getLongPreference(Embrace.getContext(), EmbInstallDateKey, -1L) == -1L) {
            SharedPreferencesUtils.setLongPreference(Embrace.getContext(), EmbInstallDateKey, Calendar.getInstance().getTimeInMillis());
        }
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), EmbDeviceIdentifierKey, this.getDeviceId());
    }

    boolean isAppUpdated() {
        String cachedVersion;
        String currentVersion = EmbDevice.getInstance().getAppVersion();
        return !currentVersion.equals(cachedVersion = SharedPreferencesUtils.getStringPreference(Embrace.getContext(), EmbPreviousAppVersionKey));
    }

    boolean osUpdated() {
        String osVersion = EmbDevice.getInstance().getOperatingSystemVersion();
        String cachedVersion = SharedPreferencesUtils.getStringPreference(Embrace.getContext(), EmbPreviousOsVersionKey);
        return cachedVersion != null && !osVersion.equals(cachedVersion);
    }

    boolean isFirstDay() {
        long installDate = SharedPreferencesUtils.getLongPreference(Embrace.getContext(), EmbInstallDateKey, -1L);
        return installDate != -1L ? Calendar.getInstance().getTimeInMillis() - installDate <= 86400000L : false;
    }

    boolean sdkDisabledFromSavedConfig() {
        return SharedPreferencesUtils.getBooleanPreference(Embrace.getContext(), EmbSdkDisabledKey, false);
    }

    boolean sdkStartupFailedLastSession() {
        String lastSessionProgress = SharedPreferencesUtils.getStringPreference(Embrace.getContext(), EmbSdkStartupStatusKey);
        if (lastSessionProgress == null) {
            return false;
        }
        return !lastSessionProgress.equals(EmbSdkStartupCompleted);
    }

    void recordStartupBegun() {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), EmbSdkStartupStatusKey, EmbSdkStartupInProgress);
    }

    void recordStartupCompleted() {
        SharedPreferencesUtils.setStringPreference(Embrace.getContext(), EmbSdkStartupStatusKey, EmbSdkStartupCompleted);
    }

    synchronized void setSdkDisabled(boolean disabled) {
        SharedPreferencesUtils.setBooleanPreference(Embrace.getContext(), EmbSdkDisabledKey, disabled);
    }

    boolean userMessageNeedsRetry() {
        return SharedPreferencesUtils.getBooleanPreference(Embrace.getContext(), EmbLastUserMessageFailedKey, false);
    }

    synchronized void setUserMessageNeedsRetry(boolean needsRetry) {
        SharedPreferencesUtils.setBooleanPreference(Embrace.getContext(), EmbLastUserMessageFailedKey, needsRetry);
    }
}

