/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import io.embrace.android.embracesdk.EmbApplicationStateManager;
import io.embrace.android.embracesdk.EmbBreadcrumb;
import io.embrace.android.embracesdk.EmbBreadcrumbManager;
import io.embrace.android.embracesdk.EmbDevice;
import io.embrace.android.embracesdk.EmbFileUtils;
import io.embrace.android.embracesdk.EmbInterval;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbManager;
import io.embrace.android.embracesdk.EmbMemoryManager;
import io.embrace.android.embracesdk.EmbMemorySample;
import io.embrace.android.embracesdk.EmbNetworkInfo;
import io.embrace.android.embracesdk.EmbNetworkManager;
import io.embrace.android.embracesdk.EmbNetworkPerformance;
import io.embrace.android.embracesdk.EmbPowerManager;
import io.embrace.android.embracesdk.EmbProcessManager;
import io.embrace.android.embracesdk.EmbScreenshot;
import io.embrace.android.embracesdk.EmbServer;
import io.embrace.android.embracesdk.EmbSession;
import io.embrace.android.embracesdk.EmbSystemEvent;
import io.embrace.android.embracesdk.EmbSystemUtils;
import io.embrace.android.embracesdk.EmbUser;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.constants.EmbApiConstants;
import io.embrace.android.embracesdk.helpers.EmbFileCache;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbSessionManager {
    private static final long SHUTDOWN_TIMEOUT_MS = 2000L;
    private static final String EmbSessionInfoUUIDKey = "id";
    private static final String EmbSessionInfoNumberKey = "num";
    private static final String EmbSessionTerminationReceivedString = "yes";
    private static final int EmbSessionHeartbeatIntervalInSeconds = 5;
    private static final int EmbScreenshotCooldownIntervalInMilliseconds = 3000;
    private static final int EmbScreenshotJpegCompressionValue = 70;
    static final EmbSessionManager manager = new EmbSessionManager();
    private boolean lastSessionReceivedTermination;
    private final Map<String, EmbSession> sessions = new HashMap<String, EmbSession>();
    private final Map<String, EmbSession> unsentSessions = new HashMap<String, EmbSession>();
    private EmbSession currentSession;
    private EmbSession lastSession;
    private boolean recentScreenshotTaken;
    private boolean isManagerEnabled = false;
    private Future sessionHeartbeatTimer;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private Runnable sendSessionRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                EmbSessionManager.this.sendPreviousSession();
            }
            catch (EmbraceSdkException e) {
                EmbLogger.logError("Error while sending session", e);
            }
        }
    };
    private Runnable processSessionHeartbeatRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                EmbSessionManager.this.processSessionHeartbeat();
            }
            catch (EmbraceSdkException e) {
                EmbLogger.logError("error while processing session heartbeat", e);
            }
        }
    };

    private EmbSessionManager() {
    }

    synchronized void performStartup(boolean inBackground) throws EmbraceSdkException {
        String terminationLog = EmbFileUtils.readStringFromFile(EmbFileCache.EmbFileCacheTerminationMessage);
        if (EmbSessionTerminationReceivedString.equals(terminationLog)) {
            this.lastSessionReceivedTermination = true;
        }
        EmbFileUtils.removeFileAtPath(EmbFileCache.EmbFileCacheTerminationMessage);
        this.checkForUnsentSessions(this.lastSessionReceivedTermination);
        if (!inBackground) {
            this.createSession();
        }
    }

    private void createSession() throws EmbraceSdkException {
        EmbSession newSession;
        if (this.currentSession != null) {
            EmbLogger.logWarning("tried to create a new session but a current session exists");
            this.unsentSessions.put(this.currentSession.getSessionId(), this.currentSession);
            return;
        }
        this.getUnsentSessions();
        this.currentSession = newSession = new EmbSession(this.numberForNextSession());
        this.sessions.put(newSession.getSessionId(), newSession);
        this.unsentSessions.put(newSession.getSessionId(), newSession);
        Future sessionTimer = this.sessionHeartbeatTimer;
        if (sessionTimer != null) {
            sessionTimer.cancel(true);
        }
        if (EmbManager.getInstance().isSdkInitialized()) {
            this.scheduleAndSendSessionStart();
        }
        EmbLogger.logDebug(String.format("created new session with id %s", newSession.getSessionId()));
    }

    private void endCurrentSession() {
        EmbSession current = this.currentSession;
        if (current == null) {
            EmbLogger.logWarning("can't end current session because current session is null");
            return;
        }
        current.endSession();
        if (this.sessionHeartbeatTimer != null) {
            this.sessionHeartbeatTimer.cancel(true);
        }
        this.lastSession = current;
        try {
            this.saveUnsentSessions();
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving unsent sessions", e);
        }
        this.currentSession = null;
        if (EmbManager.getInstance().shouldRecordEvents()) {
            this.executorService.schedule(this.sendSessionRunnable, 0L, TimeUnit.MILLISECONDS);
        } else {
            EmbLogger.logWarning("Sdk is disabled, ignoring sending of session");
        }
    }

    private Integer numberForNextSession() throws EmbraceSdkException {
        Object uuid;
        Map<String, Object> sessionInfo = EmbFileUtils.readSessionInfoFile();
        Integer sessionNumber = 0;
        if (sessionInfo != null) {
            EmbLogger.logDebug(String.format("got session info %s", sessionInfo.toString()));
            uuid = sessionInfo.get(EmbSessionInfoUUIDKey).toString();
            if (((String)uuid).equals(EmbSystemUtils.getInstance().getDeviceId())) {
                sessionNumber = (Integer)sessionInfo.get(EmbSessionInfoNumberKey);
            }
        } else {
            EmbLogger.logDebug("session info was null");
        }
        uuid = sessionNumber;
        Integer n = sessionNumber = Integer.valueOf(sessionNumber + 1);
        HashMap<String, Object> updatedSessionInfo = new HashMap<String, Object>();
        updatedSessionInfo.put(EmbSessionInfoNumberKey, sessionNumber);
        updatedSessionInfo.put(EmbSessionInfoUUIDKey, EmbSystemUtils.getInstance().getDeviceId());
        EmbFileUtils.updateSessionInfoFileContents(updatedSessionInfo);
        return sessionNumber;
    }

    private void sendPreviousSession() throws EmbraceSdkException {
        final EmbSession previousSession = this.lastSession;
        if (previousSession == null) {
            EmbLogger.logWarning("can't send previous session because it's null");
            return;
        }
        this.lastSession = null;
        previousSession.addPayload(EmbUser.getInstance().toJsonObject(), "u");
        previousSession.addPayload(EmbDevice.getInstance().getAppInfoJsonObject(), "a");
        previousSession.addPayload(EmbDevice.getInstance().getDeviceInfoJsonObject(), "d");
        this.addPerformanceMetaDataToSession(previousSession);
        this.addBreadcrumbsToSession(previousSession);
        EmbServer.getInstance().sendSession(previousSession, new EmbraceApiCallback(){

            @Override
            public void onSuccess(String response) throws Exception {
                EmbSessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                EmbSessionManager.this.saveUnsentSessions();
            }

            @Override
            public void onError(String error, int statusCode) throws Exception {
                EmbSessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                EmbSessionManager.this.saveUnsentSessions();
            }

            @Override
            public void onException(Exception e) {
                EmbSessionManager.this.unsentSessions.remove(previousSession.getSessionId());
                try {
                    EmbSessionManager.this.saveUnsentSessions();
                }
                catch (EmbraceSdkException e1) {
                    EmbLogger.logError("Error saving unsent sessions %s", e1);
                }
            }
        });
    }

    void scheduleAndSendSessionStart() throws EmbraceSdkException {
        if (EmbManager.getInstance().shouldRecordEvents()) {
            this.sessionHeartbeatTimer = this.executorService.scheduleAtFixedRate(this.processSessionHeartbeatRunnable, 0L, 5L, TimeUnit.SECONDS);
            if (this.currentSession != null) {
                this.sendSessionStart(this.currentSession);
            }
        } else {
            EmbLogger.logWarning("Sdk is disabled, ignoring sending of session start");
        }
    }

    private void sendSessionStart(EmbSession session) throws EmbraceSdkException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("s", session.startMessagePayload());
        payload.put("d", EmbDevice.getInstance().getDeviceInfoMapObject());
        payload.put("a", EmbDevice.getInstance().getAppInfoMapObject());
        payload.put("v", EmbApiConstants.EmbMessageFormatVersion);
        EmbServer.getInstance().sendStartOfSession(payload, null);
    }

    void sendSessionStartAfterReactivating() {
        if (this.currentSession != null) {
            try {
                this.sendSessionStart(this.currentSession);
            }
            catch (EmbraceSdkException e) {
                EmbLogger.logError("Error while sending start of session.", e);
            }
        }
    }

    private void processSessionHeartbeat() throws EmbraceSdkException {
        EmbSession current = this.currentSession;
        if (current == null) {
            EmbLogger.logWarning("tried to process session heartbeat without current session");
            return;
        }
        current.recordHeartbeat();
        current.setCachedAppData(EmbDevice.getInstance().getAppInfoJsonObject());
        current.setCachedPerformanceData(this.getPerformanceDataForSession(current));
        current.setCachedBreadcrumbData(this.getBreadcrumbDataForSession());
        current.setCachedDeviceData(EmbDevice.getInstance().getDeviceInfoJsonObject());
        current.setCachedUserData(EmbUser.getInstance().toJsonObject());
        this.saveUnsentSessions();
    }

    void recordColdStart() {
        this.currentSession.setColdStart(true);
    }

    void applicationEnteredBackground() {
        this.currentSession.recordStateChange();
        this.endCurrentSession();
        EmbManager.getInstance().deactivateDataManagers();
    }

    void applicationEnteredForeground() throws EmbraceSdkException {
        EmbManager.getInstance().activateDataManagers();
        this.createSession();
    }

    String getCurrentSessionId() {
        if (this.currentSession == null) {
            return null;
        }
        return this.currentSession.getSessionId();
    }

    void recordNewStory(String storyId) {
        if (this.currentSession == null) {
            EmbLogger.logWarning("no current session, session manager ignoring new story id");
            return;
        }
        this.currentSession.addStoryId(storyId);
    }

    void recordInfoLog(String messageId) {
        if (this.currentSession == null) {
            EmbLogger.logWarning("no current session, session manager ignoring new info log id");
            return;
        }
        this.currentSession.addInfoLogId(messageId);
    }

    void recordErrorLog(String messageId) {
        if (this.currentSession == null) {
            EmbLogger.logWarning("no current session, session manager ignoring new error log id");
            return;
        }
        this.currentSession.addErrorLogId(messageId);
    }

    synchronized void enable() {
        if (!this.isManagerEnabled) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.sessionHeartbeatTimer = this.executorService.scheduleAtFixedRate(this.processSessionHeartbeatRunnable, 0L, 5L, TimeUnit.SECONDS);
            this.isManagerEnabled = true;
        }
    }

    synchronized void disable(boolean isDiabledFromConfig) {
        if (this.isManagerEnabled) {
            try {
                if (this.sessionHeartbeatTimer != null) {
                    this.sessionHeartbeatTimer.cancel(true);
                }
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                    EmbLogger.logWarning("Executor service was not safely terminated.");
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                EmbLogger.logWarning("Error while shutting down executor", e);
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            if (isDiabledFromConfig && this.currentSession != null) {
                this.unsentSessions.remove(this.currentSession.getSessionId());
                try {
                    this.saveUnsentSessions();
                }
                catch (EmbraceSdkException e) {
                    EmbLogger.logWarning("Error while saving usnent sessions", e);
                }
            }
            this.isManagerEnabled = false;
        }
    }

    boolean triggerEventSnapshot(String messageId, EmbScreenshotReason embScreenshotReason) throws EmbraceSdkException {
        if (!EmbManager.getInstance().isScreenshotsEnabled() || EmbApplicationStateManager.getManager().isInBackground() || this.recentScreenshotTaken) {
            EmbLogger.logDebug("screenshots disabled or cooling down");
            return false;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                EmbSessionManager.this.recentScreenshotTaken = false;
            }
        }, 3000L);
        this.sendScreenshot(messageId, embScreenshotReason, EmbManager.getInstance().getForegroundActivity());
        this.recentScreenshotTaken = true;
        return true;
    }

    byte[] processScreenshot(Bitmap screenshot) {
        if (screenshot == null) {
            EmbLogger.logWarning("asked to process null screenshot, aborting");
            return null;
        }
        EmbLogger.logDebug("processing screenshot");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        screenshot.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)stream);
        screenshot.recycle();
        return stream.toByteArray();
    }

    void sendScreenshot(String messageId, EmbScreenshotReason reason, Activity activity) throws EmbraceSdkException {
        byte[] data = this.processScreenshot(this.takeScreenshot(activity));
        EmbServer.getInstance().sendScreenshot(new EmbScreenshot(reason == EmbScreenshotReason.LATE ? messageId : null, reason == EmbScreenshotReason.LATE ? null : messageId, data), null);
    }

    Bitmap takeScreenshot(Activity activity) throws EmbraceSdkException {
        View view;
        if (activity != null && (view = activity.getWindow().getDecorView()) != null) {
            Bitmap screenshot = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(screenshot);
            view.draw(canvas);
            return screenshot;
        }
        return null;
    }

    List<String> getStackTraceForCurrentThread() {
        ArrayList<String> augmentedStackReturnAddresses = new ArrayList<String>();
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            augmentedStackReturnAddresses.add(ste.toString());
        }
        return augmentedStackReturnAddresses;
    }

    private void checkForUnsentSessions(boolean terminationMessage) throws EmbraceSdkException {
        this.getUnsentSessions();
        if (this.currentSession != null && this.unsentSessions.containsKey(this.currentSession.getSessionId())) {
            this.unsentSessions.remove(this.currentSession.getSessionId());
        }
        if (!this.unsentSessions.isEmpty()) {
            EmbLogger.logDebug(String.format("found %s unsent sessions in cache, sending to server", this.unsentSessions.size()));
            for (EmbSession session : this.unsentSessions.values()) {
                session.setReceivedTermination(terminationMessage);
                session.addPayload(session.getCachedAppData(), "a");
                session.addPayload(session.getCachedUserData(), "u");
                session.addPayload(session.getCachedDeviceData(), "d");
                session.addPayload(session.getCachedPerformanceData(), "p");
                session.addPayload(session.getCachedBreadcrumbData(), "br");
            }
            EmbServer.getInstance().addFailedSessions(this.unsentSessions.values());
            this.unsentSessions.clear();
            this.saveUnsentSessions();
        }
    }

    void saveSessionAfterCrash() throws EmbraceSdkException {
        this.unsentSessions.put(this.currentSession.getSessionId(), this.currentSession);
        this.saveUnsentSessions();
    }

    private void addBreadcrumbsToSession(EmbSession session) {
        JSONObject breadcrumbData = this.getBreadcrumbDataForSession();
        session.addPayload(breadcrumbData, "br");
    }

    private void addPerformanceMetaDataToSession(EmbSession session) {
        JSONObject performanceData = this.getPerformanceDataForSession(session);
        session.addPayload(performanceData, "p");
    }

    private JSONObject getBreadcrumbDataForSession() {
        JSONObject jsonObject = new JSONObject();
        List<EmbBreadcrumb> viewBreadcrumbs = EmbBreadcrumbManager.getManager().getRecentViewBreadcrumbs(5);
        JSONArray viewBreadcrumbPayloads = new JSONArray();
        for (EmbBreadcrumb breadcrumb : viewBreadcrumbs) {
            viewBreadcrumbPayloads.put((Object)breadcrumb.toJsonObject());
        }
        List<EmbBreadcrumb> tapBreadcrumbs = EmbBreadcrumbManager.getManager().getRecentTapBreadcrumbs(20);
        JSONArray tapBreadcrumbPayloads = new JSONArray();
        for (EmbBreadcrumb breadcrumb : tapBreadcrumbs) {
            tapBreadcrumbPayloads.put((Object)breadcrumb.toJsonObject());
        }
        try {
            jsonObject.put("vb", (Object)viewBreadcrumbPayloads);
            jsonObject.put("tb", (Object)tapBreadcrumbPayloads);
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    private JSONObject getPerformanceDataForSession(EmbSession session) {
        if (session == null) {
            EmbLogger.logWarning("can't compute performance data without session");
            return null;
        }
        JSONObject performance = new JSONObject();
        try {
            performance.put("bt", (double)EmbPowerManager.getManager().getBatteryLevel());
            performance.put("ds", (Object)EmbDevice.getInstance().getSystemMemoryAsJson());
            JSONArray cpuPayload = new JSONArray();
            for (EmbInterval interval : EmbProcessManager.getManager().getCriticalIntervalsDuringSession(session)) {
                cpuPayload.put((Object)interval.getServerPayload());
            }
            performance.put("cp", (Object)cpuPayload);
            List<EmbMemorySample> memorySamples = EmbMemoryManager.getManager().getMemorySamplesDuringSession(session);
            JSONArray memoryPayload = new JSONArray();
            for (EmbMemorySample memorySample : memorySamples) {
                memoryPayload.put((Object)memorySample.toJson());
            }
            performance.put("me", (Object)memoryPayload);
            List<EmbSystemEvent> lowMemoryWarnings = EmbMemoryManager.getManager().getMemoryWarningsDuringSession(session);
            JSONArray lowMemoryPayload = new JSONArray();
            for (EmbSystemEvent systemEvent : lowMemoryWarnings) {
                lowMemoryPayload.put((Object)systemEvent.toJson());
            }
            performance.put("mw", (Object)lowMemoryPayload);
            List<EmbInterval> chargingIntervals = EmbPowerManager.getManager().getChargingIntervalsDuringSession(session);
            JSONArray chargingPayload = new JSONArray();
            for (EmbInterval interval : chargingIntervals) {
                chargingPayload.put((Object)interval.getServerPayload());
            }
            performance.put("bc", (Object)chargingPayload);
            List<EmbSystemEvent> batteryMeasurements = EmbPowerManager.getManager().getBatteryMeasurementsDuringSession(session);
            JSONArray batteryPayload = new JSONArray();
            for (EmbSystemEvent measurement : batteryMeasurements) {
                batteryPayload.put((Object)measurement.toJson());
            }
            performance.put("bm", (Object)batteryPayload);
            List<EmbInterval> netInterfaceIntervals = EmbNetworkManager.getManager().getReachabilityIntervalsDuringSession(session);
            JSONArray netInterfacePayload = new JSONArray();
            for (EmbInterval interval : netInterfaceIntervals) {
                netInterfacePayload.put((Object)interval.getServerPayload());
            }
            performance.put("ns", (Object)netInterfacePayload);
            List<EmbNetworkPerformance> networkPerformances = EmbNetworkManager.getManager().getRequestsDuringSession(session);
            performance.put("nr", (Object)this.getNetworkRequestDataWithPerformance(networkPerformances));
        }
        catch (JSONException e) {
            performance = null;
        }
        return performance;
    }

    private synchronized void saveUnsentSessions() throws EmbraceSdkException {
        HashMap<String, String> unsentSessions = new HashMap<String, String>();
        for (Map.Entry<String, EmbSession> entry : this.unsentSessions.entrySet()) {
            unsentSessions.put(entry.getKey(), entry.getValue().toJson());
        }
        EmbFileUtils.saveMapToFile(unsentSessions, EmbFileCache.EmbFileCacheUnsentSessions);
    }

    private synchronized void getUnsentSessions() throws EmbraceSdkException {
        Map unsentSessions = EmbFileUtils.readMapFromFile(EmbFileCache.EmbFileCacheUnsentSessions);
        for (Map.Entry entry : unsentSessions.entrySet()) {
            this.unsentSessions.put(entry.getKey(), new EmbSession((String)entry.getValue()));
        }
    }

    private JSONObject getNetworkRequestDataWithPerformance(List<EmbNetworkPerformance> performanceInfo) {
        JSONObject jsonObject = new JSONObject();
        int timeThreshold = EmbManager.getInstance().getProblematicRequestLatency();
        HashMap requestStats = new HashMap();
        HashMap requestStatsCurrent = new HashMap();
        JSONArray performanceLogs = new JSONArray();
        for (EmbNetworkPerformance embNetworkPerformance : performanceInfo) {
            if (embNetworkPerformance.getStatusCode() <= 0) continue;
            if (embNetworkPerformance.getFormattedUrl() != null) {
                ArrayList<EmbNetworkInfo> networkInfos = requestStats.get(embNetworkPerformance.getFormattedUrl()) != null ? (List)requestStats.get(embNetworkPerformance.getFormattedUrl()) : new ArrayList<EmbNetworkInfo>();
                networkInfos.add(new EmbNetworkInfo(embNetworkPerformance.getElapsedTime(), embNetworkPerformance.getStatusCode(), embNetworkPerformance.getStartTime()));
                requestStats.put(embNetworkPerformance.getFormattedUrl(), networkInfos);
                HashMap<String, Integer> statusCodeCounts = (HashMap<String, Integer>)requestStatsCurrent.get(embNetworkPerformance.getUrl());
                String statusCodeString = String.valueOf(embNetworkPerformance.getStatusCode());
                if (statusCodeCounts != null) {
                    if (statusCodeCounts.get(statusCodeString) != null) {
                        statusCodeCounts.put(statusCodeString, (Integer)statusCodeCounts.get(statusCodeString) + 1);
                    } else {
                        statusCodeCounts.put(statusCodeString, 1);
                    }
                } else {
                    statusCodeCounts = new HashMap<String, Integer>();
                    statusCodeCounts.put(statusCodeString, 1);
                    requestStatsCurrent.put(embNetworkPerformance.getUrl(), statusCodeCounts);
                }
            }
            if (embNetworkPerformance.getStatusCode() < 300 && embNetworkPerformance.getElapsedTime() < (long)timeThreshold) continue;
            performanceLogs.put((Object)embNetworkPerformance.toJson());
        }
        JSONObject resultNetworkInfo = new JSONObject();
        for (String key : requestStats.keySet()) {
            JSONObject networkInfo = new JSONObject();
            List networkInfos = (List)requestStats.get(key);
            JSONArray networkInfoArray = new JSONArray();
            for (EmbNetworkInfo info : networkInfos) {
                networkInfoArray.put((Object)info.toJson());
            }
            try {
                networkInfo.put("rq", (Object)networkInfoArray);
                networkInfo.put("rc", networkInfoArray.length());
                resultNetworkInfo.put(key, (Object)networkInfo);
            }
            catch (JSONException e) {
                networkInfo = new JSONObject();
            }
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("rs", (Object)new JSONObject(requestStatsCurrent));
            jSONObject.put("rd", (Object)resultNetworkInfo);
            jSONObject.put("pr", (Object)performanceLogs);
            jsonObject.put("hr", (Object)jSONObject);
        }
        catch (JSONException e) {
            Object var8_11 = null;
            jsonObject = null;
        }
        return jsonObject;
    }

    static enum EmbScreenshotReason {
        LATE,
        LOG;

    }
}

