/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbSystemUtils;
import io.embrace.android.embracesdk.EmbraceSdkException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbSdkConfig {
    private static final int EmbDefaultThreshold = 100;
    private static final int EmbDefaultOffset = 0;
    private int threshold = 100;
    private int offset = 0;
    private boolean screenshotsEnabled;
    private Set<String> appPersonas = new HashSet<String>();
    private Map<String, Long> eventLimits = new HashMap<String, Long>();

    int getThreshold() {
        return this.threshold;
    }

    boolean isScreenshotsEnabled() {
        return this.screenshotsEnabled;
    }

    Set<String> getAppPersonas() {
        return this.appPersonas;
    }

    Map<String, Long> getEventLimits() {
        return this.eventLimits;
    }

    EmbSdkConfig(JSONObject config) throws EmbraceSdkException {
        try {
            if (config.has("threshold")) {
                this.threshold = config.getInt("threshold");
            }
            if (config.has("offset")) {
                this.offset = config.getInt("offset");
            }
            if (config.has("screenshots_enabled")) {
                this.screenshotsEnabled = config.getBoolean("screenshots_enabled");
            } else {
                EmbLogger.logWarning("enable screenshot field not present in config");
                this.screenshotsEnabled = true;
            }
            if (config.has("personas")) {
                JSONArray array = config.getJSONArray("personas");
                for (int idx = 0; idx < array.length(); ++idx) {
                    this.appPersonas.add(array.getString(idx));
                }
            }
            if (config.has("event_limits")) {
                JSONObject eventLimitsJsonObject = config.getJSONObject("event_limits");
                Iterator eventLimitKeysIterator = eventLimitsJsonObject.keys();
                while (eventLimitKeysIterator.hasNext()) {
                    String key = (String)eventLimitKeysIterator.next();
                    this.eventLimits.put(key, eventLimitsJsonObject.getLong(key));
                }
            }
        }
        catch (JSONException e) {
            EmbLogger.logWarning("Unable to convert JSON to object");
            throw new EmbraceSdkException("Unable to convert JSON to object", e);
        }
    }

    String encodeObjectForSaving() throws EmbraceSdkException {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("threshold", this.threshold);
            jsonObject.put("offset", this.offset);
            jsonObject.put("screenshots_enabled", this.screenshotsEnabled);
            jsonObject.put("event_limits", (Object)new JSONObject(this.eventLimits));
            JSONArray array = new JSONArray();
            for (String persona : this.appPersonas) {
                array.put((Object)persona);
            }
            jsonObject.put("personas", (Object)array);
        }
        catch (JSONException e) {
            EmbLogger.logWarning("Unable to convert object to JSON");
            throw new EmbraceSdkException("Unable to convert object to JSON", e);
        }
        return jsonObject.toString();
    }

    boolean isEnabled(EmbSystemUtils systemUtils) {
        int upperBound;
        String deviceId = systemUtils.getDeviceId();
        if (deviceId == null || deviceId.length() < 2) {
            return false;
        }
        String finalChars = deviceId.substring(deviceId.length() - 2);
        float result = (float)Integer.valueOf(finalChars, 16).intValue() / 255.0f * 100.0f;
        int lowerBound = Math.max(0, this.offset);
        return lowerBound != (upperBound = Math.min(this.offset + this.threshold, 100)) && (float)lowerBound <= result && (float)upperBound >= result;
    }
}

