/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Log;
import io.embrace.android.embracesdk.EmbDebugMessage;
import io.embrace.android.embracesdk.EmbException;
import io.embrace.android.embracesdk.EmbManager;
import io.embrace.android.embracesdk.helpers.EmbLogLevel;
import java.util.Map;
import java.util.Stack;

final class EmbLogger {
    private EmbLogger() {
    }

    static void logDebug(String msg) {
        EmbLogger.logDebug(msg, null, null);
    }

    static void logDebug(String msg, Exception e) {
        EmbLogger.logDebug(msg, e, null);
    }

    static void logDebug(String msg, Exception e, Map<String, Object> data) {
        if (EmbManager.logLevel.ordinal() <= EmbLogLevel.EmbLogLevelDebug.ordinal()) {
            Log.d((String)"[Embrace] ", (String)String.format(msg + " %s", e != null ? e : ""));
            EmbLogger.addDebugMessage(EmbDebugMessage.EmbDebugMessageType.DEBUG, msg, e, data);
        }
    }

    static void logInfo(String msg) {
        EmbLogger.logInfo(msg, null, null);
    }

    static void logInfo(String msg, Exception e) {
        EmbLogger.logInfo(msg, e, null);
    }

    static void logInfo(String msg, Exception e, Map<String, Object> data) {
        if (EmbManager.logLevel.ordinal() <= EmbLogLevel.EmbLogLevelInfo.ordinal()) {
            Log.i((String)"[Embrace] ", (String)String.format(msg + " %s", e != null ? e : ""));
            EmbLogger.addDebugMessage(EmbDebugMessage.EmbDebugMessageType.INFO, msg, e, data);
        }
    }

    static void logWarning(String msg) {
        EmbLogger.logWarning(msg, null, null);
    }

    static void logWarning(String msg, Exception e) {
        EmbLogger.logWarning(msg, e, null);
    }

    static void logWarning(String msg, Exception e, Map<String, Object> data) {
        if (EmbManager.logLevel.ordinal() <= EmbLogLevel.EmbLogLevelWarning.ordinal()) {
            Log.w((String)"[Embrace] ", (String)String.format(msg + " %s", e != null ? e : ""));
            EmbLogger.addDebugMessage(EmbDebugMessage.EmbDebugMessageType.WARNING, msg, e, data);
        }
    }

    static void logError(String msg) {
        EmbLogger.logError(msg, null, null);
    }

    static void logError(String msg, Exception e) {
        EmbLogger.logError(msg, e, null);
    }

    static void logError(String msg, Exception e, Map<String, Object> data) {
        if (EmbManager.logLevel.ordinal() <= EmbLogLevel.EmbLogLevelError.ordinal()) {
            Log.e((String)"[Embrace] ", (String)String.format(msg + " %s", e != null ? e : ""));
            EmbLogger.addDebugMessage(EmbDebugMessage.EmbDebugMessageType.ERROR, msg, e, data);
        }
    }

    private static void addDebugMessage(EmbDebugMessage.EmbDebugMessageType messageType, String msg, Exception exception, Map<String, Object> additionalInfo) {
        Stack<EmbException> embExceptions = EmbManager.getInstance().getCrashPayload(exception);
        EmbDebugMessage logMessage = new EmbDebugMessage(messageType, msg, embExceptions, additionalInfo);
    }
}

