/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.v4.content.FileProvider;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.helpers.EmbFileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class EmbFileUtils {
    private static final long MAX_FILE_SIZE_IN_BYTES = 0x300000L;
    private static final String EmbHostApplicationId = "hostAppId";
    private static final String EmbFileProvider = "io.embrace.android.embracesdk.fileprovider";
    private static final String EmbCachesDirectory = "caches";
    private static final String EmbConfigCacheFilePath = "config";
    private static final String EmbEventCacheFilePath = "events";
    private static final String EmbSessionCacheFilePath = "sessions";
    private static final String EmbNetworkTrafficCacheFilePath = "network";
    private static final String EmbCpuProfilingCacheFilePath = "cpu";
    private static final String EmbMemoryProfilingCacheFilePath = "memory";
    private static final String EmbActiveStoriesCacheFilePath = "stories";
    private static final String EmbFailedEventsCacheFilePath = "failed.events";
    private static final String EmbFailedSessionsCacheFilePath = "failed.sessions";
    private static final String EmbUnsentSessionsCacheFilePath = "unsent.sessions";
    private static final String EmbTerminationMessageCacheFilePath = "termination.message";
    private static final String EmbFailedSessionStartMessagesCacheFilePath = "failed.session_start_messages";
    private static final String EmbSessionInfoFileName = "sessions";
    private static final String EmbFailedScreenshotsCacheFilePath = "failed.screenshots";
    private static final String EmbFailedDebugMessagesCacheFilePath = "failed.debug.messages";

    private EmbFileUtils() {
    }

    static Uri getPathForCache(EmbFileCache fileCache) {
        File file = new File(Embrace.getContext().getFilesDir(), EmbCachesDirectory);
        String authority = "io.embrace.android.embracesdk.fileprovider:" + EmbFileUtils.getApplicationId();
        file.mkdir();
        switch (fileCache) {
            case EmbFileCacheConfig: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbConfigCacheFilePath));
            }
            case EmbFileCacheEvents: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbEventCacheFilePath));
            }
            case EmbFileCacheSessions: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, "sessions"));
            }
            case EmbFileCacheRequests: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbNetworkTrafficCacheFilePath));
            }
            case EmbFileCacheCPUSpikes: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbCpuProfilingCacheFilePath));
            }
            case EmbFileCacheMemory: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbMemoryProfilingCacheFilePath));
            }
            case EmbFileCacheActiveStories: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbActiveStoriesCacheFilePath));
            }
            case EmbFileCacheFailedEvents: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbFailedEventsCacheFilePath));
            }
            case EmbFileCacheFailedSessions: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbFailedSessionsCacheFilePath));
            }
            case EmbFileCacheUnsentSessions: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbUnsentSessionsCacheFilePath));
            }
            case EmbFileCacheTerminationMessage: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbTerminationMessageCacheFilePath));
            }
            case EmbFileCacheFailedSessionStartMessages: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbFailedSessionStartMessagesCacheFilePath));
            }
            case EmbFileCacheFailedScreenshots: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbFailedScreenshotsCacheFilePath));
            }
            case EmbFileCacheFailedDebugMessages: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbFailedDebugMessagesCacheFilePath));
            }
        }
        return null;
    }

    static Map<String, Object> readSessionInfoFile() throws EmbraceSdkException {
        Map sessionContents = null;
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.pathForSessionInfoFile().getLastPathSegment());
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(inputStream);
            sessionContents = (Map)objectInputStream.readObject();
        }
        catch (IOException e) {
            EmbLogger.logDebug("no file at session info path");
        }
        catch (ClassNotFoundException e) {
            EmbLogger.logDebug("session info file incorrect format");
            throw new EmbraceSdkException("session info file incorrect format", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
        }
        return sessionContents;
    }

    static void updateSessionInfoFileContents(Map<String, Object> sessionInfoContents) throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.pathForSessionInfoFile().getLastPathSegment());
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(sessionInfoContents);
        }
        catch (FileNotFoundException e) {
            EmbLogger.logError("no file found for session info", e);
            throw new EmbraceSdkException("no file found for session info", e);
        }
        catch (IOException e) {
            EmbLogger.logError("error opening input stream", e);
            throw new EmbraceSdkException("error opening input stream", e);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
        EmbLogger.logDebug(String.format("session info file updated with contents %s", sessionInfoContents));
    }

    static <T extends Serializable> void saveMapToFile(Map<String, T> objectMap, EmbFileCache fileCache) throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(objectMap);
        }
        catch (FileNotFoundException e) {
            EmbLogger.logError("no file found for " + fileCache.name(), e);
            throw new EmbraceSdkException("no file found for " + fileCache.name(), e);
        }
        catch (IOException e) {
            EmbLogger.logError("error opening input stream", e);
            e.printStackTrace();
            throw new EmbraceSdkException("error opening input stream", e);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
        EmbLogger.logDebug(String.format("file updated with contents %s", objectMap.toString()));
    }

    static <T extends Serializable> Map<String, T> readMapFromFile(EmbFileCache fileCache) throws EmbraceSdkException {
        HashMap map = new HashMap();
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(inputStream);
            map.putAll((Map)objectInputStream.readObject());
        }
        catch (IOException e) {
            EmbLogger.logDebug("no file at path " + fileCache.name());
        }
        catch (ClassNotFoundException e) {
            EmbLogger.logDebug("file incorrect format");
            throw new EmbraceSdkException("file incorrect format", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
        }
        return map;
    }

    static <T extends Serializable> void saveCollectionToFile(Collection<T> collection, EmbFileCache fileCache) throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(collection);
        }
        catch (FileNotFoundException e) {
            EmbLogger.logError("no file found for " + fileCache.name(), e);
            throw new EmbraceSdkException("no file found for " + fileCache.name(), e);
        }
        catch (IOException e) {
            EmbLogger.logError("error opening input stream", e);
            throw new EmbraceSdkException("error opening input stream", e);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
    }

    static <T extends Serializable> Collection<T> readCollectionFromFile(EmbFileCache fileCache) throws EmbraceSdkException {
        ArrayList collection = new ArrayList();
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
        if (EmbFileUtils.deleteFileIfExceedsSize(file, 0x300000L)) {
            return collection;
        }
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(inputStream);
            collection.addAll((Collection)objectInputStream.readObject());
        }
        catch (IOException e) {
            EmbLogger.logDebug("no file at path " + fileCache.name());
        }
        catch (ClassNotFoundException e) {
            EmbLogger.logDebug("file incorrect format");
            throw new EmbraceSdkException("file incorrect format", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
        }
        return collection;
    }

    static String readStringFromFile(EmbFileCache fileCache) throws EmbraceSdkException {
        String string = null;
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
        if (EmbFileUtils.deleteFileIfExceedsSize(file, 0x300000L)) {
            return string;
        }
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(inputStream);
            string = (String)objectInputStream.readObject();
        }
        catch (IOException e) {
            EmbLogger.logDebug("no file at path " + fileCache.name());
        }
        catch (ClassNotFoundException e) {
            EmbLogger.logDebug("file incorrect format");
            throw new EmbraceSdkException("file incorrect format", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream", e);
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
        }
        return string;
    }

    static void removeFileAtPath(EmbFileCache fileCache) {
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    private static Uri pathForSessionInfoFile() {
        File file = new File(Embrace.getContext().getFilesDir(), EmbCachesDirectory);
        file.mkdir();
        return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)("io.embrace.android.embracesdk.fileprovider:" + EmbFileUtils.getApplicationId()), (File)new File(file, "sessions"));
    }

    private static String getApplicationId() {
        try {
            ApplicationInfo applicationInfo = Embrace.getContext().getPackageManager().getApplicationInfo(Embrace.getContext().getPackageName(), 128);
            return applicationInfo.metaData.get(EmbHostApplicationId).toString();
        }
        catch (PackageManager.NameNotFoundException exception) {
            EmbLogger.logError("Unable to get application id", (Exception)((Object)exception));
            return Embrace.getContext().getApplicationContext().getApplicationInfo().packageName;
        }
    }

    private static boolean deleteFileIfExceedsSize(File file, long threshold) {
        if (file != null && file.exists() && file.length() > threshold) {
            file.delete();
            return true;
        }
        return false;
    }
}

