/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbManager;
import io.embrace.android.embracesdk.EmbraceSdkException;

class EmbExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler originalHandler;

    static void enable() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new EmbExceptionHandler(currentHandler));
    }

    EmbExceptionHandler(Thread.UncaughtExceptionHandler originalHandler) {
        this.originalHandler = originalHandler;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (EmbManager.getInstance().shouldRecordEvents()) {
            try {
                EmbManager.getInstance().processAndSendCrash(e);
            }
            catch (EmbraceSdkException e1) {
                EmbLogger.logError("Error sending crash event", e1);
            }
        }
        if (this.originalHandler != null) {
            this.originalHandler.uncaughtException(t, e);
        } else {
            EmbLogger.logError(String.format("Exception in thread \"%s\" ", t.getName()));
        }
    }
}

