/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbException {
    private String exceptionName;
    private String exceptionMessage;
    private List<String> exceptionStackTrace = new ArrayList<String>();

    EmbException() {
    }

    EmbException(String jsonStr) {
        JSONObject json;
        try {
            json = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            EmbLogger.logWarning("Failed to initialize EmbException from JSON string.");
            json = new JSONObject();
        }
        this.exceptionName = json.optString("n");
        this.exceptionMessage = json.optString("m");
        JSONArray array = json.optJSONArray("tt");
        for (int i = 0; i < array.length(); ++i) {
            this.exceptionStackTrace.add(array.optString(i));
        }
    }

    void setExceptionName(String exceptionName) {
        this.exceptionName = exceptionName;
    }

    void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    void setExceptionStackTrace(List<String> exceptionStackTrace) {
        this.exceptionStackTrace = exceptionStackTrace;
    }

    JSONObject toJson() {
        JSONObject payload = new JSONObject();
        try {
            if (this.exceptionName != null) {
                payload.put("n", (Object)this.exceptionName);
            }
            if (this.exceptionMessage != null) {
                payload.put("m", (Object)this.exceptionMessage);
            }
            JSONArray stackTraceArray = new JSONArray();
            for (String stackTrace : this.exceptionStackTrace) {
                stackTraceArray.put((Object)stackTrace);
            }
            payload.put("tt", (Object)stackTraceArray);
        }
        catch (JSONException e) {
            payload = null;
        }
        return payload;
    }
}

