/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.AsyncTask;
import io.embrace.android.embracesdk.EmbDebugMessage;
import io.embrace.android.embracesdk.EmbDevice;
import io.embrace.android.embracesdk.EmbEndpoint;
import io.embrace.android.embracesdk.EmbEvent;
import io.embrace.android.embracesdk.EmbFileUtils;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbManager;
import io.embrace.android.embracesdk.EmbRequest;
import io.embrace.android.embracesdk.EmbScreenshot;
import io.embrace.android.embracesdk.EmbSession;
import io.embrace.android.embracesdk.EmbSystemUtils;
import io.embrace.android.embracesdk.EmbUser;
import io.embrace.android.embracesdk.EmbUserCompletionMessageCallback;
import io.embrace.android.embracesdk.EmbraceAsyncTask;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.helpers.EmbFileCache;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

class EmbServer {
    private static final String EmbBaseUrlFormat = "%s://%s.%s";
    private static final String EmbUrlFormat = "%s/v%s/%s";
    private static final String EmbApiVersion = "1";
    private static final String EmbConfigApiVersion = "2";
    private static final String EmbApiScheme = "https";
    private static final String EmbApiHost = "emb-api.com";
    private static final String EmbConfigUrlFormat = "%s?appId=%s&osVersion=%s&appVersion=%s&deviceId=%s";
    static final String EmbScreenshotUrlFormat = "%s/%s/%s/%s.jpg";
    static final String EmbScreenshotMomentsPath = "moments";
    static final String EmbScreenshotLogsPath = "logs";
    static final String EmbJsonContentType = "application/json";
    private static final String EmbStoryIdHeaderFormat = "%s:%s";
    static final String EmbAppIdHeader = "X-EM-AID";
    static final String EmbDeviceIdHeader = "X-EM-DID";
    static final String EmbStoryIdHeader = "X-EM-SID";
    static final String EmbLogIdHeader = "X-EM-LID";
    private static final String EmbDataApiSubdomain = "data";
    private static final String EmbConfigApiSubdomain = "config";
    private static final String EmbImagesApiSubdomain = "images";
    private static final String EmbEventsApiPath = "log/events";
    private static final String EmbUsersApiPath = "log/users";
    private static final String EmbSessionsApiPath = "log/sessions";
    private static final String EmbLogsApiPath = "log/logging";
    private static final String EmbConfigApiPath = "config";
    private static final String EmbImagesApiPath = "screenshot";
    private static final String EmbDebugMessagesApiPath = "debugMessages";
    private static final EmbServer singleton = new EmbServer();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final List<HashMap<String, String>> failedSessionsStarts = new ArrayList<HashMap<String, String>>();
    private final List<EmbSession> failedSessions = new ArrayList<EmbSession>();
    private final List<EmbEvent> failedEvents = new ArrayList<EmbEvent>();
    private final List<EmbScreenshot> failedScreenshots = new ArrayList<EmbScreenshot>();
    private final List<EmbDebugMessage> failedDebugMessages = new ArrayList<EmbDebugMessage>();
    private boolean attemptingRetries = false;
    private final Runnable retryFailedRequestsRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                EmbServer.this.retryFailedRequests();
            }
            catch (EmbraceSdkException e) {
                EmbLogger.logDebug("Error while retrying sending of failed requests", e);
            }
        }
    };

    private EmbServer() {
        this.restoreCachedFailures();
    }

    static EmbServer getInstance() {
        return singleton;
    }

    static Executor getExecutor() {
        return AsyncTask.THREAD_POOL_EXECUTOR;
    }

    void fetchConfigurationCompletion(EmbraceApiCallback callback) throws EmbraceSdkException {
        EmbRequest request = this.remoteConfigRequest();
        if (request != null) {
            EmbraceAsyncTask asyncTask;
            try {
                asyncTask = new EmbraceAsyncTask(request.createRemoteConfigConnection(), request, callback);
            }
            catch (IOException e) {
                throw new EmbraceSdkException("couldn't fetch config", e);
            }
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        } else {
            EmbLogger.logError("Could not create request for remote config fetch");
        }
    }

    void sendUserMessageCompletion(final EmbUserCompletionMessageCallback callback) throws EmbraceSdkException {
        EmbLogger.logDebug("sending user information");
        String urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointUsers);
        if (urlString == null) {
            EmbLogger.logError("null url for request to user endpoint, aborting");
            return;
        }
        Map<String, Object> userInfo = EmbUser.getInstance().mapRepresentation();
        EmbLogger.logDebug(String.format("user message payload: %s", userInfo.toString()));
        JSONObject payload = EmbUser.getInstance().toJsonObject();
        if (payload == null) {
            EmbLogger.logError("error encoding json for user message:");
            return;
        }
        try {
            EmbRequest request = new EmbRequest(new URL(urlString), null, payload.toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) {
                    EmbSystemUtils.getInstance().setUserMessageNeedsRetry(false);
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(String error) {
                    EmbSystemUtils.getInstance().setUserMessageNeedsRetry(true);
                    if (callback != null) {
                        callback.onError();
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendStartOfSession(final HashMap payload, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointSessions);
        if (urlString == null) {
            EmbLogger.logError("null url for request to session endpoint, aborting");
            return;
        }
        if (payload == null) {
            EmbLogger.logError("error encoding json for session message");
            return;
        }
        try {
            EmbRequest request = new EmbRequest(new URL(urlString), null, new JSONObject((Map)payload).toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbServer.this.attemptingRetries) {
                        EmbServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbServer.this.addFailedSessionStart(payload);
                    if (callback != null) {
                        callback.onError(error);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendSession(final EmbSession session, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointSessions);
        if (urlString == null) {
            EmbLogger.logError("null url for request to session endpoint, aborting");
            return;
        }
        if (session == null || session.serverPayload() == null) {
            EmbLogger.logError("error encoding json for session message");
            return;
        }
        try {
            EmbRequest request = new EmbRequest(new URL(urlString), null, session.serverPayload().toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbServer.this.attemptingRetries) {
                        EmbServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbServer.this.addFailedSession(session);
                    if (callback != null) {
                        callback.onError(error);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendEvent(final EmbEvent event, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString;
        switch (event.getType()) {
            case EmbEventTypeInfoLog: 
            case EmbEventTypeErrorLog: {
                urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointLogs);
                break;
            }
            default: {
                urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointEvents);
            }
        }
        if (urlString == null) {
            EmbLogger.logError("null url for request to session endpoint, aborting");
            return;
        }
        if (event.serverPayload() == null) {
            EmbLogger.logError("error encoding json for event message");
            return;
        }
        String storyIdentifier = String.format(EmbStoryIdHeaderFormat, event.getTypeAbbreviation(), event.getStoryId());
        try {
            EmbRequest request = new EmbRequest(new URL(urlString), this.getHeadersForEventsRequest(storyIdentifier, event.getType()), event.serverPayload().toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (event.getType() == EmbEvent.EmbEventType.EmbEventTypeEnd && !EmbServer.this.attemptingRetries) {
                        EmbServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbServer.this.addFailedEvent(event);
                    if (callback != null) {
                        callback.onError(error);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendDebugMessage(final EmbDebugMessage embDebugMessage, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointDebugMessages);
        if (urlString == null) {
            EmbLogger.logError("null url for request to debug messages endpoint, aborting");
            return;
        }
        if (embDebugMessage == null || embDebugMessage.getServerPayload() == null) {
            EmbLogger.logError("error encoding json for debug message");
            return;
        }
        try {
            EmbRequest request = new EmbRequest(new URL(urlString), null, embDebugMessage.getServerPayload().toString().getBytes());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbServer.this.attemptingRetries) {
                        EmbServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbServer.this.addFailedDebugMessages(embDebugMessage);
                    if (callback != null) {
                        callback.onError(error);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    private String urlStringForRequestToEndpoint(EmbEndpoint endpoint) {
        switch (endpoint) {
            case EmbEndpointConfig: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, "config", EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbConfigApiVersion, "config");
            }
            case EmbEndpointEvents: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbEventsApiPath);
            }
            case EmbEndpointUsers: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbUsersApiPath);
            }
            case EmbEndpointSessions: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbSessionsApiPath);
            }
            case EmbEndpointImages: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbImagesApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbImagesApiPath);
            }
            case EmbEndpointLogs: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbLogsApiPath);
            }
            case EmbEndpointDebugMessages: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbDebugMessagesApiPath);
            }
        }
        return null;
    }

    private EmbRequest remoteConfigRequest() throws EmbraceSdkException {
        String baseConfigUrl = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointConfig);
        if (baseConfigUrl == null) {
            EmbLogger.logError("null url for config endpoint, aborting");
            return null;
        }
        String configUrlString = String.format(EmbConfigUrlFormat, baseConfigUrl, EmbManager.getInstance().getApiKey(), EmbDevice.getInstance().getOperatingSystemVersionForRequest(), EmbDevice.getInstance().getVersionCodeForRequest(), EmbSystemUtils.getInstance().getDeviceId());
        URL configUrl = null;
        try {
            configUrl = new URL(configUrlString);
        }
        catch (MalformedURLException e) {
            throw new EmbraceSdkException("wrong configUrlString: " + configUrlString, e);
        }
        return new EmbRequest(configUrl);
    }

    void sendScreenshot(final EmbScreenshot screenshot, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String fullUrlString;
        String baseUrlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointImages);
        if (baseUrlString == null) {
            EmbLogger.logError("null url for request to images endpoint, aborting");
            return;
        }
        if (screenshot.getStoryId() != null) {
            fullUrlString = String.format(EmbScreenshotUrlFormat, baseUrlString, EmbManager.getInstance().getApiKey(), EmbScreenshotMomentsPath, screenshot.getStoryId());
        } else if (screenshot.getLogId() != null) {
            fullUrlString = String.format(EmbScreenshotUrlFormat, baseUrlString, EmbManager.getInstance().getApiKey(), EmbScreenshotLogsPath, screenshot.getLogId());
        } else {
            EmbLogger.logError("null story id and log id for request to images endpoint, aborting");
            return;
        }
        if (screenshot.getData() == null) {
            EmbLogger.logError("null image data request to images endpoint, aborting");
            return;
        }
        try {
            EmbRequest request = new EmbRequest(new URL(fullUrlString), this.getHeadersForScreenshotRequest(screenshot), screenshot.getData());
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbServer.this.attemptingRetries) {
                        EmbServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbServer.this.addFailedScreenshots(screenshot);
                    if (callback != null) {
                        callback.onError(error);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request", e);
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    private synchronized void addFailedEvent(EmbEvent event) {
        this.failedEvents.add(event);
        this.cacheFailedEvents();
    }

    private synchronized void addFailedSession(EmbSession session) {
        this.failedSessions.add(session);
        this.cacheFailedSessions();
    }

    private synchronized void addFailedSessionStart(HashMap payload) {
        this.failedSessionsStarts.add(payload);
        this.cacheFailedSessionsStarts();
    }

    synchronized void addFailedSessions(Collection<EmbSession> sessions) {
        if (sessions == null || sessions.size() == 0) {
            EmbLogger.logWarning("no additional failed sessions to add");
            return;
        }
        this.failedSessions.addAll(sessions);
        this.cacheFailedSessions();
    }

    private synchronized void addFailedScreenshots(EmbScreenshot screenshot) {
        this.failedScreenshots.add(screenshot);
        this.cacheFailedScreenshots();
    }

    private synchronized void addFailedDebugMessages(EmbDebugMessage embDebugMessage) {
        this.failedDebugMessages.add(embDebugMessage);
        this.cacheFailedDebugMessages();
    }

    private void restoreCachedFailures() {
        try {
            this.failedEvents.addAll(this.getCacheFailedEvents());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("No failed events found in cache", e);
        }
        try {
            this.failedSessions.addAll(this.getCacheFailedSessions());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("No failed sessions found in cache", e);
        }
        try {
            this.failedSessionsStarts.addAll(this.getCacheFailedSessionsStarts());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("No failed session starts found in cache", e);
        }
        try {
            this.failedScreenshots.addAll(this.getCacheFailedScreenshots());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("No failed screenshots found in cache", e);
        }
        try {
            this.failedDebugMessages.addAll(this.getCacheFailedDebugMessages());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("No failed debug messages found in cache", e);
        }
    }

    private void cacheFailedSessionsStarts() {
        try {
            EmbFileUtils.saveCollectionToFile(this.failedSessionsStarts, EmbFileCache.EmbFileCacheFailedSessionStartMessages);
            EmbLogger.logDebug(String.format("wrote %s failed session starts to cache", this.failedSessionsStarts.size()));
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving failed session starts", e);
        }
    }

    private void cacheFailedSessions() {
        try {
            ArrayList<String> failedSessions = new ArrayList<String>();
            for (EmbSession session : this.failedSessions) {
                failedSessions.add(session.toJson());
            }
            EmbFileUtils.saveCollectionToFile(failedSessions, EmbFileCache.EmbFileCacheFailedSessions);
            EmbLogger.logDebug(String.format("wrote %s failed sessions to cache", failedSessions.size()));
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving failed sessions", e);
        }
    }

    private void cacheFailedEvents() {
        try {
            ArrayList<String> failedEvents = new ArrayList<String>();
            for (EmbEvent event : this.failedEvents) {
                failedEvents.add(event.serverPayload().toString());
            }
            EmbFileUtils.saveCollectionToFile(failedEvents, EmbFileCache.EmbFileCacheFailedEvents);
            EmbLogger.logDebug(String.format("wrote %s failed events to cache", this.failedEvents.size()));
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving failed events", e);
        }
    }

    private void cacheFailedScreenshots() {
        try {
            EmbFileUtils.saveCollectionToFile(this.failedScreenshots, EmbFileCache.EmbFileCacheFailedScreenshots);
            EmbLogger.logDebug(String.format("wrote %s failed screenshots to cache", this.failedScreenshots.size()));
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving failed screenshots", e);
        }
    }

    private void cacheFailedDebugMessages() {
        try {
            ArrayList<String> failedDebugMessages = new ArrayList<String>();
            for (EmbDebugMessage embDebugMessage : this.failedDebugMessages) {
                failedDebugMessages.add(embDebugMessage.getServerPayload().toString());
            }
            EmbFileUtils.saveCollectionToFile(failedDebugMessages, EmbFileCache.EmbFileCacheFailedDebugMessages);
            EmbLogger.logDebug(String.format("wrote %s failed debug messages to cache", this.failedDebugMessages.size()));
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving failed debug messages", e);
        }
    }

    private Collection<HashMap<String, String>> getCacheFailedSessionsStarts() throws EmbraceSdkException {
        return EmbFileUtils.readCollectionFromFile(EmbFileCache.EmbFileCacheFailedSessionStartMessages);
    }

    private Collection<EmbSession> getCacheFailedSessions() throws EmbraceSdkException {
        ArrayList<EmbSession> failedSessions = new ArrayList<EmbSession>();
        for (String session : EmbFileUtils.readCollectionFromFile(EmbFileCache.EmbFileCacheFailedSessions)) {
            failedSessions.add(new EmbSession(session));
        }
        return failedSessions;
    }

    private Collection<EmbEvent> getCacheFailedEvents() throws EmbraceSdkException {
        ArrayList<EmbEvent> failedEvents = new ArrayList<EmbEvent>();
        for (String event : EmbFileUtils.readCollectionFromFile(EmbFileCache.EmbFileCacheFailedEvents)) {
            failedEvents.add(new EmbEvent(event));
        }
        return failedEvents;
    }

    private Collection<EmbScreenshot> getCacheFailedScreenshots() throws EmbraceSdkException {
        ArrayList<EmbScreenshot> failedScreenshots = new ArrayList<EmbScreenshot>();
        for (EmbScreenshot screenshot : EmbFileUtils.readCollectionFromFile(EmbFileCache.EmbFileCacheFailedScreenshots)) {
            failedScreenshots.add(screenshot);
        }
        return failedScreenshots;
    }

    private Collection<EmbDebugMessage> getCacheFailedDebugMessages() throws EmbraceSdkException {
        ArrayList<EmbDebugMessage> failedDebugMessages = new ArrayList<EmbDebugMessage>();
        for (String debugMessage : EmbFileUtils.readCollectionFromFile(EmbFileCache.EmbFileCacheFailedDebugMessages)) {
            failedDebugMessages.add(new EmbDebugMessage(debugMessage));
        }
        return failedDebugMessages;
    }

    private synchronized EmbEvent popFailedEvent() {
        if (this.failedEvents.size() < 1) {
            return null;
        }
        return this.failedEvents.remove(0);
    }

    private synchronized EmbSession popFailedSession() {
        if (this.failedSessions.size() < 1) {
            return null;
        }
        return this.failedSessions.remove(0);
    }

    private synchronized HashMap popFailedSessionStart() {
        if (this.failedSessionsStarts.size() < 1) {
            return null;
        }
        return this.failedSessionsStarts.remove(0);
    }

    private synchronized EmbScreenshot popFailedScreenshot() {
        if (this.failedScreenshots.size() < 1) {
            return null;
        }
        return this.failedScreenshots.remove(0);
    }

    private synchronized EmbDebugMessage popFailedDebugMessage() {
        if (this.failedDebugMessages.size() < 1) {
            return null;
        }
        return this.failedDebugMessages.remove(0);
    }

    private synchronized void retryFailedRequests() throws EmbraceSdkException {
        this.attemptingRetries = true;
        final EmbEvent retryEvent = this.popFailedEvent();
        if (retryEvent != null) {
            EmbLogger.logDebug(String.format("going to retry previously failed event %s", retryEvent));
            this.sendEvent(retryEvent, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbLogger.logDebug("event retry succeeded, will keep retrying failed messages");
                    EmbServer.this.cacheFailedEvents();
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbLogger.logDebug("event retry failed, stopping retries for now");
                    EmbServer.this.addFailedEvent(retryEvent);
                    EmbServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final HashMap retrySessionStart = this.popFailedSessionStart();
        if (retrySessionStart != null) {
            EmbLogger.logDebug(String.format("going to retry previously failed session start %s", retrySessionStart));
            this.sendStartOfSession(retrySessionStart, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbLogger.logDebug("event retry succeeded, will keep retrying failed messages");
                    EmbServer.this.cacheFailedSessionsStarts();
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbLogger.logDebug("session start retry failed, stopping retries for now");
                    EmbServer.this.addFailedSessionStart(retrySessionStart);
                    EmbServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final EmbSession retrySession = this.popFailedSession();
        if (retrySession != null) {
            EmbLogger.logDebug(String.format("going to retry previously failed session %s", retrySession));
            this.sendSession(retrySession, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbLogger.logDebug("session retry succeeded, will keep retrying failed messages");
                    EmbServer.this.cacheFailedSessions();
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbLogger.logDebug("session retry failed, stopping retries for now");
                    EmbServer.this.addFailedSession(retrySession);
                    EmbServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final EmbScreenshot retryScreenshot = this.popFailedScreenshot();
        if (retryScreenshot != null) {
            EmbLogger.logDebug(String.format("going to retry previously failed screenshot %s", retryScreenshot));
            this.sendScreenshot(retryScreenshot, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbLogger.logDebug("screenshot retry succeeded, will keep retrying failed messages");
                    EmbServer.this.cacheFailedScreenshots();
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbLogger.logDebug("screenshot retry failed, stopping retries for now");
                    EmbServer.this.addFailedScreenshots(retryScreenshot);
                    EmbServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final EmbDebugMessage retryEmbDebugMessage = this.popFailedDebugMessage();
        if (retryEmbDebugMessage != null) {
            EmbLogger.logDebug(String.format("going to retry previously failed debug message %s", retryEmbDebugMessage));
            this.sendDebugMessage(retryEmbDebugMessage, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbLogger.logDebug("debug message retry succeeded, will keep retrying failed messages");
                    EmbServer.this.cacheFailedDebugMessages();
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbLogger.logDebug("debug message retry failed, stopping retries for now");
                    EmbServer.this.addFailedDebugMessages(retryEmbDebugMessage);
                    EmbServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        if (EmbSystemUtils.getInstance().userMessageNeedsRetry()) {
            EmbLogger.logDebug("going to retry previously failed user update");
            EmbSystemUtils.getInstance().setUserMessageNeedsRetry(false);
            this.sendUserMessageCompletion(new EmbUserCompletionMessageCallback(){

                @Override
                public void onSuccess() {
                    EmbLogger.logDebug("user retry succeeded, will keep retrying failed messages");
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError() {
                    EmbLogger.logDebug("user message retry failed, stopping retries for now");
                    EmbSystemUtils.getInstance().setUserMessageNeedsRetry(true);
                    EmbServer.this.attemptingRetries = false;
                }
            });
        } else {
            EmbLogger.logDebug("no retries left");
            this.attemptingRetries = false;
        }
    }

    private void scheduleSendingOfFailedRequests() {
        this.executorService.schedule(this.retryFailedRequestsRunnable, 500L, TimeUnit.MILLISECONDS);
    }

    void handleNetworkReachable() {
        if (!this.attemptingRetries) {
            try {
                this.retryFailedRequests();
            }
            catch (EmbraceSdkException e) {
                EmbLogger.logDebug("Error while retrying sending of failed requests", e);
            }
        }
    }

    private Map<String, String> getHeadersForEventsRequest(String storyIdentifier, EmbEvent.EmbEventType eventType) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (eventType == EmbEvent.EmbEventType.EmbEventTypeInfoLog || eventType == EmbEvent.EmbEventType.EmbEventTypeErrorLog) {
            map.put("log_id_header", storyIdentifier);
        } else {
            map.put("story_id_header", storyIdentifier);
        }
        return map;
    }

    private Map<String, String> getHeadersForScreenshotRequest(EmbScreenshot screenshot) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (screenshot.getLogId() != null) {
            map.put("log_id_header", screenshot.getLogId());
        } else if (screenshot.getStoryId() != null) {
            map.put("story_id_header", screenshot.getStoryId());
        }
        map.put("internal_content_type", "application/octet-stream");
        return map;
    }
}

