/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Process;
import io.embrace.android.embracesdk.EmbFilterable;
import io.embrace.android.embracesdk.EmbInterval;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbSession;
import io.embrace.android.embracesdk.FilterableUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class EmbProcessManager {
    private static final EmbProcessManager manager = new EmbProcessManager();
    private static final int SAMPLE_INTERVAL_IN_MILLISECONDS = 100;
    private static final long SHUTDOWN_TIMEOUT_MS = 2000L;
    private boolean isManagerEnabled = false;
    private boolean inHighCpuPeriod = false;
    private EmbInterval currentInterval = null;
    private long totalUpTimeBefore;
    private long totalProcessCpuTimeBefore;
    private final List<Float> samples = new ArrayList<Float>();
    private final List<EmbFilterable> criticalIntervals = new ArrayList<EmbFilterable>();
    private BufferedReader procStatsBufferedReader;
    private BufferedReader procStatsPidBufferedReader;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private Future cpuInfoFuture;
    private Runnable cpuInfoRunnable = new Runnable(){

        @Override
        public void run() {
            EmbProcessManager.this.recordSample();
        }
    };

    static EmbProcessManager getManager() {
        return manager;
    }

    private EmbProcessManager() {
    }

    private void startObservingCpuInfo() {
        this.cpuInfoFuture = this.executorService.scheduleAtFixedRate(this.cpuInfoRunnable, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private Float readCpuUsage() {
        this.closeBufferedReaderStreams();
        this.openBufferedReaderStreams();
        long totalUpTime = this.getTotalUpTime();
        long totalProcessCpuTime = this.getTotalProcessCpuTime();
        Float result = null;
        if (totalUpTime > -1L && totalProcessCpuTime > -1L) {
            if (this.totalUpTimeBefore != 0L) {
                long upTimeDiff = totalUpTime - this.totalUpTimeBefore;
                long processCpuTimeDiff = totalProcessCpuTime - this.totalProcessCpuTimeBefore;
                result = upTimeDiff > 0L ? Float.valueOf(this.restrictPercentage((float)processCpuTimeDiff / (float)upTimeDiff)) : null;
            }
            this.totalUpTimeBefore = totalUpTime;
            this.totalProcessCpuTimeBefore = totalProcessCpuTime;
        }
        return result;
    }

    private long getTotalUpTime() {
        if (this.procStatsBufferedReader != null) {
            try {
                String[] stats = this.procStatsBufferedReader.readLine().split("[ ]+", 9);
                long userTime = Long.parseLong(stats[1]);
                long niceTime = Long.parseLong(stats[2]);
                long systemTime = Long.parseLong(stats[3]);
                long idleTime = Long.parseLong(stats[4]);
                long ioWaitTime = Long.parseLong(stats[5]);
                long irqTime = Long.parseLong(stats[6]);
                long softIrqTime = Long.parseLong(stats[7]);
                return userTime + niceTime + systemTime + idleTime + ioWaitTime + irqTime + softIrqTime;
            }
            catch (IOException e) {
                EmbLogger.logError("error reading file stream", e);
            }
        } else {
            EmbLogger.logError(String.format("File stream %s is not opened", "/proc/stat"));
        }
        return -1L;
    }

    private long getTotalProcessCpuTime() {
        if (this.procStatsPidBufferedReader != null) {
            try {
                String[] stats = this.procStatsPidBufferedReader.readLine().split("[ ]+", 18);
                long userTime = Long.parseLong(stats[13]);
                long systemTime = Long.parseLong(stats[14]);
                long userChildTime = Long.parseLong(stats[15]);
                long systemChildTime = Long.parseLong(stats[16]);
                return userTime + systemTime + userChildTime + systemChildTime;
            }
            catch (IOException e) {
                EmbLogger.logError("error reading file stream", e);
            }
        } else {
            EmbLogger.logError(String.format("File stream %s is not opened", "/proc/" + Process.myPid() + "/" + "stat"));
        }
        return -1L;
    }

    private void recordSample() {
        Float sample = this.readCpuUsage();
        if (sample != null) {
            boolean pegging;
            Float peggingThreshold = Float.valueOf(0.9f);
            boolean bl = pegging = sample.floatValue() >= peggingThreshold.floatValue();
            if (pegging && !this.inHighCpuPeriod) {
                this.startHighUtilizationPeriod();
            } else if (!pegging && this.inHighCpuPeriod) {
                this.endHighUtilizationPeriod();
            }
            this.samples.add(sample);
        }
    }

    List<EmbInterval> getCriticalIntervalsBetweenWithDuration(long startTime, long endTime) {
        return this.getCriticalIntervalsBetweenWithDuration(startTime, endTime, 50L);
    }

    private List<EmbInterval> getCriticalIntervalsBetweenWithDuration(long startTime, long endTime, long duration) {
        List<? extends EmbFilterable> filteredList = FilterableUtils.filter(this.criticalIntervals, startTime, endTime);
        Iterator<? extends EmbFilterable> intervalIterator = filteredList.iterator();
        while (intervalIterator.hasNext()) {
            EmbInterval interval = (EmbInterval)intervalIterator.next();
            if (interval.getDuration() >= duration) continue;
            intervalIterator.remove();
        }
        return filteredList;
    }

    List<EmbInterval> getCriticalIntervalsDuringSession(EmbSession session) {
        return this.getCriticalIntervalsBetweenWithDuration(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L, 50L);
    }

    private void startHighUtilizationPeriod() {
        this.inHighCpuPeriod = true;
        EmbInterval highUsageInterval = new EmbInterval();
        this.criticalIntervals.add(highUsageInterval);
        this.currentInterval = highUsageInterval;
    }

    private void endHighUtilizationPeriod() {
        this.inHighCpuPeriod = false;
        if (this.currentInterval == null) {
            return;
        }
        this.currentInterval.endInterval();
        this.currentInterval = null;
    }

    private EmbProcessManagerStatus didManagerStatusChanged(boolean newIsManagerEnabled) {
        if (this.isManagerEnabled == newIsManagerEnabled) {
            return EmbProcessManagerStatus.NO_CHANGE;
        }
        if (!newIsManagerEnabled && this.isManagerEnabled) {
            return EmbProcessManagerStatus.PROCESS_MANAGER_DISABLED;
        }
        return EmbProcessManagerStatus.PROCESS_MANAGER_ENABLED;
    }

    synchronized void onManagerStatusChanged(boolean newIsManagerEnabled) {
        switch (this.didManagerStatusChanged(newIsManagerEnabled)) {
            case PROCESS_MANAGER_DISABLED: {
                this.executorService.shutdown();
                this.cpuInfoFuture.cancel(true);
                try {
                    if (!this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                        EmbLogger.logWarning("Executor service was not safely terminated.");
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    EmbLogger.logWarning("Error while shutting down executor", e);
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                this.samples.clear();
                this.criticalIntervals.clear();
                if (this.inHighCpuPeriod) {
                    this.endHighUtilizationPeriod();
                }
                this.closeBufferedReaderStreams();
                break;
            }
            case PROCESS_MANAGER_ENABLED: {
                if (this.executorService.isShutdown()) {
                    this.executorService = Executors.newSingleThreadScheduledExecutor();
                }
                this.openBufferedReaderStreams();
                this.startObservingCpuInfo();
                break;
            }
        }
        this.isManagerEnabled = newIsManagerEnabled;
    }

    private float restrictPercentage(float percentage) {
        if (percentage > 1.0f) {
            return 1.0f;
        }
        return percentage;
    }

    private synchronized void openBufferedReaderStreams() {
        try {
            this.procStatsBufferedReader = new BufferedReader(new FileReader("/proc/stat"));
        }
        catch (FileNotFoundException e) {
            EmbLogger.logError("error opening stream", e);
            this.procStatsBufferedReader = null;
        }
        try {
            this.procStatsPidBufferedReader = new BufferedReader(new FileReader("/proc/" + Process.myPid() + "/" + "stat"));
        }
        catch (FileNotFoundException e) {
            EmbLogger.logError("error opening stream", e);
            this.procStatsPidBufferedReader = null;
        }
    }

    private synchronized void closeBufferedReaderStreams() {
        if (this.procStatsBufferedReader != null) {
            try {
                this.procStatsBufferedReader.close();
            }
            catch (IOException e) {
                EmbLogger.logError("error closing stream", e);
            }
            finally {
                this.procStatsBufferedReader = null;
            }
        }
        if (this.procStatsPidBufferedReader != null) {
            try {
                this.procStatsPidBufferedReader.close();
            }
            catch (IOException e) {
                EmbLogger.logError("error closing stream", e);
            }
            finally {
                this.procStatsPidBufferedReader = null;
            }
        }
    }

    private static enum EmbProcessManagerStatus {
        NO_CHANGE,
        PROCESS_MANAGER_ENABLED,
        PROCESS_MANAGER_DISABLED;

    }
}

