/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.embrace.android.embracesdk.EmbFilterable;
import io.embrace.android.embracesdk.EmbInterval;
import io.embrace.android.embracesdk.EmbNetworkChangeBroadcastReceiver;
import io.embrace.android.embracesdk.EmbNetworkPerformance;
import io.embrace.android.embracesdk.EmbServer;
import io.embrace.android.embracesdk.EmbSession;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.FilterableUtils;
import java.util.ArrayList;
import java.util.List;

class EmbNetworkManager {
    private static final EmbNetworkManager manager = new EmbNetworkManager();
    private EmbNetworkStatus embNetworkStatus;
    private boolean isManagerEnabled = false;
    private List<EmbFilterable> reachabilityIntervals = new ArrayList<EmbFilterable>();
    private List<EmbFilterable> networkPerformances = new ArrayList<EmbFilterable>();
    private BroadcastReceiver broadcastReceiver;

    static EmbNetworkManager getManager() {
        return manager;
    }

    private EmbNetworkManager() {
    }

    void logNetworkCall(String url, String httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        this.networkPerformances.add(new EmbNetworkPerformance(url, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived));
    }

    private void updateConnectivityWithStatus(EmbNetworkStatus embNetworkStatus) {
        EmbInterval interval;
        if (this.embNetworkStatus == embNetworkStatus) {
            return;
        }
        this.embNetworkStatus = embNetworkStatus;
        if (!this.reachabilityIntervals.isEmpty()) {
            interval = (EmbInterval)this.reachabilityIntervals.get(this.reachabilityIntervals.size() - 1);
            interval.endInterval();
        }
        interval = new EmbInterval(this.getNameForNetworkStatus(embNetworkStatus));
        this.reachabilityIntervals.add(interval);
    }

    private void handleReachabilityChange(String reachability) {
        this.updateConnectivityWithStatus(this.getNetworkStatusForName(reachability));
    }

    List<EmbInterval> getReachabilityIntervalsBetween(long startTime, long endTime) {
        return FilterableUtils.filter(this.reachabilityIntervals, startTime, endTime);
    }

    List<EmbInterval> getReachabilityIntervalsDuringSession(EmbSession session) {
        return this.getReachabilityIntervalsBetween(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    List<EmbNetworkPerformance> getRequestsBetween(long startTime, long endTime) {
        return FilterableUtils.filter(this.networkPerformances, startTime, endTime);
    }

    List<EmbNetworkPerformance> getRequestsDuringSession(EmbSession session) {
        return this.getRequestsBetween(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    private String getNameForNetworkStatus(EmbNetworkStatus networkStatus) {
        switch (networkStatus) {
            case NOT_REACHABLE: {
                return "none";
            }
            case WIFI: {
                return "wifi";
            }
            case WAN: {
                return "wan";
            }
        }
        return "";
    }

    private EmbNetworkStatus getNetworkStatusForName(String name) {
        switch (name) {
            case "wifi": {
                return EmbNetworkStatus.WIFI;
            }
            case "wan": {
                return EmbNetworkStatus.WAN;
            }
        }
        return EmbNetworkStatus.NOT_REACHABLE;
    }

    private void registerReceiver() {
        if (this.broadcastReceiver == null) {
            this.broadcastReceiver = new EmbNetworkChangeBroadcastReceiver();
            IntentFilter iFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            Embrace.getContext().registerReceiver(this.broadcastReceiver, iFilter);
        }
    }

    private void unregisterReceiver() {
        if (this.broadcastReceiver != null) {
            Embrace.getContext().unregisterReceiver(this.broadcastReceiver);
            this.broadcastReceiver = null;
        }
    }

    synchronized void enable() {
        if (!this.isManagerEnabled) {
            this.isManagerEnabled = true;
            this.updateNetworkState((ConnectivityManager)Embrace.getContext().getSystemService("connectivity"));
            this.registerReceiver();
        }
    }

    synchronized void disable() {
        if (this.isManagerEnabled) {
            this.unregisterReceiver();
            this.networkPerformances.clear();
            this.reachabilityIntervals.clear();
            this.isManagerEnabled = false;
        }
    }

    synchronized void updateNetworkState(ConnectivityManager connectivityManager) {
        if (this.isManagerEnabled) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                EmbServer.getInstance().handleNetworkReachable();
                switch (networkInfo.getType()) {
                    case 1: {
                        this.handleReachabilityChange("wifi");
                        break;
                    }
                    case 0: {
                        this.handleReachabilityChange("wan");
                        break;
                    }
                }
            } else {
                this.handleReachabilityChange("none");
            }
        }
    }

    private static enum EmbNetworkStatus {
        NOT_REACHABLE,
        WIFI,
        WAN;

    }
}

