/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import io.embrace.android.embracesdk.EmbApplicationStateManager;
import io.embrace.android.embracesdk.EmbDevice;
import io.embrace.android.embracesdk.EmbEvent;
import io.embrace.android.embracesdk.EmbException;
import io.embrace.android.embracesdk.EmbExceptionHandler;
import io.embrace.android.embracesdk.EmbFileUtils;
import io.embrace.android.embracesdk.EmbInterval;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbMemoryManager;
import io.embrace.android.embracesdk.EmbMemorySample;
import io.embrace.android.embracesdk.EmbNetworkManager;
import io.embrace.android.embracesdk.EmbNetworkPerformance;
import io.embrace.android.embracesdk.EmbPowerManager;
import io.embrace.android.embracesdk.EmbProcessManager;
import io.embrace.android.embracesdk.EmbSdkConfig;
import io.embrace.android.embracesdk.EmbServer;
import io.embrace.android.embracesdk.EmbSessionManager;
import io.embrace.android.embracesdk.EmbSystemEvent;
import io.embrace.android.embracesdk.EmbSystemUtils;
import io.embrace.android.embracesdk.EmbUser;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.helpers.EmbFileCache;
import io.embrace.android.embracesdk.helpers.EmbLogLevel;
import io.embrace.android.embracesdk.helpers.EmbUuid;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import io.embrace.android.embracesdk.helpers.SharedPreferencesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbManager {
    private static final String TAG = "[Embrace]";
    private static final String EmbApiKeyMetaData = "io.embrace.android.embracesdk.api.key";
    private static final EmbManager singleton = new EmbManager();
    private String apiKey;
    private EmbDevice device;
    static EmbLogLevel logLevel;
    private boolean sdkInitialized;
    private boolean sdkDisabled;
    private boolean sdkInSafeMode;
    private boolean configFetched;
    private boolean screenshotsEnabled = true;
    private Map<String, EmbEvent> events;
    private Map<String, Serializable> activeStories;
    private Map<String, Future> eventLateTimers;
    private Map<String, Long> eventLateThresholds;
    private Set<String> disallowScreenshotStoryIds;
    private Set<Throwable> pendingThrowables;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private WeakReference<Activity> foregroundActivity;

    private EmbManager() {
        this.device = EmbDevice.getInstance();
        this.sdkDisabled = EmbSystemUtils.getInstance().sdkDisabledFromSavedConfig();
        this.sdkInSafeMode = EmbSystemUtils.getInstance().sdkStartupFailedLastSession();
        logLevel = EmbLogLevel.EmbLogLevelInfo;
        this.events = new HashMap<String, EmbEvent>();
        this.activeStories = new HashMap<String, Serializable>();
        this.disallowScreenshotStoryIds = new HashSet<String>();
        this.eventLateThresholds = new HashMap<String, Long>();
        this.eventLateTimers = new HashMap<String, Future>();
        this.pendingThrowables = new HashSet<Throwable>();
    }

    static EmbManager getInstance() {
        return singleton;
    }

    synchronized boolean setupApiKey() {
        this.apiKey = this.getApiKeyFromManifest();
        if (TextUtils.isEmpty((CharSequence)this.apiKey)) {
            return false;
        }
        Log.d((String)TAG, (String)String.format("Embrace SDK started successfully with key %s", this.apiKey));
        return true;
    }

    private String getApiKeyFromManifest() {
        try {
            ApplicationInfo ai = Embrace.getContext().getPackageManager().getApplicationInfo(Embrace.getContext().getPackageName(), 128);
            Object apiKeyMetadata = ai.metaData.get(EmbApiKeyMetaData);
            return apiKeyMetadata != null ? apiKeyMetadata.toString() : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            EmbLogger.logError("Unable to get api key", (Exception)((Object)e));
            return null;
        }
    }

    String getApiKey() {
        return this.apiKey;
    }

    void performStartup() throws EmbraceSdkException {
        boolean inBackground = EmbApplicationStateManager.getManager().isInBackground();
        EmbSystemUtils.getInstance().recordStartupBegun();
        this.restoreConfig();
        if (this.sdkDisabled || this.sdkInSafeMode) {
            EmbLogger.logWarning("sdk disabled or in safe mode");
            if (!inBackground) {
                this.fetchConfig();
            }
            return;
        }
        this.fetchConfig();
        EmbLogger.logInfo("sdk enabled, starting");
        EmbSessionManager.manager.performStartup(inBackground);
        EmbSessionManager.manager.recordColdStart();
        EmbSessionManager.manager.enable();
        EmbSystemUtils.getInstance().updateAppAndUserData();
        EmbSystemUtils.getInstance().recordStartupCompleted();
        EmbExceptionHandler.enable();
        this.sdkInitialized = true;
        EmbSessionManager.manager.scheduleAndSendSessionStart();
    }

    synchronized void logMessage(String message, EmbEvent.EmbEventType type, boolean takeScreenshot, Map properties, List<String> stackTraces) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logWarning(String.format("sdk is disabled, ignoring message %s", message));
            return;
        }
        EmbEvent logEvent = null;
        switch (type) {
            case EmbEventTypeInfoLog: {
                logEvent = new EmbEvent(EmbEvent.EmbEventType.EmbEventTypeInfoLog, message, properties);
                break;
            }
            case EmbEventTypeErrorLog: {
                logEvent = new EmbEvent(EmbEvent.EmbEventType.EmbEventTypeErrorLog, message, properties);
                break;
            }
            default: {
                EmbLogger.logWarning("received log message of unknown type, ignoring");
            }
        }
        if (logEvent == null) {
            return;
        }
        boolean screenshotTaken = false;
        if (takeScreenshot) {
            screenshotTaken = EmbSessionManager.manager.triggerEventSnapshot(logEvent.getStoryId(), EmbSessionManager.EmbScreenshotReason.LOG);
        }
        logEvent.setScreenshotTaken(screenshotTaken);
        logEvent.setSessionId(EmbSessionManager.manager.getCurrentSessionId());
        this.addStackTrace(stackTraces, logEvent);
        this.addMetadataPayloadsToEvent(logEvent, null);
        EmbServer.getInstance().sendEvent(logEvent, null);
        if (type == EmbEvent.EmbEventType.EmbEventTypeInfoLog) {
            EmbSessionManager.manager.recordInfoLog(logEvent.getStoryId());
        } else if (type == EmbEvent.EmbEventType.EmbEventTypeErrorLog) {
            EmbSessionManager.manager.recordErrorLog(logEvent.getStoryId());
        }
    }

    synchronized void setUserIdentifier(String identifier) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logWarning("sdk is disabled, ignoring user identifier update");
            return;
        }
        EmbUser.getInstance().updateInternalIdentifier(identifier);
    }

    synchronized void setUserEmailAddress(String emailAddress) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logWarning("sdk is disabled, ignoring user email address update");
            return;
        }
        EmbUser.getInstance().updateEmailAddress(emailAddress);
    }

    synchronized void setUserIsPayer(boolean payer) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logWarning("sdk is disabled, ignoring user payer update");
            return;
        }
        EmbUser.getInstance().updatePayingUser(payer);
    }

    synchronized void setUserPersona(String persona) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logWarning("sdk is disabled, ignoring user persona update");
            return;
        }
        EmbUser.getInstance().setPersona(persona);
    }

    synchronized void removeUserPersona(String persona) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logWarning("sdk is disabled, ignoring user persona update");
            return;
        }
        EmbUser.getInstance().removePersona(persona);
    }

    synchronized void setUsername(String username) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logWarning("sdk is disabled, ignoring username update");
            return;
        }
        if (username != null && username.length() > 64) {
            EmbLogger.logWarning(String.format(Locale.getDefault(), "username %s is longer than maximum allowed length of %d; it will be truncated", username, 64));
            String truncatedUsername = username.substring(64);
            EmbUser.getInstance().updateUsername(truncatedUsername);
        } else {
            EmbUser.getInstance().updateUsername(username);
        }
    }

    String getEmbraceVersionString() {
        return "1.1.1";
    }

    boolean isAppUpdated() {
        String currentVersion = this.device.getAppVersion();
        String cachedVersion = SharedPreferencesUtils.getStringPreference(Embrace.getContext(), EmbSystemUtils.EmbPreviousAppVersionKey);
        return cachedVersion != null && !currentVersion.equals(cachedVersion);
    }

    boolean osUpdated() {
        String osVersion = this.device.getOperatingSystemVersion();
        String cachedVersion = SharedPreferencesUtils.getStringPreference(Embrace.getContext(), EmbSystemUtils.EmbPreviousOsVersionKey);
        return cachedVersion != null && !osVersion.equals(cachedVersion);
    }

    boolean isFirstDay() {
        long installDate = SharedPreferencesUtils.getLongPreference(Embrace.getContext(), EmbSystemUtils.EmbInstallDateKey, -1L);
        if (installDate == -1L) {
            return false;
        }
        return Calendar.getInstance().getTimeInMillis() - installDate <= 1L;
    }

    boolean shouldRecordEvents() {
        return !this.sdkDisabled && !this.sdkInSafeMode && this.sdkInitialized;
    }

    private boolean shouldTakeScreenshotForStory(String storyId) {
        return !this.disallowScreenshotStoryIds.contains(storyId);
    }

    private synchronized void updateConfig(EmbSdkConfig sdkConfig, boolean fromServer) throws EmbraceSdkException {
        if (fromServer && !this.configFetched) {
            this.configFetched = true;
        }
        EmbSystemUtils.getInstance().setSdkDisabled(!sdkConfig.isEnabled());
        this.eventLateThresholds = sdkConfig.getEventLimits();
        this.screenshotsEnabled = sdkConfig.isScreenshotsEnabled();
        if (fromServer) {
            EmbUser.getInstance().updateServerPersonas(sdkConfig.getAppPersonas());
        }
        if ((this.sdkDisabled || this.sdkInSafeMode) && sdkConfig.isEnabled()) {
            this.reactivateSdk();
        } else if (!(this.sdkDisabled || this.sdkInSafeMode || sdkConfig.isEnabled())) {
            this.disableSdk();
        }
        if (fromServer) {
            this.cacheConfig(sdkConfig);
        }
    }

    private void fetchConfig() throws EmbraceSdkException {
        EmbServer.getInstance().fetchConfigurationCompletion(new EmbraceApiCallback(){

            @Override
            public void onSuccess(String response) throws EmbraceSdkException {
                EmbLogger.logDebug(String.format("fetched config %s", response));
                EmbSystemUtils.getInstance().recordStartupCompleted();
                try {
                    EmbManager.this.updateConfig(new EmbSdkConfig(new JSONObject(response)), true);
                }
                catch (JSONException e) {
                    String msg = "Failed to create the config object: %s";
                    EmbLogger.logError(msg, (Exception)((Object)e));
                    e.printStackTrace();
                    throw new EmbraceSdkException(msg, e);
                }
                catch (Exception e) {
                    String msg = "An exception was thrown while attempting to update the SDK config: %s";
                    EmbLogger.logError(msg, e);
                    e.printStackTrace();
                    throw new EmbraceSdkException(msg, e);
                }
            }

            @Override
            public void onError(String error) {
                EmbLogger.logError(String.format("error fetching config: %s", error));
            }
        });
    }

    private synchronized void restoreConfig() throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(EmbFileCache.EmbFileCacheConfig).getLastPathSegment());
        int length = (int)file.length();
        byte[] bytes = new byte[length];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            in.read(bytes);
            JSONObject configJson = new JSONObject(new String(bytes));
            if (configJson != null) {
                this.updateConfig(new EmbSdkConfig(configJson), false);
            }
        }
        catch (IOException e) {
            EmbLogger.logInfo("no cached config data found in cache");
        }
        catch (JSONException e) {
            EmbLogger.logError("error creating config object", (Exception)((Object)e));
            throw new EmbraceSdkException("error creating config object", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
    }

    private synchronized void cacheConfig(EmbSdkConfig config) throws EmbraceSdkException {
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(EmbFileCache.EmbFileCacheConfig).getLastPathSegment());
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(config.encodeObjectForSaving().getBytes("UTF-8"));
        }
        catch (FileNotFoundException e) {
            EmbLogger.logError("error openning file", e);
            throw new EmbraceSdkException("error openning file", e);
        }
        catch (IOException e) {
            EmbLogger.logError("error saving output stream", e);
            throw new EmbraceSdkException("error saving output stream", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing output stream", e);
                    throw new EmbraceSdkException("error closing output stream", e);
                }
            }
        }
    }

    void disableSdk() {
        EmbLogger.logWarning("disabling sdk");
        this.sdkDisabled = true;
        this.sdkInSafeMode = true;
        this.deactivateDataManagers();
    }

    void reactivateSdk() {
        EmbLogger.logInfo("reactivating sdk");
        this.sdkDisabled = false;
        this.sdkInSafeMode = false;
        this.sdkInitialized = true;
        EmbSessionManager.manager.sendSessionStartAfterReactivating();
        this.activateDataManagers();
    }

    void activateDataManagers() {
        boolean sdkDisabledFromSavedConfig = EmbSystemUtils.getInstance().sdkDisabledFromSavedConfig();
        if (!sdkDisabledFromSavedConfig) {
            EmbSessionManager.manager.enable();
            EmbPowerManager.getManager().onSdkStatusChanged(true);
            EmbMemoryManager.getManager().onManagerStatusChanged(true);
            EmbProcessManager.getManager().onManagerStatusChanged(true);
            EmbNetworkManager.getManager().enable();
        } else {
            EmbLogger.logWarning("Sdk disabled in config, won't reactivate.");
        }
    }

    void deactivateDataManagers() {
        EmbSessionManager.manager.disable(EmbSystemUtils.getInstance().sdkDisabledFromSavedConfig());
        EmbPowerManager.getManager().onSdkStatusChanged(false);
        EmbMemoryManager.getManager().onManagerStatusChanged(false);
        EmbProcessManager.getManager().onManagerStatusChanged(false);
        EmbNetworkManager.getManager().disable();
    }

    synchronized void startEvent(String name, String identifier, boolean takeScreenshot, Map properties) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logInfo(String.format("sdk is disabled, ignoring start event %s", name));
            return;
        }
        EmbProcessManager.getManager().onManagerStatusChanged(true);
        final String eventId = this.getInternalEventKey(name, identifier);
        EmbEvent startEvent = new EmbEvent(EmbEvent.EmbEventType.EmbEventTypeStart, eventId, properties);
        startEvent.setSessionId(EmbSessionManager.manager.getCurrentSessionId());
        this.events.put(eventId, startEvent);
        this.activeStories.put(startEvent.getStoryId(), (Serializable)((Object)eventId));
        if (!takeScreenshot) {
            this.disallowScreenshotStoryIds.add(startEvent.getStoryId());
        }
        this.updateUnfinishedStoriesLog();
        Long lateThresholdInMilliseconds = this.getLateThresholdForEventWithName(name);
        startEvent.setLateThreshold(lateThresholdInMilliseconds);
        ScheduledFuture<?> lateTimer = this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    EmbManager.this.sendLateEventForIdentifier(eventId);
                }
                catch (EmbraceSdkException e) {
                    EmbLogger.logError(String.format("Error sending late event with identifier %s with error", eventId), e);
                }
            }
        }, (long)lateThresholdInMilliseconds, TimeUnit.MILLISECONDS);
        this.addObjectWithKey(lateTimer, eventId, EmbManagerMapResource.EmbManagerMapResourceLateTimers);
        this.addMetadataPayloadsToEvent(startEvent, null);
        EmbServer.getInstance().sendEvent(startEvent, null);
        EmbSessionManager.manager.recordNewStory(startEvent.getStoryId());
    }

    synchronized void endEvent(String name, String identifier) throws EmbraceSdkException {
        if (!this.shouldRecordEvents()) {
            EmbLogger.logInfo(String.format("sdk is disabled, ignoring end event %s", name));
            return;
        }
        String eventId = this.getInternalEventKey(name, identifier);
        EmbEvent startEvent = this.events.get(eventId);
        if (startEvent == null) {
            EmbLogger.logError(String.format("no start event found for end event with name: %s identifier: %s", name, identifier));
            return;
        }
        EmbEvent endEvent = new EmbEvent(EmbEvent.EmbEventType.EmbEventTypeEnd, eventId, startEvent.getStoryId());
        endEvent.setSessionId(EmbSessionManager.manager.getCurrentSessionId());
        endEvent.updateWithStartTime(startEvent.getTimestamp());
        this.addMetadataPayloadsToEvent(endEvent, startEvent);
        EmbServer.getInstance().sendEvent(endEvent, null);
        this.events.remove(eventId);
        this.activeStories.remove(startEvent.getStoryId());
        this.disallowScreenshotStoryIds.remove(startEvent.getStoryId());
        this.updateUnfinishedStoriesLog();
        this.removeTimer(eventId);
        if (this.activeStories.size() == 0) {
            EmbProcessManager.getManager().onManagerStatusChanged(false);
        }
    }

    synchronized void logNetworkCall(String url, String httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        EmbNetworkManager.getManager().logNetworkCall(url, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived);
    }

    private synchronized void updateUnfinishedStoriesLog() throws EmbraceSdkException {
        EmbFileUtils.saveMapToFile(this.activeStories, EmbFileCache.EmbFileCacheActiveStories);
    }

    private void addMetadataPayloadsToEvent(EmbEvent event, EmbEvent startEvent) {
        switch (event.getType()) {
            case EmbEventTypeInfoLog: 
            case EmbEventTypeErrorLog: 
            case EmbEventTypeStart: {
                event.addPayload(EmbDevice.getInstance().getDeviceInfoJsonObject(), "d");
                event.addPayload(EmbDevice.getInstance().getTelephonyInfo(), "tl");
                event.addPayload(EmbDevice.getInstance().getAppInfoJsonObject(), "a");
                break;
            }
            case EmbEventTypeLate: 
            case EmbEventTypeEnd: 
            case EmbEventTypeInterrupt: {
                this.addPerformanceMetadataToEvent(event, startEvent);
                break;
            }
            case EmbEventTypeCrash: {
                event.addPayload(EmbDevice.getInstance().getDeviceInfoJsonObject(), "d");
                event.addPayload(EmbDevice.getInstance().getAppInfoJsonObject(), "a");
                break;
            }
        }
        event.addPayload(EmbUser.getInstance().toJsonObject(), "u");
    }

    private void addPerformanceMetadataToEvent(EmbEvent event, EmbEvent startEvent) {
        if (startEvent == null || startEvent.getTimestamp() == null) {
            EmbLogger.logError("can't calculate performance data without start event");
            return;
        }
        JSONObject performance = new JSONObject();
        try {
            performance.put("bt", (double)EmbPowerManager.getManager().getBatteryLevel());
            performance.put("ds", (Object)EmbDevice.getInstance().getSystemMemoryAsJson());
            JSONArray memorySamplesJsonArray = new JSONArray();
            for (EmbMemorySample memorySample : EmbMemoryManager.getManager().getMemorySamplesWithinInterval(startEvent.getTimestamp(), event.getTimestamp())) {
                memorySamplesJsonArray.put((Object)memorySample.toJson());
            }
            performance.put("me", (Object)memorySamplesJsonArray);
            List<EmbSystemEvent> lowMemoryWarnings = EmbMemoryManager.getManager().getMemoryWarningsWithinInterval(startEvent.getTimestamp(), event.getTimestamp());
            JSONArray lowMemoryPayload = new JSONArray();
            for (EmbSystemEvent embSystemEvent : lowMemoryWarnings) {
                lowMemoryPayload.put((Object)embSystemEvent.toJson());
            }
            performance.put("mw", (Object)lowMemoryPayload);
            JSONArray chargingIntervalsJsonArray = new JSONArray();
            for (EmbInterval embInterval : EmbPowerManager.getManager().getChargingIntervalsBetween(startEvent.getTimestamp(), event.getTimestamp())) {
                chargingIntervalsJsonArray.put((Object)embInterval.getServerPayload());
            }
            performance.put("bc", (Object)chargingIntervalsJsonArray);
            JSONArray jSONArray = new JSONArray();
            for (EmbInterval embInterval : EmbProcessManager.getManager().getCriticalIntervalsBetweenWithDuration(startEvent.getTimestamp(), event.getTimestamp())) {
                jSONArray.put((Object)embInterval.getServerPayload());
            }
            performance.put("cp", (Object)jSONArray);
            List<EmbInterval> list = EmbNetworkManager.getManager().getReachabilityIntervalsBetween(startEvent.getTimestamp(), event.getTimestamp());
            JSONArray netInterfacePayload = new JSONArray();
            for (EmbInterval interval : list) {
                netInterfacePayload.put((Object)interval.getServerPayload());
            }
            performance.put("ns", (Object)netInterfacePayload);
            List<EmbNetworkPerformance> networkPerformances = EmbNetworkManager.getManager().getRequestsBetween(startEvent.getTimestamp(), event.getTimestamp());
            JSONArray netRequestsPayload = new JSONArray();
            for (EmbNetworkPerformance embNetworkPerformance : networkPerformances) {
                netRequestsPayload.put((Object)embNetworkPerformance.toJson());
            }
            performance.put("nr", (Object)netRequestsPayload);
        }
        catch (JSONException e) {
            performance = null;
        }
        event.addPayload(performance, "p");
    }

    private void addStackTrace(List<String> stackTraces, EmbEvent event) {
        JSONObject jsonObject = new JSONObject();
        JSONArray stackTracesJsonArray = new JSONArray();
        for (String stackTrace : stackTraces) {
            stackTracesJsonArray.put((Object)stackTrace);
        }
        try {
            jsonObject.put("tt", (Object)stackTracesJsonArray);
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        event.addPayload(jsonObject, "sk");
    }

    private String getInternalEventKey(String eventName, String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return eventName;
        }
        return String.format("%s%s%s", eventName, "#", identifier);
    }

    private Long getLateThresholdForEventWithName(String eventName) {
        if (this.eventLateThresholds == null || eventName == null) {
            return 5000L;
        }
        Long threshold = this.eventLateThresholds.get(eventName);
        if (threshold != null) {
            return threshold;
        }
        Long defaultThreshold = this.eventLateThresholds.get("_default");
        if (defaultThreshold != null) {
            return defaultThreshold;
        }
        return 5000L;
    }

    private void sendLateEventForIdentifier(String identifier) throws EmbraceSdkException {
        if (identifier == null) {
            EmbLogger.logError("can't fire late message for event with null identifier");
            return;
        }
        if (!this.shouldRecordEvents()) {
            EmbLogger.logInfo(String.format("sdk is disabled, ignoring late event %s", identifier));
            this.removeTimer(identifier);
            return;
        }
        EmbEvent event = this.events.get(identifier);
        if (event == null) {
            EmbLogger.logError(String.format("can't fire late message for event %s: start event not found", identifier));
            return;
        }
        if (event.isLate()) {
            this.removeTimer(identifier);
            return;
        }
        EmbLogger.logInfo(String.format("event %s is late, sending late message", identifier));
        EmbEvent lateEvent = new EmbEvent(EmbEvent.EmbEventType.EmbEventTypeLate, identifier, event.getStoryId());
        lateEvent.setSessionId(EmbSessionManager.manager.getCurrentSessionId());
        lateEvent.updateWithStartTime(event.getTimestamp());
        this.addMetadataPayloadsToEvent(lateEvent, event);
        boolean screenshotTaken = false;
        if (this.shouldTakeScreenshotForStory(event.getStoryId())) {
            screenshotTaken = EmbSessionManager.manager.triggerEventSnapshot(lateEvent.getStoryId(), EmbSessionManager.EmbScreenshotReason.LATE);
            this.removeObjectWithKey(event.getStoryId(), EmbManagerMapResource.EmbManagerMapResourceScreenshots);
        }
        lateEvent.setScreenshotTaken(screenshotTaken);
        EmbServer.getInstance().sendEvent(lateEvent, null);
        event.setLate(true);
        this.removeTimer(identifier);
    }

    private synchronized void removeObjectWithKey(String key, EmbManagerMapResource resource) {
        if (key == null) {
            EmbLogger.logError("can't remove object with null key from shared dictinary");
            return;
        }
        switch (resource) {
            case EmbManagerMapResourceEvents: {
                this.events.remove(key);
                break;
            }
            case EmbManagerMapResourceActiveStories: {
                this.activeStories.remove(key);
                break;
            }
            case EmbManagerMapResourceLateTimers: {
                this.eventLateTimers.remove(key);
                break;
            }
            case EmbManagerMapResourceScreenshots: {
                this.disallowScreenshotStoryIds.remove(key);
                break;
            }
        }
    }

    private synchronized void addObjectWithKey(Object value, String key, EmbManagerMapResource resource) {
        if (key == null) {
            EmbLogger.logError("can't remove object with null key from shared dictinary");
            return;
        }
        switch (resource) {
            case EmbManagerMapResourceEvents: {
                this.events.put(key, (EmbEvent)value);
                break;
            }
            case EmbManagerMapResourceActiveStories: {
                this.activeStories.put(key, (Serializable)((Object)((String)value)));
                break;
            }
            case EmbManagerMapResourceLateTimers: {
                this.eventLateTimers.put(key, (Future)value);
                break;
            }
            case EmbManagerMapResourceScreenshots: {
                this.disallowScreenshotStoryIds.add((String)value);
                break;
            }
        }
    }

    private void removeTimer(String identifier) {
        Future lateTimer = this.eventLateTimers.get(identifier);
        if (lateTimer != null) {
            lateTimer.cancel(true);
            this.removeObjectWithKey(identifier, EmbManagerMapResource.EmbManagerMapResourceLateTimers);
        }
    }

    int getProblematicRequestLatency() {
        return 500;
    }

    synchronized void processAndSendCrash(Throwable throwable) throws EmbraceSdkException {
        if (!this.pendingThrowables.contains(throwable)) {
            this.pendingThrowables.add(throwable);
            EmbSessionManager.manager.saveSessionAfterCrash();
            this.sendCrashReportWithData(throwable);
        }
    }

    void sendCrashReportWithData(Throwable throwable) throws EmbraceSdkException {
        EmbEvent crashEvent = new EmbEvent(EmbEvent.EmbEventType.EmbEventTypeCrash, "_crash_report");
        crashEvent.setSessionId(EmbSessionManager.manager.getCurrentSessionId());
        crashEvent.setStoryId(TextUtils.join((CharSequence)",", this.activeStories.keySet()));
        JSONArray array = new JSONArray();
        Stack<EmbException> embExceptions = this.getCrashPayload(throwable);
        while (!embExceptions.empty()) {
            array.put((Object)embExceptions.pop().toJson());
        }
        JSONObject crashPayload = new JSONObject();
        try {
            crashPayload.put("id", (Object)EmbUuid.getEmbUuid(UUID.randomUUID().toString()));
            crashPayload.put("ex", (Object)array);
        }
        catch (JSONException e) {
            crashPayload = null;
        }
        if (crashPayload != null) {
            crashEvent.addPayload(crashPayload, "cr");
        }
        this.addMetadataPayloadsToEvent(crashEvent, null);
        EmbServer.getInstance().sendEvent(crashEvent, null);
    }

    Stack<EmbException> getCrashPayload(Throwable throwable) {
        Stack<EmbException> embExceptions = new Stack<EmbException>();
        while (throwable != null && !throwable.equals(throwable.getCause())) {
            EmbException embException = new EmbException();
            embException.setExceptionName(throwable.getClass().getName().trim());
            embException.setExceptionMessage(throwable.getMessage().trim());
            ArrayList<String> stackTraceList = new ArrayList<String>();
            for (StackTraceElement stackTrace : throwable.getStackTrace()) {
                stackTraceList.add(stackTrace.toString().trim());
            }
            embException.setExceptionStackTrace(stackTraceList);
            embExceptions.push(embException);
            throwable = throwable.getCause();
        }
        return embExceptions;
    }

    boolean isScreenshotsEnabled() {
        return this.screenshotsEnabled;
    }

    void setForegroundActivity(Activity activity) {
        if (activity != null) {
            if (this.foregroundActivity == null || !activity.equals(this.foregroundActivity.get())) {
                this.foregroundActivity = new WeakReference<Activity>(activity);
            }
        } else {
            this.foregroundActivity = null;
        }
    }

    Activity getForegroundActivity() {
        return this.foregroundActivity != null ? (Activity)this.foregroundActivity.get() : null;
    }

    private static enum EmbManagerMapResource {
        EmbManagerMapResourceEvents,
        EmbManagerMapResourceActiveStories,
        EmbManagerMapResourceLateTimers,
        EmbManagerMapResourceScreenshots;

    }
}

