/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbDevice;
import io.embrace.android.embracesdk.EmbException;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbUser;
import io.embrace.android.embracesdk.Timestamped;
import io.embrace.android.embracesdk.constants.EmbApiConstants;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbDebugMessage
implements Timestamped,
Serializable {
    private long timestamp;
    private String message;
    private EmbDebugMessageType embDebugMessageType;
    private Stack<EmbException> exceptionStack;
    private Map<String, Object> additionalInfo;
    private Map<String, JSONObject> additionalPayloads = new HashMap<String, JSONObject>();

    EmbDebugMessage(String jsonStr) {
        String key;
        Iterator iter;
        JSONObject json;
        try {
            json = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            EmbLogger.logWarning("Failed to initialize EmbDebugMessage from JSON string.");
            json = new JSONObject();
        }
        JSONObject infoJsonObject = json.optJSONObject("db");
        this.timestamp = infoJsonObject.optLong("ts", System.currentTimeMillis());
        this.message = infoJsonObject.optString("m");
        this.embDebugMessageType = this.getDebugMessageTypeForString(infoJsonObject.optString("sv"));
        this.exceptionStack = new Stack();
        JSONArray array = infoJsonObject.optJSONArray("ex");
        for (int i = 0; i < array.length(); ++i) {
            this.exceptionStack.add(new EmbException(array.optString(i)));
        }
        this.additionalInfo = new HashMap<String, Object>();
        JSONObject additionalInfoJson = infoJsonObject.optJSONObject("v");
        if (additionalInfoJson != null) {
            iter = additionalInfoJson.keys();
            while (iter.hasNext()) {
                key = (String)iter.next();
                this.additionalInfo.put(key, additionalInfoJson.opt(key));
            }
        }
        this.additionalPayloads = new HashMap<String, JSONObject>();
        iter = json.keys();
        while (iter.hasNext()) {
            key = (String)iter.next();
            JSONObject additionalPayload = json.optJSONObject(key);
            if (additionalPayload == null || key.equals("db")) continue;
            this.additionalPayloads.put(key, additionalPayload);
        }
    }

    EmbDebugMessage(EmbDebugMessageType embDebugMessageType, String message, Stack<EmbException> exceptionStack, Map<String, Object> additionalInfo) {
        this.timestamp = System.currentTimeMillis();
        this.message = message;
        this.embDebugMessageType = embDebugMessageType;
        this.exceptionStack = exceptionStack;
        this.additionalInfo = additionalInfo;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    synchronized void addPayload(JSONObject payload, String bodyKey) {
        if (payload == null || bodyKey == null) {
            EmbLogger.logWarning("can't add additional debug payload with a null key or body");
            return;
        }
        this.additionalPayloads.put(bodyKey, payload);
    }

    JSONObject getServerPayload() {
        JSONObject serverPayload = new JSONObject();
        this.addPayload(EmbUser.getInstance().toJsonObject(), "u");
        this.addPayload(EmbDevice.getInstance().getDeviceInfoJsonObject(), "d");
        this.addPayload(EmbDevice.getInstance().getAppInfoJsonObject(), "a");
        try {
            JSONObject messagePayload = new JSONObject();
            messagePayload.put("m", (Object)this.message);
            messagePayload.put("ts", this.timestamp);
            messagePayload.put("sv", (Object)this.getStringForDebugMessageType(this.embDebugMessageType));
            JSONArray array = new JSONArray();
            if (this.exceptionStack != null) {
                Iterator embExceptionIterator = this.exceptionStack.iterator();
                while (embExceptionIterator.hasNext()) {
                    array.put((Object)((EmbException)embExceptionIterator.next()).toJson());
                }
            }
            messagePayload.put("ex", (Object)array);
            if (this.additionalInfo != null) {
                messagePayload.put("v", (Object)new JSONObject(this.additionalInfo));
            }
            serverPayload.put("db", (Object)messagePayload);
            serverPayload.put("v", (Object)EmbApiConstants.EmbMessageFormatVersion);
            for (String key : this.additionalPayloads.keySet()) {
                serverPayload.put(key, (Object)this.additionalPayloads.get(key));
            }
        }
        catch (JSONException e) {
            serverPayload = null;
        }
        return serverPayload;
    }

    private String getStringForDebugMessageType(EmbDebugMessageType messageType) {
        switch (messageType) {
            case DEBUG: {
                return "debug";
            }
            case WARNING: {
                return "warning";
            }
            case INFO: {
                return "info";
            }
            case ERROR: {
                return "error";
            }
        }
        return null;
    }

    private EmbDebugMessageType getDebugMessageTypeForString(String messageType) {
        switch (messageType) {
            case "debug": {
                return EmbDebugMessageType.DEBUG;
            }
            case "warning": {
                return EmbDebugMessageType.WARNING;
            }
            case "info": {
                return EmbDebugMessageType.INFO;
            }
            case "error": {
                return EmbDebugMessageType.ERROR;
            }
        }
        return null;
    }

    static enum EmbDebugMessageType {
        DEBUG,
        ERROR,
        WARNING,
        INFO;

    }
}

