/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Pair;
import io.embrace.android.embracesdk.EmbBreadcrumb;
import io.embrace.android.embracesdk.EmbFixedSizeDeque;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;

public class EmbBreadcrumbManager {
    private static final Integer EmbBreadcrumbViewLogMax = 50;
    private static final Integer EmbBreadcrumbTapLogMax = 100;
    private static final EmbBreadcrumbManager manager = new EmbBreadcrumbManager();
    private final EmbFixedSizeDeque<EmbBreadcrumb> viewLogsDeque = new EmbFixedSizeDeque(EmbBreadcrumbViewLogMax);
    private final EmbFixedSizeDeque<EmbBreadcrumb> tapLogsDeque = new EmbFixedSizeDeque(EmbBreadcrumbTapLogMax);

    static EmbBreadcrumbManager getManager() {
        return manager;
    }

    private EmbBreadcrumbManager() {
    }

    public void logView(String screen, long timestamp) {
        EmbBreadcrumb breadcrumb = (EmbBreadcrumb)this.viewLogsDeque.peekLast();
        String string = screen = screen != null ? screen : "unknown";
        if (breadcrumb == null || !breadcrumb.getScreen().equals(screen)) {
            try {
                this.viewLogsDeque.forcePutLast(new EmbBreadcrumb(screen, timestamp));
            }
            catch (InterruptedException e) {
                EmbLogger.logError("Thread was interrupted while attempting to register view breadcrumb.", e);
            }
        }
    }

    public void log(Pair<Float, Float> point, String element, long timestamp, EmbBreadcrumb.EmbBreadcrumbType type) {
        try {
            this.tapLogsDeque.forcePutLast(new EmbBreadcrumb(point, element, timestamp, type));
        }
        catch (InterruptedException e) {
            EmbLogger.logError("Thread was interrupted while attempting to register tap breadcrumb.", e);
        }
    }

    private List<EmbBreadcrumb> getViewBreadcrumbsAfterTime(long startTime, long endTime) {
        return this.filterListByStartAndEndTime(this.viewLogsDeque, startTime, endTime);
    }

    List<EmbBreadcrumb> getViewBreadcrumbsDuringSession(EmbSession session) {
        return this.getViewBreadcrumbsAfterTime(session.getStartTime().getTime(), session.getEndTime().getTime());
    }

    List<EmbBreadcrumb> getRecentViewBreadcrumbs(int count) {
        return this.getLastElements(this.viewLogsDeque, count);
    }

    private List<EmbBreadcrumb> getTapBreadcrumbsAfterTime(long startTime, long endTime) {
        return this.filterListByStartAndEndTime(this.tapLogsDeque, startTime, endTime);
    }

    List<EmbBreadcrumb> getTapBreadcrumbsDuringSession(EmbSession session) {
        return this.getTapBreadcrumbsAfterTime(session.getStartTime().getTime(), session.getEndTime().getTime());
    }

    List<EmbBreadcrumb> getRecentTapBreadcrumbs(int count) {
        return this.getLastElements(this.tapLogsDeque, count);
    }

    private List<EmbBreadcrumb> filterListByStartAndEndTime(Queue<EmbBreadcrumb> listToFilter, long startTime, long endTime) {
        ArrayList<EmbBreadcrumb> result = new ArrayList<EmbBreadcrumb>();
        for (EmbBreadcrumb breadcrumb : listToFilter) {
            if (breadcrumb.getTimestamp() < startTime || breadcrumb.getTimestamp() > endTime) continue;
            result.add(breadcrumb);
        }
        return result;
    }

    private List<EmbBreadcrumb> getLastElements(Queue<EmbBreadcrumb> listToFilter, int count) {
        ArrayList<EmbBreadcrumb> result = new ArrayList<EmbBreadcrumb>();
        Stack<EmbBreadcrumb> queue = new Stack<EmbBreadcrumb>();
        queue.addAll(listToFilter);
        for (int i = listToFilter.size() - 1; i > listToFilter.size() - 1 - count && i >= 0; --i) {
            result.add((EmbBreadcrumb)queue.pop());
        }
        return result;
    }
}

