/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import io.embrace.android.embracesdk.EmbBatteryBroadcastReceiver;
import io.embrace.android.embracesdk.EmbFilterable;
import io.embrace.android.embracesdk.EmbInterval;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbSession;
import io.embrace.android.embracesdk.EmbSystemEvent;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.FilterableUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class EmbPowerManager {
    private static final String EmbBatteryLevelKey = "bt";
    private static final String EmbBatteryChargingKey = "bc";
    private static final Integer EmbBatteryMeasurementIntervalInSeconds = 60;
    private static final long SHUTDOWN_TIMEOUT_MS = 2000L;
    private List<EmbFilterable> chargingIntervals;
    private List<EmbSystemEvent> batteryMeasurements;
    private EmbInterval currentChargingInterval;
    private boolean isBatteryCharging;
    private boolean isSdkDisabled;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private EmbBatteryBroadcastReceiver batteryBroadcastReceiver = new EmbBatteryBroadcastReceiver();
    private Runnable batteryInfoRunnable = new Runnable(){

        @Override
        public void run() {
            EmbPowerManager.this.recordBatteryLevel();
        }
    };
    private static final EmbPowerManager manager = new EmbPowerManager();

    static EmbPowerManager getManager() {
        return manager;
    }

    private EmbPowerManager() {
        this.chargingIntervals = new ArrayList<EmbFilterable>();
        this.batteryMeasurements = new ArrayList<EmbSystemEvent>();
        Intent batteryStatus = this.registerBroadcastReceiver();
        int status = batteryStatus.getIntExtra("status", -1);
        boolean bl = this.isBatteryCharging = status == 2 || status == 5;
        if (this.isBatteryCharging) {
            EmbInterval chargingInterval = new EmbInterval();
            this.chargingIntervals.add(chargingInterval);
            this.currentChargingInterval = chargingInterval;
        }
        this.startObservingBatteryLevel();
    }

    private void startObservingBatteryLevel() {
        this.executorService.scheduleAtFixedRate(this.batteryInfoRunnable, 0L, EmbBatteryMeasurementIntervalInSeconds.intValue(), TimeUnit.SECONDS);
    }

    private Intent registerBroadcastReceiver() {
        this.batteryBroadcastReceiver = new EmbBatteryBroadcastReceiver();
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        return Embrace.getContext().registerReceiver((BroadcastReceiver)this.batteryBroadcastReceiver, ifilter);
    }

    float getBatteryLevel() {
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = Embrace.getContext().registerReceiver(null, ifilter);
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        return (float)level / (float)scale;
    }

    List<EmbInterval> getChargingIntervalsBetween(long startTime, long endTime) {
        return FilterableUtils.filter(this.chargingIntervals, startTime, endTime);
    }

    List<EmbInterval> getChargingIntervalsDuringSession(EmbSession session) {
        return this.getChargingIntervalsBetween(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    private List<EmbSystemEvent> getBatteryMeasurementsBetween(long startTime, long endTime) {
        ArrayList<EmbSystemEvent> batteryMeasurements = new ArrayList<EmbSystemEvent>(this.batteryMeasurements);
        Iterator batteryMeasurementsIterator = batteryMeasurements.iterator();
        while (batteryMeasurementsIterator.hasNext()) {
            EmbSystemEvent embSystemEvent = (EmbSystemEvent)batteryMeasurementsIterator.next();
            if (embSystemEvent.getTimestamp() < startTime || embSystemEvent.getTimestamp() > endTime) continue;
            batteryMeasurementsIterator.remove();
        }
        return batteryMeasurements;
    }

    List<EmbSystemEvent> getBatteryMeasurementsDuringSession(EmbSession session) {
        return this.getBatteryMeasurementsBetween(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    private synchronized void recordBatteryLevel() {
        EmbSystemEvent batteryLog = new EmbSystemEvent(Float.valueOf(this.getBatteryLevel()));
        this.batteryMeasurements.add(batteryLog);
    }

    private boolean isBatteryCharging(int batteryStatus) {
        return batteryStatus == 2 || batteryStatus == 5;
    }

    private BatteryChargingStatusUpdate didBatteryChargingStatusChange(int batteryStatus) {
        if (this.isBatteryCharging(batteryStatus)) {
            return !this.isBatteryCharging ? BatteryChargingStatusUpdate.BATTERY_STARTED_CHARGING : BatteryChargingStatusUpdate.NO_CHANGE;
        }
        return this.isBatteryCharging ? BatteryChargingStatusUpdate.BATTERY_STOPPED_CHARGING : BatteryChargingStatusUpdate.NO_CHANGE;
    }

    private void onBatteryStateChanged(int batteryStatus) {
        switch (this.didBatteryChargingStatusChange(batteryStatus)) {
            case BATTERY_STARTED_CHARGING: {
                EmbInterval chargingInterval = new EmbInterval();
                this.chargingIntervals.add(chargingInterval);
                this.currentChargingInterval = chargingInterval;
                break;
            }
            case BATTERY_STOPPED_CHARGING: {
                if (this.currentChargingInterval == null) break;
                this.currentChargingInterval.endInterval();
                this.currentChargingInterval = null;
                EmbLogger.logDebug("Ending previous charging interval", new Object[0]);
                break;
            }
        }
        this.isBatteryCharging = this.isBatteryCharging(batteryStatus);
    }

    synchronized void handleBatteryStateChange(final Intent batteryStatus) {
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                EmbPowerManager.this.onBatteryStateChanged(batteryStatus.getIntExtra("status", -1));
            }
        }, 0L, TimeUnit.SECONDS);
    }

    private SdkStatusUpdate didSdkStatusChanged(boolean sdkStatus) {
        if (this.isSdkDisabled == sdkStatus) {
            return SdkStatusUpdate.NO_CHANGE;
        }
        if (sdkStatus && !this.isSdkDisabled) {
            return SdkStatusUpdate.SDK_ENABLED;
        }
        return SdkStatusUpdate.SDK_DISABLED;
    }

    void onSdkStatusChanged(boolean sdkStatus) {
        switch (this.didSdkStatusChanged(sdkStatus)) {
            case SDK_DISABLED: {
                this.executorService.shutdown();
                try {
                    if (this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) break;
                    EmbLogger.logWarning("Executor service was not safely terminated.", new Object[0]);
                }
                catch (InterruptedException e) {
                    EmbLogger.logWarning("Error while shutting down executor", e.getLocalizedMessage());
                }
                break;
            }
            case SDK_ENABLED: {
                if (this.executorService.isShutdown()) {
                    this.executorService = Executors.newSingleThreadScheduledExecutor();
                }
                this.startObservingBatteryLevel();
                break;
            }
        }
        this.isSdkDisabled = sdkStatus;
    }

    JSONObject toJson() {
        JSONObject payload = new JSONObject();
        try {
            payload.put(EmbBatteryLevelKey, (double)this.getBatteryLevel());
            payload.put(EmbBatteryChargingKey, this.isBatteryCharging);
        }
        catch (JSONException e) {
            EmbLogger.logError("error creating battery event object: %s", e.getLocalizedMessage());
            payload = null;
        }
        return payload;
    }

    private static enum SdkStatusUpdate {
        NO_CHANGE,
        SDK_ENABLED,
        SDK_DISABLED;

    }

    private static enum BatteryChargingStatusUpdate {
        NO_CHANGE,
        BATTERY_STARTED_CHARGING,
        BATTERY_STOPPED_CHARGING;

    }
}

