/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.EmbLogger;

class EmbEventNameValidator {
    private EmbEventNameValidator() {
    }

    static boolean validateEventName(String name, String identifier) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            EmbLogger.logWarning("Event name must not be blank", new Object[0]);
            return false;
        }
        if (name.startsWith("_")) {
            EmbLogger.logWarning("Event name must not begin with an underscore", new Object[0]);
            return false;
        }
        if (name.contains("#")) {
            EmbLogger.logWarning("Event name must not contain the %s character", "#");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return true;
        }
        if (identifier.startsWith("_")) {
            EmbLogger.logWarning("Event identifier must not begin with an underscore", new Object[0]);
            return false;
        }
        if (identifier.contains("#")) {
            EmbLogger.logWarning("Event identifier must not contain the %s character", "#");
            return false;
        }
        return true;
    }
}

