/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Pair;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class EmbBreadcrumb {
    private final String screen;
    private final Long timestamp;
    private final String element;
    private final String location;
    private final EmbBreadcrumbType type;

    EmbBreadcrumb(String screen, long timestamp) {
        this(screen, null, null, timestamp, EmbBreadcrumbType.EmbBreadcrumbTypeView);
    }

    EmbBreadcrumb(Pair<Float, Float> point, String element, long timestamp, EmbBreadcrumbType type) {
        this(null, point, element, timestamp, type);
    }

    private EmbBreadcrumb(String screen, Pair<Float, Float> point, String element, long timestamp, EmbBreadcrumbType type) {
        this.type = type;
        this.screen = screen;
        this.element = element;
        this.timestamp = timestamp;
        this.location = this.getStringForPoint(point);
    }

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.timestamp != null) {
                jsonObject.put("ts", (Object)this.timestamp);
            }
            if (this.screen != null) {
                jsonObject.put("vn", (Object)this.screen);
            }
            if (this.element != null) {
                jsonObject.put("tt", (Object)this.element);
            }
            if (this.location != null && this.type != EmbBreadcrumbType.EmbBreadcrumbTypeView) {
                jsonObject.put("tl", (Object)this.location);
                if (this.getStringForTapType(this.type) != null) {
                    jsonObject.put("t", (Object)this.getStringForTapType(this.type));
                }
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    Long getTimestamp() {
        return this.timestamp;
    }

    String getScreen() {
        return this.screen;
    }

    private String getStringForPoint(Pair<Float, Float> point) {
        return String.format(Locale.US, "%d,%d", point != null ? ((Float)point.first).intValue() : 0, point != null ? ((Float)point.second).intValue() : 0);
    }

    private String getStringForTapType(EmbBreadcrumbType type) {
        switch (type) {
            case EmbBreadcrumbTypeTap: {
                return "s";
            }
            case EmbBreadcrumbTypeDoubleTap: {
                return "d";
            }
            case EmbBreadcrumbTypeLongPress: {
                return "l";
            }
        }
        return null;
    }

    public static enum EmbBreadcrumbType {
        EmbBreadcrumbTypeView,
        EmbBreadcrumbTypeTap,
        EmbBreadcrumbTypeDoubleTap,
        EmbBreadcrumbTypeLongPress;

    }
}

