/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.swazzle.callback.android.app;

import android.os.Bundle;
import android.support.v4.view.GestureDetectorCompat;
import android.util.Pair;
import android.view.GestureDetector;
import android.view.MotionEvent;
import io.embrace.android.embracesdk.EmbApplicationStateManager;
import io.embrace.android.embracesdk.EmbBreadcrumb;
import io.embrace.android.embracesdk.EmbBreadcrumbManager;
import io.embrace.android.embracesdk.swazzle.SwazzleContext;

public final class Activity {
    private static GestureDetectorCompat mDetector;

    public static void _preDispatchTouchEvent(android.app.Activity activity, MotionEvent event) {
        if (mDetector != null) {
            mDetector.onTouchEvent(event);
        }
    }

    public static void _preOnCreate(android.app.Activity activity, Bundle bundle) {
        Activity.enableApplicationStateManager();
    }

    public static void _preOnStart(android.app.Activity activity) {
        Activity.enableApplicationStateManager();
        if (SwazzleContext.containsKey("breadcrumb_manager")) {
            ((EmbBreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).logView(activity.getClass().getName());
        }
    }

    public static void _preOnPause(android.app.Activity activity) {
        mDetector = null;
        Activity.setAppStatePaused(true);
    }

    public static void _preOnResume(android.app.Activity activity) {
        EmbGestureListener embGestureListener = new EmbGestureListener(activity);
        if (mDetector == null) {
            mDetector = new GestureDetectorCompat(activity.getApplicationContext(), (GestureDetector.OnGestureListener)embGestureListener);
            mDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)embGestureListener);
        }
    }

    public static void _postOnStop(android.app.Activity activity) {
        Activity.setBackgroundCallbacks();
    }

    public static void _postOnDestroy(android.app.Activity activity) {
        Activity.setBackgroundCallbacks();
    }

    private static void setBackgroundCallbacks() {
        if (SwazzleContext.containsKey("application_state_manager")) {
            EmbApplicationStateManager applicationStateManager = (EmbApplicationStateManager)SwazzleContext.get("application_state_manager");
            applicationStateManager.setBackgroundCallbacks();
        }
    }

    private static void enableApplicationStateManager() {
        if (SwazzleContext.containsKey("application_state_manager")) {
            EmbApplicationStateManager applicationStateManager = (EmbApplicationStateManager)SwazzleContext.get("application_state_manager");
            applicationStateManager.enable();
        }
    }

    private static void setAppStatePaused(boolean isPaused) {
        if (SwazzleContext.containsKey("application_state_manager")) {
            EmbApplicationStateManager applicationStateManager = (EmbApplicationStateManager)SwazzleContext.get("application_state_manager");
            applicationStateManager.setPaused(isPaused);
        }
    }

    private static class EmbGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final android.app.Activity activity;

        EmbGestureListener(android.app.Activity activity) {
            this.activity = activity;
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (SwazzleContext.containsKey("breadcrumb_manager")) {
                ((EmbBreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).log((Pair<Float, Float>)new Pair((Object)Float.valueOf(e.getX()), (Object)Float.valueOf(e.getY())), this.activity.getLocalClassName(), EmbBreadcrumb.EmbBreadcrumbType.EmbBreadcrumbTypeTap);
            }
            return false;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (SwazzleContext.containsKey("breadcrumb_manager")) {
                ((EmbBreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).log((Pair<Float, Float>)new Pair((Object)Float.valueOf(e.getX()), (Object)Float.valueOf(e.getY())), this.activity.getLocalClassName(), EmbBreadcrumb.EmbBreadcrumbType.EmbBreadcrumbTypeDoubleTap);
            }
            return false;
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
            if (SwazzleContext.containsKey("breadcrumb_manager")) {
                ((EmbBreadcrumbManager)SwazzleContext.get("breadcrumb_manager")).log((Pair<Float, Float>)new Pair((Object)Float.valueOf(e.getX()), (Object)Float.valueOf(e.getY())), this.activity.getLocalClassName(), EmbBreadcrumb.EmbBreadcrumbType.EmbBreadcrumbTypeLongPress);
            }
        }
    }
}

