/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.Timestamped;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

class EmbSystemEvent
implements Timestamped {
    private static final String EmbSystemEventTimestampKey = "ts";
    private static final String EmbSystemEventValueKey = "v";
    private Float value;
    private long timestamp;

    EmbSystemEvent() {
        this(null);
    }

    EmbSystemEvent(Float value) {
        this.value = value;
        this.timestamp = Calendar.getInstance().getTimeInMillis();
    }

    JSONObject toJson() {
        JSONObject payload = new JSONObject();
        try {
            payload.put(EmbSystemEventTimestampKey, this.timestamp);
            if (this.value != null) {
                payload.put(EmbSystemEventValueKey, (Object)this.value);
            }
        }
        catch (JSONException e) {
            EmbLogger.logError("error creating system event object: %s", e.getLocalizedMessage());
            payload = null;
        }
        return payload;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }
}

