/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.AsyncTask;
import io.embrace.android.embracesdk.EmbDevice;
import io.embrace.android.embracesdk.EmbEndpoint;
import io.embrace.android.embracesdk.EmbEvent;
import io.embrace.android.embracesdk.EmbFileUtils;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbManager;
import io.embrace.android.embracesdk.EmbRequest;
import io.embrace.android.embracesdk.EmbSession;
import io.embrace.android.embracesdk.EmbSystemUtils;
import io.embrace.android.embracesdk.EmbUser;
import io.embrace.android.embracesdk.EmbUserCompletionMessageCallback;
import io.embrace.android.embracesdk.EmbraceAsyncTask;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.helpers.EmbFileCache;
import io.embrace.android.embracesdk.helpers.EmbraceApiCallback;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

class EmbServer {
    private static final String EmbBaseUrlFormat = "%s://%s.%s";
    private static final String EmbUrlFormat = "%s/v%s/%s";
    private static final String EmbApiVersion = "1";
    private static final String EmbApiScheme = "https";
    private static final String EmbApiHost = "emb-api.com";
    private static final String EmbConfigUrlFormat = "%s?appId=%s&osVersion=%s&appVersion=%s&deviceId=%s";
    static final String EmbScreenshotUrlFormat = "%s/%s/%s/%s.jpg";
    static final String EmbScreenshotMomentsPath = "moments";
    static final String EmbScreenshotLogsPath = "logs";
    static final String EmbJsonContentType = "application/json";
    private static final String EmbStoryIdHeaderFormat = "%s:%s";
    static final String EmbAppIdHeader = "X-EM-AID";
    static final String EmbDeviceIdHeader = "X-EM-DID";
    static final String EmbStoryIdHeader = "X-EM-SID";
    static final String EmbLogIdHeader = "X-EM-LID";
    private static final String EmbDataApiSubdomain = "data";
    private static final String EmbConfigApiSubdomain = "config";
    private static final String EmbImagesApiSubdomain = "images";
    private static final String EmbEventsApiPath = "log/events";
    private static final String EmbUsersApiPath = "log/users";
    private static final String EmbSessionsApiPath = "log/sessions";
    private static final String EmbLogsApiPath = "log/logging";
    private static final String EmbConfigApiPath = "config";
    private static final String EmbImagesApiPath = "screenshot";
    private static final EmbServer singleton = new EmbServer();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final List<HashMap<String, Object>> failedSessionsStarts = new ArrayList<HashMap<String, Object>>();
    private final List<EmbSession> failedSessions = new ArrayList<EmbSession>();
    private final List<EmbEvent> failedEvents = new ArrayList<EmbEvent>();
    private boolean attemptingRetries = false;
    private final Runnable retryFailedRequestsRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                EmbServer.this.retryFailedRequests();
            }
            catch (EmbraceSdkException e) {
                EmbLogger.logDebug("Error while retrying sending of failed requests", e);
            }
        }
    };

    private EmbServer() {
        this.restoreCachedFailures();
    }

    static EmbServer getInstance() {
        return singleton;
    }

    static Executor getExecutor() {
        return AsyncTask.THREAD_POOL_EXECUTOR;
    }

    void fetchConfigurationCompletion(EmbraceApiCallback callback) throws EmbraceSdkException {
        EmbRequest request = this.remoteConfigRequest();
        if (request != null) {
            EmbraceAsyncTask asyncTask;
            try {
                asyncTask = new EmbraceAsyncTask(request.createRemoteConfigConnection(), request, callback);
            }
            catch (IOException e) {
                throw new EmbraceSdkException("couldn't fetch config", e);
            }
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        } else {
            EmbLogger.logError("Could not create request for remote config fetch", new Object[0]);
        }
    }

    void sendUserMessageCompletion(final EmbUserCompletionMessageCallback callback) throws EmbraceSdkException {
        EmbLogger.logDebug("sending user information", new Object[0]);
        String urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointUsers);
        if (urlString == null) {
            EmbLogger.logError("null url for request to user endpoint, aborting", new Object[0]);
            return;
        }
        Map<String, Object> userInfo = EmbUser.getInstance().mapRepresentation();
        EmbLogger.logDebug("user message payload: %s", userInfo.toString());
        JSONObject payload = EmbUser.getInstance().toJsonObject();
        if (payload == null) {
            EmbLogger.logError("error encoding json for user message:", new Object[0]);
            return;
        }
        try {
            EmbRequest request = new EmbRequest(new URL(urlString), payload, null, null);
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) {
                    EmbSystemUtils.getInstance().setUserMessageNeedsRetry(false);
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(String error) {
                    EmbSystemUtils.getInstance().setUserMessageNeedsRetry(true);
                    if (callback != null) {
                        callback.onError();
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request: %s", e.getLocalizedMessage());
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendStartOfSession(final HashMap payload, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointSessions);
        if (urlString == null) {
            EmbLogger.logError("null url for request to session endpoint, aborting", new Object[0]);
            return;
        }
        if (payload == null) {
            EmbLogger.logError("error encoding json for session message", new Object[0]);
            return;
        }
        try {
            EmbRequest request = new EmbRequest(new URL(urlString), new JSONObject((Map)payload), null, null);
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbServer.this.attemptingRetries) {
                        EmbServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbServer.this.addFailedSessionStart(payload);
                    if (callback != null) {
                        callback.onError(error);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request: %s", e.getLocalizedMessage());
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendSession(final EmbSession session, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointSessions);
        if (urlString == null) {
            EmbLogger.logError("null url for request to session endpoint, aborting", new Object[0]);
            return;
        }
        if (session == null || session.serverPayload() == null) {
            EmbLogger.logError("error encoding json for session message", new Object[0]);
            return;
        }
        try {
            EmbRequest request = new EmbRequest(new URL(urlString), session.serverPayload(), null, null);
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (!EmbServer.this.attemptingRetries) {
                        EmbServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbServer.this.addFailedSession(session);
                    if (callback != null) {
                        callback.onError(error);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request: %s", e.getLocalizedMessage());
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    void sendEvent(final EmbEvent event, final EmbraceApiCallback callback) throws EmbraceSdkException {
        String urlString;
        switch (event.getType()) {
            case EmbEventTypeInfoLog: 
            case EmbEventTypeErrorLog: {
                urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointLogs);
                break;
            }
            default: {
                urlString = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointEvents);
            }
        }
        if (urlString == null) {
            EmbLogger.logError("null url for request to session endpoint, aborting", new Object[0]);
            return;
        }
        if (event.serverPayload() == null) {
            EmbLogger.logError("error encoding json for event message", new Object[0]);
            return;
        }
        String storyIdentifier = String.format(EmbStoryIdHeaderFormat, event.getTypeAbbreviation(), event.getStoryId());
        try {
            EmbRequest request = event.getType() == EmbEvent.EmbEventType.EmbEventTypeInfoLog || event.getType() == EmbEvent.EmbEventType.EmbEventTypeErrorLog ? new EmbRequest(new URL(urlString), event.serverPayload(), null, storyIdentifier) : new EmbRequest(new URL(urlString), event.serverPayload(), storyIdentifier, null);
            EmbraceAsyncTask asyncTask = new EmbraceAsyncTask(request.createConnection(), request, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    if (event.getType() == EmbEvent.EmbEventType.EmbEventTypeEnd && !EmbServer.this.attemptingRetries) {
                        EmbServer.this.retryFailedRequests();
                    }
                    if (callback != null) {
                        callback.onSuccess(response);
                    }
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbServer.this.addFailedEvent(event);
                    if (callback != null) {
                        callback.onError(error);
                    }
                }
            });
            asyncTask.executeOnExecutor(EmbServer.getExecutor(), new Void[0]);
        }
        catch (IOException e) {
            EmbLogger.logWarning("error while executing request: %s", e.getLocalizedMessage());
            throw new EmbraceSdkException("error while executing request", e);
        }
    }

    private String urlStringForRequestToEndpoint(EmbEndpoint endpoint) {
        switch (endpoint) {
            case EmbEndpointConfig: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, "config", EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, "config");
            }
            case EmbEndpointEvents: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbEventsApiPath);
            }
            case EmbEndpointUsers: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbUsersApiPath);
            }
            case EmbEndpointSessions: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbSessionsApiPath);
            }
            case EmbEndpointImages: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbImagesApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbImagesApiPath);
            }
            case EmbEndpointLogs: {
                String baseUrlString = String.format(EmbBaseUrlFormat, EmbApiScheme, EmbDataApiSubdomain, EmbApiHost);
                return String.format(EmbUrlFormat, baseUrlString, EmbApiVersion, EmbLogsApiPath);
            }
        }
        return null;
    }

    private EmbRequest remoteConfigRequest() throws EmbraceSdkException {
        String baseConfigUrl = this.urlStringForRequestToEndpoint(EmbEndpoint.EmbEndpointConfig);
        if (baseConfigUrl == null) {
            EmbLogger.logError("null url for config endpoint, aborting", new Object[0]);
            return null;
        }
        String configUrlString = String.format(EmbConfigUrlFormat, baseConfigUrl, EmbManager.getInstance().getApiKey(), EmbDevice.getInstance().getOperatingSystemVersionForRequest(), EmbDevice.getInstance().getVersionCodeForRequest(), EmbSystemUtils.getInstance().getDeviceId());
        URL configUrl = null;
        try {
            configUrl = new URL(configUrlString);
        }
        catch (MalformedURLException e) {
            throw new EmbraceSdkException("wrong configUrlString: " + configUrlString, e);
        }
        return new EmbRequest(configUrl, null, null, null);
    }

    private synchronized void addFailedEvent(EmbEvent event) {
        this.failedEvents.add(event);
    }

    private synchronized void addFailedSession(EmbSession session) {
        this.failedSessions.add(session);
    }

    private synchronized void addFailedSessionStart(HashMap payload) {
        this.failedSessionsStarts.add(payload);
    }

    synchronized void addFailedSessions(Collection<EmbSession> sessions) {
        if (sessions == null || sessions.size() == 0) {
            EmbLogger.logWarning("no additional failed sessions to add", new Object[0]);
            return;
        }
        this.failedSessions.addAll(sessions);
        this.cacheFailedSessions();
    }

    private void restoreCachedFailures() {
        try {
            this.failedEvents.addAll(this.getCacheFailedEvents());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("No failed events found in cache", e);
        }
        try {
            this.failedSessions.addAll(this.getCacheFailedSessions());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("No failed sessions found in cache", e);
        }
        try {
            this.failedSessionsStarts.addAll(this.getCacheFailedSessionsStarts());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("No failed session starts found in cache", e);
        }
    }

    private void cacheFailedSessionsStarts() {
        try {
            EmbFileUtils.saveCollectionToFile(this.failedSessionsStarts, EmbFileCache.EmbFileCacheFailedSessionStartMessages);
            EmbLogger.logDebug("wrote %s failed session starts to cache", this.failedSessionsStarts.size());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving failed session starts", e);
        }
    }

    private void cacheFailedSessions() {
        try {
            ArrayList<String> failedSessions = new ArrayList<String>();
            for (EmbSession session : this.failedSessions) {
                failedSessions.add(session.toJson());
            }
            EmbFileUtils.saveCollectionToFile(failedSessions, EmbFileCache.EmbFileCacheFailedSessions);
            EmbLogger.logDebug("wrote %s failed sessions to cache", failedSessions.size());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving failed sessions", e);
        }
    }

    private void cacheFailedEvents() {
        try {
            EmbFileUtils.saveCollectionToFile(this.failedEvents, EmbFileCache.EmbFileCacheFailedEvents);
            EmbLogger.logDebug("wrote %s failed events to cache", this.failedEvents.size());
        }
        catch (EmbraceSdkException e) {
            EmbLogger.logWarning("error while saving failed events", e);
        }
    }

    private Collection<HashMap<String, Object>> getCacheFailedSessionsStarts() throws EmbraceSdkException {
        return EmbFileUtils.readCollectionFromFile(EmbFileCache.EmbFileCacheFailedSessionStartMessages);
    }

    private Collection<EmbSession> getCacheFailedSessions() throws EmbraceSdkException {
        ArrayList<EmbSession> failedSessions = new ArrayList<EmbSession>();
        for (String session : EmbFileUtils.readCollectionFromFile(EmbFileCache.EmbFileCacheFailedSessions)) {
            failedSessions.add(new EmbSession(session));
        }
        return failedSessions;
    }

    private Collection<EmbEvent> getCacheFailedEvents() throws EmbraceSdkException {
        return EmbFileUtils.readCollectionFromFile(EmbFileCache.EmbFileCacheFailedEvents);
    }

    private synchronized EmbEvent popFailedEvent() {
        if (this.failedEvents.size() < 1) {
            return null;
        }
        return this.failedEvents.remove(0);
    }

    private synchronized EmbSession popFailedSession() {
        if (this.failedSessions.size() < 1) {
            return null;
        }
        return this.failedSessions.remove(0);
    }

    private synchronized HashMap popFailedSessionStart() {
        if (this.failedSessionsStarts.size() < 1) {
            return null;
        }
        return this.failedSessionsStarts.remove(0);
    }

    private synchronized void retryFailedRequests() throws EmbraceSdkException {
        this.attemptingRetries = true;
        final EmbEvent retryEvent = this.popFailedEvent();
        if (retryEvent != null) {
            EmbLogger.logDebug("going to retry previously failed event %s", retryEvent);
            this.sendEvent(retryEvent, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbLogger.logDebug("event retry succeeded, will keep retrying failed messages", new Object[0]);
                    EmbServer.this.cacheFailedEvents();
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbLogger.logDebug("event retry failed, stopping retries for now", new Object[0]);
                    EmbServer.this.addFailedEvent(retryEvent);
                    EmbServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final HashMap retrySessionStart = this.popFailedSessionStart();
        if (retrySessionStart != null) {
            EmbLogger.logDebug("going to retry previously failed session start %s", retrySessionStart);
            this.sendStartOfSession(retrySessionStart, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbLogger.logDebug("event retry succeeded, will keep retrying failed messages", new Object[0]);
                    EmbServer.this.cacheFailedSessionsStarts();
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbLogger.logDebug("session start retry failed, stopping retries for now", new Object[0]);
                    EmbServer.this.addFailedSessionStart(retrySessionStart);
                    EmbServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        final EmbSession retrySession = this.popFailedSession();
        if (retrySession != null) {
            EmbLogger.logDebug("going to retry previously failed session %s", retrySession);
            this.sendSession(retrySession, new EmbraceApiCallback(){

                @Override
                public void onSuccess(String response) throws Exception {
                    EmbLogger.logDebug("session retry succeeded, will keep retrying failed messages", new Object[0]);
                    EmbServer.this.cacheFailedSessions();
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError(String error) throws Exception {
                    EmbLogger.logDebug("session retry failed, stopping retries for now", new Object[0]);
                    EmbServer.this.addFailedSession(retrySession);
                    EmbServer.this.attemptingRetries = false;
                }
            });
            return;
        }
        if (EmbSystemUtils.getInstance().userMessageNeedsRetry()) {
            EmbLogger.logDebug("going to retry previously failed user update", new Object[0]);
            EmbSystemUtils.getInstance().setUserMessageNeedsRetry(false);
            this.sendUserMessageCompletion(new EmbUserCompletionMessageCallback(){

                @Override
                public void onSuccess() {
                    EmbLogger.logDebug("user retry succeeded, will keep retrying failed messages", new Object[0]);
                    EmbServer.this.scheduleSendingOfFailedRequests();
                }

                @Override
                public void onError() {
                    EmbLogger.logDebug("user message retry failed, stopping retries for now", new Object[0]);
                    EmbSystemUtils.getInstance().setUserMessageNeedsRetry(true);
                    EmbServer.this.attemptingRetries = false;
                }
            });
        } else {
            EmbLogger.logDebug("no retries left", new Object[0]);
            this.attemptingRetries = false;
        }
    }

    private void scheduleSendingOfFailedRequests() {
        this.executorService.schedule(this.retryFailedRequestsRunnable, 500L, TimeUnit.MILLISECONDS);
    }

    void handleNetworkReachable() {
        if (!this.attemptingRetries) {
            try {
                this.retryFailedRequests();
            }
            catch (EmbraceSdkException e) {
                EmbLogger.logDebug("Error while retrying sending of failed requests", e);
            }
        }
    }
}

