/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.ActivityManager;
import io.embrace.android.embracesdk.EmbMemorySample;
import io.embrace.android.embracesdk.EmbSession;
import io.embrace.android.embracesdk.EmbSystemEvent;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.TimestampUtils;
import io.embrace.android.embracesdk.Timestamped;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class EmbMemoryManager {
    private static final int BYTES_IN_MB = 0x100000;
    private static final EmbMemoryManager manager = new EmbMemoryManager();
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private Runnable memoryInfoRunnable = new Runnable(){

        @Override
        public void run() {
            EmbMemoryManager.this.recordSample();
        }
    };
    private final List<Timestamped> samples = new ArrayList<Timestamped>();
    private final List<Timestamped> memoryWarnings = new ArrayList<Timestamped>();
    private boolean status = false;

    static EmbMemoryManager getManager() {
        return manager;
    }

    private EmbMemoryManager() {
    }

    private void startObservingMemoryInfo() {
        this.executorService.scheduleAtFixedRate(this.memoryInfoRunnable, 0L, 2L, TimeUnit.SECONDS);
    }

    List<EmbMemorySample> getMemorySamplesWithinInterval(long startTime, long endTime) {
        return TimestampUtils.getWithinInterval(this.samples, startTime, endTime);
    }

    List<EmbMemorySample> getMemorySamplesDuringSession(EmbSession session) {
        return this.getMemorySamplesWithinInterval(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    List<EmbSystemEvent> getMemoryWarningsWithinInterval(long startTime, long endTime) {
        return TimestampUtils.getWithinInterval(this.memoryWarnings, startTime, endTime);
    }

    List<EmbSystemEvent> getMemoryWarningsDuringSession(EmbSession session) {
        return this.getMemoryWarningsWithinInterval(session.getStartTime().getTime(), session.getEndTime() != null ? session.getEndTime().getTime() : 0L);
    }

    private void recordSample() {
        this.samples.add(new EmbMemorySample(this.getAppHeapMemoryUsed() / 0x100000L, this.getSystemMemoryAvailable() / 0x100000L));
    }

    private long getAppHeapMemoryUsed() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private long getSystemMemoryAvailable() {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)Embrace.getContext().getSystemService("activity")).getMemoryInfo(memoryInfo);
        return memoryInfo.availMem;
    }

    void handleMemoryWarning() {
        EmbSystemEvent event = new EmbSystemEvent();
        this.memoryWarnings.add(event);
    }

    private EmbMemoryManagerStatus didManagerStatusChanged(boolean newStatus) {
        if (this.status == newStatus) {
            return EmbMemoryManagerStatus.NO_CHANGE;
        }
        if (!newStatus && this.status) {
            return EmbMemoryManagerStatus.MEMORY_MANAGER_DISABLED;
        }
        return EmbMemoryManagerStatus.MEMORY_MANAGER_ENABLED;
    }

    void onManagerStatusChanged(boolean newStatus) {
        switch (this.didManagerStatusChanged(newStatus)) {
            case MEMORY_MANAGER_DISABLED: {
                this.samples.clear();
                this.memoryWarnings.clear();
                this.executorService.shutdown();
                break;
            }
            case MEMORY_MANAGER_ENABLED: {
                this.startObservingMemoryInfo();
                break;
            }
        }
        this.status = newStatus;
    }

    private static enum EmbMemoryManagerStatus {
        NO_CHANGE,
        MEMORY_MANAGER_ENABLED,
        MEMORY_MANAGER_DISABLED;

    }
}

