/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.EmbApplicationStateManager;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.constants.EmbApiConstants;
import io.embrace.android.embracesdk.helpers.EmbUuid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class EmbEvent
implements Serializable {
    private static final int MAX_PROPERTY_COUNT = 10;
    private String name;
    private String storyId;
    private String sessionId;
    private List<String> unfinishedSessionIds;
    private EmbEventType type;
    private Long timestamp;
    private Long lateThreshold;
    private boolean late;
    private boolean screenshotTaken;
    private Long duration;
    private String appState;
    private Map<String, Object> customProperties;
    private Map<String, Object> additionalPayloads;

    EmbEvent(EmbEventType type, String name) {
        this(type, name, EmbUuid.getEmbUuid(UUID.randomUUID().toString()), null);
    }

    EmbEvent(EmbEventType type, String name, Map properties) {
        this(type, name, EmbUuid.getEmbUuid(UUID.randomUUID().toString()), properties);
    }

    EmbEvent(EmbEventType type, String name, String storyId) {
        this(type, name, storyId, null);
    }

    private EmbEvent(EmbEventType type, String name, String storyId, Map properties) {
        this.storyId = storyId;
        this.name = name;
        this.type = type;
        this.late = false;
        this.screenshotTaken = false;
        this.timestamp = Calendar.getInstance().getTimeInMillis();
        this.appState = EmbApplicationStateManager.getManager().isInBackground() ? "inactive" : "active";
        this.additionalPayloads = new HashMap<String, Object>();
        this.customProperties = properties != null ? this.getPropertiesMap(properties) : new HashMap();
    }

    private Map<String, Object> getPropertiesMap(Map<String, Object> properties) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String key : properties.keySet()) {
            if (key != null) {
                if (!this.isInstanceTypeAllowed(properties.get(key)) || this.addProperty(key, properties.get(key), resultMap)) continue;
                EmbLogger.logError("Event config must have at most 10 values. Object %s with key %s won't be added.", key, properties.get(key));
                continue;
            }
            EmbLogger.logError("Property key must not be null", new Object[0]);
        }
        return resultMap;
    }

    private boolean isInstanceTypeAllowed(Object value) {
        if (value != null && (value instanceof String || value instanceof Long || value instanceof Integer || value instanceof Float || value instanceof Double || value instanceof Boolean)) {
            return true;
        }
        EmbLogger.logError("Property value must be either String, Long, Integer, Float, Double or Boolean.", new Object[0]);
        return false;
    }

    private boolean addProperty(String key, Object value, Map<String, Object> resultMap) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null || resultMap.size() >= 10) {
            return false;
        }
        resultMap.put(key, value);
        return true;
    }

    void updateWithStartTime(Long startTime) {
        if (this.timestamp == null) {
            EmbLogger.logWarning("can't set duration for event without timestamp", new Object[0]);
            return;
        }
        this.duration = this.timestamp - startTime;
    }

    void addPayload(JSONObject payload, String bodyKey) {
        if (payload == null || bodyKey == null) {
            EmbLogger.logWarning("can't add additional event payload with a null key or body", new Object[0]);
            return;
        }
        this.additionalPayloads.put(bodyKey, payload);
    }

    private JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            String eventTypeString = this.stringForEventType(this.type);
            if (eventTypeString != null) {
                jsonObject.put("t", (Object)eventTypeString);
            }
            jsonObject.put("si", (Object)this.sessionIdPayload());
            jsonObject.put("sc", this.screenshotTaken);
            if (this.storyId != null) {
                if (this.type == EmbEventType.EmbEventTypeErrorLog || this.type == EmbEventType.EmbEventTypeInfoLog) {
                    jsonObject.put("li", (Object)this.storyId);
                } else {
                    jsonObject.put("id", (Object)this.storyId);
                }
            }
            if (this.name != null) {
                jsonObject.put("n", (Object)this.name);
            }
            if (this.timestamp != null) {
                jsonObject.put("ts", (Object)this.timestamp);
            }
            if (this.duration != null) {
                jsonObject.put("du", (Object)this.duration);
            }
            if (this.appState != null) {
                jsonObject.put("st", (Object)this.appState);
            }
            if (this.lateThreshold != null) {
                jsonObject.put("th", (Object)this.lateThreshold);
            }
            if (this.customProperties != null) {
                jsonObject.put("pr", (Object)new JSONObject(this.customProperties));
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    JSONObject serverPayload() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("v", (Object)EmbApiConstants.EmbMessageFormatVersion);
            jsonObject.put("et", (Object)this.toJsonObject());
            for (String key : this.additionalPayloads.keySet()) {
                jsonObject.put(key, this.additionalPayloads.get(key));
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    private String sessionIdPayload() {
        ArrayList<String> sessionIds = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)this.sessionId)) {
            sessionIds.add(this.sessionId);
        }
        if (this.unfinishedSessionIds != null) {
            for (String sessionId : this.unfinishedSessionIds) {
                if (sessionId == null || sessionId.length() <= 0) continue;
                sessionIds.add(sessionId);
            }
        }
        return TextUtils.join((CharSequence)",", sessionIds);
    }

    String getTypeAbbreviation() {
        switch (this.type) {
            case EmbEventTypeStart: {
                return "s";
            }
            case EmbEventTypeLate: {
                return "l";
            }
            case EmbEventTypeEnd: {
                return "e";
            }
            case EmbEventTypeInterrupt: {
                return "i";
            }
            case EmbEventTypeCrash: {
                return "c";
            }
            case EmbEventTypeInfoLog: {
                return "il";
            }
            case EmbEventTypeErrorLog: {
                return "el";
            }
        }
        return null;
    }

    private String stringForEventType(EmbEventType type) {
        switch (type) {
            case EmbEventTypeStart: {
                return "start";
            }
            case EmbEventTypeLate: {
                return "late";
            }
            case EmbEventTypeInterrupt: {
                return "interrupt";
            }
            case EmbEventTypeCrash: {
                return "crash";
            }
            case EmbEventTypeEnd: {
                return "end";
            }
            case EmbEventTypeInfoLog: {
                return "info";
            }
            case EmbEventTypeErrorLog: {
                return "error";
            }
        }
        return null;
    }

    void setStoryId(String storyId) {
        this.storyId = storyId;
    }

    String getStoryId() {
        return this.storyId;
    }

    void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    EmbEventType getType() {
        return this.type;
    }

    Long getTimestamp() {
        return this.timestamp;
    }

    boolean isLate() {
        return this.late;
    }

    void setLate(boolean late) {
        this.late = late;
    }

    void setLateThreshold(Long lateThreshold) {
        this.lateThreshold = lateThreshold;
    }

    static enum EmbEventType {
        EmbEventTypeStart,
        EmbEventTypeLate,
        EmbEventTypeInterrupt,
        EmbEventTypeCrash,
        EmbEventTypeEnd,
        EmbEventTypeInfoLog,
        EmbEventTypeErrorLog;

    }
}

