/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Pair;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class EmbBreadcrumb {
    private final String screen;
    private final Long timestamp;
    private final String element;
    private final String location;
    private final EmbBreadcrumbType type;

    EmbBreadcrumb(String screen) {
        this(screen, null, null, EmbBreadcrumbType.EmbBreadcrumbTypeView);
    }

    EmbBreadcrumb(Pair<Float, Float> point, String element, EmbBreadcrumbType type) {
        this(null, point, element, type);
    }

    private EmbBreadcrumb(String screen, Pair<Float, Float> point, String element, EmbBreadcrumbType type) {
        this.type = type;
        this.screen = screen;
        this.element = element;
        this.timestamp = Calendar.getInstance().getTimeInMillis();
        this.location = this.getStringForPoint(point);
    }

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.timestamp != null) {
                jsonObject.put("ts", (Object)this.timestamp);
            }
            if (this.screen != null) {
                jsonObject.put("vn", (Object)this.screen);
            }
            if (this.element != null) {
                jsonObject.put("tt", (Object)this.element);
            }
            if (this.location != null && this.type != EmbBreadcrumbType.EmbBreadcrumbTypeView) {
                jsonObject.put("tl", (Object)this.location);
                if (this.getStringForTapType(this.type) != null) {
                    jsonObject.put("t", (Object)this.getStringForTapType(this.type));
                }
            }
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    Long getTimestamp() {
        return this.timestamp;
    }

    String getScreen() {
        return this.screen;
    }

    private String getStringForPoint(Pair<Float, Float> point) {
        return String.format("%s,%s", Float.valueOf(point != null ? ((Float)point.first).floatValue() : 0.0f), Float.valueOf(point != null ? ((Float)point.second).floatValue() : 0.0f));
    }

    private String getStringForTapType(EmbBreadcrumbType type) {
        switch (type) {
            case EmbBreadcrumbTypeTap: {
                return "s";
            }
            case EmbBreadcrumbTypeDoubleTap: {
                return "d";
            }
            case EmbBreadcrumbTypeLongPress: {
                return "l";
            }
        }
        return null;
    }

    public static enum EmbBreadcrumbType {
        EmbBreadcrumbTypeView,
        EmbBreadcrumbTypeTap,
        EmbBreadcrumbTypeDoubleTap,
        EmbBreadcrumbTypeLongPress;

    }
}

