/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbApplicationStateManager;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbPowerManager;
import io.embrace.android.embracesdk.constants.EmbApiConstants;
import io.embrace.android.embracesdk.helpers.EmbUuid;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbSession {
    private static final String KEY_CACHED_APP_DATA = "cached_app_data";
    private static final String KEY_CACHED_PERFORMANCE_DATA = "cached_performance_data";
    private static final String KEY_CACHED_BREADCRUMB_DATA = "cached_breadcrumb_data";
    private static final String KEY_ADDITIONAL_PAYLOADS = "additional_payloads";
    private static final String EMB_SESSION_TYPE_START = "st";
    private static final String EMB_SESSION_TYPE_END = "en";
    private String sessionId;
    private Date startTime;
    private Date endTime;
    private Integer number;
    private boolean receivedTermination;
    private boolean coldStart;
    private JSONObject cachedAppData;
    private JSONObject cachedPerformanceData;
    private JSONObject cachedBreadcrumbData;
    private boolean endedCleanly;
    private boolean lastSessionReceivedTermination;
    private float startingBatteryLevel;
    private Date lastHeartbeatTime;
    private Date terminationTime;
    private String lastApplicationState;
    private List<String> storyIds;
    private Map<String, JSONObject> additionalPayloads;
    private List<String> infoLogIds;
    private List<String> errorLogIds;

    EmbSession(Integer number) {
        this.sessionId = EmbUuid.getEmbUuid(UUID.randomUUID().toString());
        this.startTime = Calendar.getInstance().getTime();
        this.number = number;
        this.storyIds = new ArrayList<String>();
        this.lastApplicationState = EmbApplicationStateManager.getManager().isInBackground() ? "inactive" : "active";
        this.startingBatteryLevel = EmbPowerManager.getManager().getBatteryLevel();
        this.additionalPayloads = new HashMap<String, JSONObject>();
        this.infoLogIds = new ArrayList<String>();
        this.errorLogIds = new ArrayList<String>();
    }

    EmbSession(String jsonStr) {
        JSONObject json;
        try {
            json = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            EmbLogger.logWarning("Failed to initialize EmbSession from JSON string.", new Object[0]);
            json = new JSONObject();
        }
        this.sessionId = json.optString("id", EmbUuid.getEmbUuid(UUID.randomUUID().toString()));
        this.startTime = new Date(json.optLong(EMB_SESSION_TYPE_START, Calendar.getInstance().getTime().getTime()));
        this.endTime = json.isNull("et") ? null : new Date(json.optLong("et"));
        this.number = json.optInt("sn", 0);
        this.receivedTermination = json.optBoolean("tr", false);
        this.coldStart = json.optBoolean("cs", false);
        this.cachedAppData = json.optJSONObject(KEY_CACHED_APP_DATA);
        this.cachedPerformanceData = json.optJSONObject(KEY_CACHED_PERFORMANCE_DATA);
        this.cachedBreadcrumbData = json.optJSONObject(KEY_CACHED_BREADCRUMB_DATA);
        this.endedCleanly = json.optBoolean("ce", false);
        this.lastSessionReceivedTermination = json.optBoolean("lt", false);
        this.startingBatteryLevel = (float)json.optDouble("ba", 0.0);
        this.lastHeartbeatTime = json.isNull("ht") ? null : new Date(json.optLong("ht"));
        this.terminationTime = json.isNull("tt") ? null : new Date(json.optLong("tt"));
        this.lastApplicationState = json.optString("ls", EmbApplicationStateManager.getManager().isInBackground() ? "inactive" : "active");
        this.storyIds = EmbSession.parseJsonStringArray(json.optJSONArray("ss"));
        this.additionalPayloads = new HashMap<String, JSONObject>();
        JSONObject additionalPayloads = json.optJSONObject(KEY_ADDITIONAL_PAYLOADS);
        Iterator iter = additionalPayloads.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            JSONObject additionalPayload = additionalPayloads.optJSONObject(key);
            if (additionalPayload == null) continue;
            this.additionalPayloads.put(key, additionalPayload);
        }
        this.infoLogIds = EmbSession.parseJsonStringArray(json.optJSONArray("il"));
        this.errorLogIds = EmbSession.parseJsonStringArray(json.optJSONArray("el"));
    }

    private boolean isCurrent() {
        return this.endTime == null;
    }

    void endSession() {
        if (this.endTime == null) {
            this.endTime = Calendar.getInstance().getTime();
            this.endedCleanly = true;
        }
    }

    void recordHeartbeat() {
        this.lastHeartbeatTime = Calendar.getInstance().getTime();
        this.lastApplicationState = EmbApplicationStateManager.getManager().isInBackground() ? "inactive" : "active";
    }

    private void recordTermination() {
        this.terminationTime = Calendar.getInstance().getTime();
        this.receivedTermination = true;
    }

    void recordPreviousSessionTermination() {
        this.lastSessionReceivedTermination = true;
    }

    synchronized void recordStateChange() {
        this.lastApplicationState = EmbApplicationStateManager.getManager().isInBackground() ? "inactive" : "active";
    }

    synchronized void addStoryId(String storyId) {
        this.storyIds.add(storyId);
    }

    void addInfoLogId(String messageId) {
        this.infoLogIds.add(messageId);
    }

    void addErrorLogId(String messageId) {
        this.errorLogIds.add(messageId);
    }

    synchronized void addPayload(JSONObject payload, String bodyKey) {
        if (payload == null || bodyKey == null) {
            EmbLogger.logWarning("can't add additional event payload with a null key or body", new Object[0]);
            return;
        }
        this.additionalPayloads.put(bodyKey, payload);
    }

    private JSONObject toServerPayloadJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.sessionId != null) {
                jsonObject.put("id", (Object)this.sessionId);
            }
            if (this.startTime != null) {
                jsonObject.put(EMB_SESSION_TYPE_START, this.startTime.getTime());
            }
            if (this.endTime != null) {
                jsonObject.put("et", this.endTime.getTime());
            }
            if (this.number != null) {
                jsonObject.put("sn", (Object)this.number);
            }
            if (this.lastHeartbeatTime != null) {
                jsonObject.put("ht", this.lastHeartbeatTime.getTime());
            }
            if (this.terminationTime != null) {
                jsonObject.put("tt", this.terminationTime.getTime());
            }
            jsonObject.put("ls", (Object)this.lastApplicationState);
            jsonObject.put("ba", (double)this.startingBatteryLevel);
            jsonObject.put("ce", this.endedCleanly);
            jsonObject.put("tr", this.receivedTermination);
            jsonObject.put("lt", this.lastSessionReceivedTermination);
            jsonObject.put("cs", this.coldStart);
            JSONArray storyIdsJsonArray = new JSONArray();
            for (String string : this.storyIds) {
                storyIdsJsonArray.put((Object)string);
            }
            jsonObject.put("ss", (Object)storyIdsJsonArray);
            jsonObject.put("t", (Object)EMB_SESSION_TYPE_END);
            JSONArray infoLogIdsJsonArray = new JSONArray();
            for (String messageId : this.infoLogIds) {
                infoLogIdsJsonArray.put((Object)messageId);
            }
            jsonObject.put("il", (Object)infoLogIdsJsonArray);
            JSONArray jSONArray = new JSONArray();
            for (String messageId : this.errorLogIds) {
                jSONArray.put((Object)messageId);
            }
            jsonObject.put("el", (Object)jSONArray);
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    String toJson() {
        JSONObject json = this.toServerPayloadJson();
        if (json == null) {
            return "";
        }
        try {
            json.put(KEY_CACHED_APP_DATA, (Object)this.cachedAppData);
            json.put(KEY_CACHED_PERFORMANCE_DATA, (Object)this.cachedPerformanceData);
            json.put(KEY_CACHED_BREADCRUMB_DATA, (Object)this.cachedBreadcrumbData);
            json.put(KEY_ADDITIONAL_PAYLOADS, (Object)new JSONObject(this.additionalPayloads != null ? this.additionalPayloads : new HashMap()));
        }
        catch (JSONException e) {
            EmbLogger.logWarning("An exception was thrown while encoding additional values to JSON: %s", e.toString());
            return "";
        }
        return json.toString();
    }

    JSONObject serverPayload() {
        JSONObject payload = new JSONObject();
        try {
            payload.put("v", (Object)EmbApiConstants.EmbMessageFormatVersion);
            payload.put("s", (Object)this.toServerPayloadJson());
            for (String key : this.additionalPayloads.keySet()) {
                payload.put(key, (Object)this.additionalPayloads.get(key));
            }
        }
        catch (JSONException e) {
            payload = null;
        }
        return payload;
    }

    JSONObject startMessagePayload() {
        JSONObject payload = new JSONObject();
        try {
            if (this.sessionId != null) {
                payload.put("id", (Object)this.sessionId);
            }
            if (this.startTime != null) {
                payload.put(EMB_SESSION_TYPE_START, this.startTime.getTime());
            }
            if (this.number != null) {
                payload.put("sn", (Object)this.number);
            }
            payload.put("lt", this.lastSessionReceivedTermination);
            payload.put("cs", this.coldStart);
            payload.put("t", (Object)EMB_SESSION_TYPE_START);
        }
        catch (JSONException e) {
            payload = null;
        }
        return payload;
    }

    boolean getColdStart() {
        return this.coldStart;
    }

    void setColdStart(boolean coldStart) {
        this.coldStart = coldStart;
    }

    String getSessionId() {
        return this.sessionId;
    }

    Date getStartTime() {
        return this.startTime;
    }

    Date getEndTime() {
        return this.endTime;
    }

    void setReceivedTermination(boolean receivedTermination) {
        this.receivedTermination = receivedTermination;
    }

    JSONObject getCachedAppData() {
        return this.cachedAppData != null ? this.cachedAppData : new JSONObject();
    }

    JSONObject getCachedPerformanceData() {
        return this.cachedPerformanceData != null ? this.cachedPerformanceData : new JSONObject();
    }

    JSONObject getCachedBreadcrumbData() {
        return this.cachedBreadcrumbData != null ? this.cachedBreadcrumbData : new JSONObject();
    }

    void setCachedAppData(JSONObject cachedAppData) {
        this.cachedAppData = cachedAppData;
    }

    void setCachedPerformanceData(JSONObject cachedPerformanceData) {
        this.cachedPerformanceData = cachedPerformanceData;
    }

    void setCachedBreadcrumbData(JSONObject cachedBreadcrumbData) {
        this.cachedBreadcrumbData = cachedBreadcrumbData;
    }

    static List<String> parseJsonStringArray(JSONArray array) {
        ArrayList<String> elements = new ArrayList<String>();
        for (int idx = 0; idx < array.length(); ++idx) {
            Object element = array.opt(idx);
            if (element == null || !(element instanceof String)) continue;
            elements.add((String)element);
        }
        return elements;
    }
}

