/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbraceSdkException;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EmbSdkConfig {
    private boolean enabled;
    private boolean screenshotsEnabled;
    private int slowRequestThreshold;
    private Set<String> appPersonas = new HashSet<String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isScreenshotsEnabled() {
        return this.screenshotsEnabled;
    }

    public int getSlowRequestThreshold() {
        return this.slowRequestThreshold;
    }

    public Set<String> getAppPersonas() {
        return this.appPersonas;
    }

    EmbSdkConfig(JSONObject config) throws EmbraceSdkException {
        try {
            if (config.has("enabled")) {
                this.enabled = config.getBoolean("enabled");
            }
            if (config.has("request_latency")) {
                this.slowRequestThreshold = config.getInt("request_latency");
            }
            if (config.has("screenshots_enabled")) {
                this.screenshotsEnabled = config.getBoolean("screenshots_enabled");
            } else {
                EmbLogger.logWarning("enable screenshot field not present in config", new Object[0]);
                this.screenshotsEnabled = true;
            }
            if (config.has("personas")) {
                JSONArray array = config.getJSONArray("personas");
                for (int idx = 0; idx < array.length(); ++idx) {
                    this.appPersonas.add(array.getString(idx));
                }
            }
        }
        catch (JSONException e) {
            EmbLogger.logWarning("Unable to convert JSON to object", new Object[0]);
            throw new EmbraceSdkException("Unable to convert JSON to object", e);
        }
    }

    String encodeObjectForSaving() throws EmbraceSdkException {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("enabled", this.enabled);
            jsonObject.put("request_latency", this.slowRequestThreshold);
            jsonObject.put("screenshots_enabled", this.screenshotsEnabled);
            JSONArray array = new JSONArray();
            for (String persona : this.appPersonas) {
                array.put((Object)persona);
            }
            jsonObject.put("personas", (Object)array);
        }
        catch (JSONException e) {
            EmbLogger.logWarning("Unable to convert object to JSON", new Object[0]);
            throw new EmbraceSdkException("Unable to convert object to JSON", e);
        }
        return jsonObject.toString();
    }
}

