/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Handler;
import io.embrace.android.embracesdk.EmbManager;
import io.embrace.android.embracesdk.EmbSystemUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

class EmbRequest {
    private static final String EMB_JSON_CONTENT_TYPE = "application/json";
    private static final String EMB_CONTENT_ENCODING_GZIP = "gzip";
    static final String EMB_STORY_ID_HEADER_FORMAT = "%s:%s";
    private static final String EMB_USER_AGENT_FORMAT = "Embrace/a/%s";
    private static final String EMB_APP_ID_HEADER = "X-EM-AID";
    private static final String EMB_DEVICE_ID_HEADER = "X-EM-DID";
    private static final String EMB_STORY_ID_HEADER = "X-EM-SID";
    private static final String EMB_LOG_ID_HEADER = "X-EM-LID";
    private Handler callbackHandler;
    private final URL url;
    private final JSONObject data;
    private final String storyId;
    private final String logId;
    private final String userAgent;

    public URL getUrl() {
        return this.url;
    }

    public JSONObject getData() {
        return this.data;
    }

    public String getStoryId() {
        return this.storyId;
    }

    public String getLogId() {
        return this.logId;
    }

    EmbRequest(URL url, JSONObject data, String storyId, String logId) {
        this.url = url;
        this.data = data;
        this.storyId = storyId;
        this.logId = logId;
        this.userAgent = String.format(EMB_USER_AGENT_FORMAT, EmbManager.getInstance().getEmbraceVersionString());
    }

    public Handler getCallbackHandler() {
        return this.callbackHandler;
    }

    synchronized void setCallbackHandler(Handler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    HttpURLConnection createConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestProperty("Accept", EMB_JSON_CONTENT_TYPE);
        connection.setRequestProperty("Content-Type", EMB_JSON_CONTENT_TYPE);
        connection.setRequestProperty("User-Agent", this.userAgent);
        connection.setRequestProperty("Content-Encoding", EMB_CONTENT_ENCODING_GZIP);
        connection.setRequestProperty("Accept-Encoding", EMB_CONTENT_ENCODING_GZIP);
        connection.setRequestProperty(EMB_APP_ID_HEADER, EmbManager.getInstance().getApiKey());
        connection.setRequestProperty(EMB_DEVICE_ID_HEADER, EmbSystemUtils.getInstance().getDeviceId());
        if (this.storyId != null) {
            connection.setRequestProperty(EMB_STORY_ID_HEADER, this.storyId);
        }
        if (this.logId != null) {
            connection.setRequestProperty(EMB_LOG_ID_HEADER, this.logId);
        }
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        return connection;
    }

    HttpURLConnection createRemoteConfigConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestProperty("Accept", EMB_JSON_CONTENT_TYPE);
        connection.setRequestProperty("User-Agent", this.userAgent);
        connection.setRequestMethod("GET");
        return connection;
    }
}

