/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import android.util.Base64;
import io.embrace.android.embracesdk.EmbFilterable;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class EmbNetworkPerformance
implements EmbFilterable {
    private String url;
    private String httpMethod;
    private int statusCode = -1;
    private long startTime;
    private long endTime;
    private long bytesSent;
    private long bytesReceived;
    private String requestId;

    public EmbNetworkPerformance(String url, String httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.statusCode = statusCode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
        this.requestId = String.format("%.6s", Base64.encodeToString((byte[])UUID.randomUUID().toString().getBytes(), (int)2).replace('+', '0').replace(' ', '0'));
    }

    JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("rid", (Object)(!TextUtils.isEmpty((CharSequence)this.requestId) ? this.requestId : ""));
            jsonObject.put("x", (Object)(!TextUtils.isEmpty((CharSequence)this.httpMethod) ? this.httpMethod : ""));
            jsonObject.put("dur", Math.max(this.endTime - this.startTime, -1L));
            jsonObject.put("bi", this.bytesReceived);
            jsonObject.put("bo", this.bytesSent);
            jsonObject.put("url", (Object)(!TextUtils.isEmpty((CharSequence)this.url) ? this.url : ""));
            jsonObject.put("st", this.startTime);
            jsonObject.put("et", this.endTime);
            jsonObject.put("rc", this.statusCode);
        }
        catch (JSONException e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    String getUrl() {
        return this.url;
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    long getBytesSent() {
        return this.bytesSent;
    }

    long getBytesReceived() {
        return this.bytesReceived;
    }

    long getElapsedTime() {
        return this.endTime - this.startTime;
    }
}

