/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.v4.content.FileProvider;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceSdkException;
import io.embrace.android.embracesdk.helpers.EmbFileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class EmbFileUtils {
    private static final String EmbHostApplicationId = "hostAppId";
    private static final String EmbFileProvider = "io.embrace.android.embracesdk.fileprovider";
    private static final String EmbCachesDirectory = "caches";
    private static final String EmbConfigCacheFilePath = "config";
    private static final String EmbEventCacheFilePath = "events";
    private static final String EmbSessionCacheFilePath = "sessions";
    private static final String EmbNetworkTrafficCacheFilePath = "network";
    private static final String EmbCpuProfilingCacheFilePath = "cpu";
    private static final String EmbMemoryProfilingCacheFilePath = "memory";
    private static final String EmbActiveStoriesCacheFilePath = "stories";
    private static final String EmbFailedEventsCacheFilePath = "failed.events";
    private static final String EmbFailedSessionsCacheFilePath = "failed.sessions";
    private static final String EmbUnsentSessionsCacheFilePath = "unsent.sessions";
    private static final String EmbTerminationMessageCacheFilePath = "termination.message";
    private static final String EmbFailedSessionStartMessagesCacheFilePath = "failed.session_start_messages";
    private static final String EmbCrashReportsDirectoryPath = "crashes";
    private static final String EmbSessionInfoFileName = "sessions";

    private EmbFileUtils() {
    }

    static Uri getPathForCache(EmbFileCache fileCache) {
        File file = new File(Embrace.getContext().getFilesDir(), EmbCachesDirectory);
        String authority = "io.embrace.android.embracesdk.fileprovider:" + EmbFileUtils.getApplicationId();
        file.mkdir();
        switch (fileCache) {
            case EmbFileCacheConfig: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbConfigCacheFilePath));
            }
            case EmbFileCacheEvents: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbEventCacheFilePath));
            }
            case EmbFileCacheSessions: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, "sessions"));
            }
            case EmbFileCacheRequests: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbNetworkTrafficCacheFilePath));
            }
            case EmbFileCacheCPUSpikes: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbCpuProfilingCacheFilePath));
            }
            case EmbFileCacheMemory: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbMemoryProfilingCacheFilePath));
            }
            case EmbFileCacheActiveStories: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbActiveStoriesCacheFilePath));
            }
            case EmbFileCacheFailedEvents: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbFailedEventsCacheFilePath));
            }
            case EmbFileCacheFailedSessions: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbFailedSessionsCacheFilePath));
            }
            case EmbFileCacheUnsentSessions: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbUnsentSessionsCacheFilePath));
            }
            case EmbFileCacheTerminationMessage: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbTerminationMessageCacheFilePath));
            }
            case EmbFileCacheFailedSessionStartMessages: {
                return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)authority, (File)new File(file, EmbFailedSessionStartMessagesCacheFilePath));
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    static Map<String, Object> readSessionInfoFile() throws EmbraceSdkException {
        Map sessionContents;
        block23: {
            ObjectInputStream objectInputStream;
            FileInputStream inputStream;
            block21: {
                sessionContents = null;
                File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.pathForSessionInfoFile().getLastPathSegment());
                inputStream = null;
                objectInputStream = null;
                inputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(inputStream);
                sessionContents = (Map)objectInputStream.readObject();
                if (inputStream == null) break block21;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream: %s", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream: %s", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            break block23;
            catch (IOException e) {
                block22: {
                    EmbLogger.logDebug("no file at session info path", new Object[0]);
                    if (inputStream == null) break block22;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        EmbLogger.logError("error closing input stream: %s", e2.toString());
                        throw new EmbraceSdkException("no file found for session info", e2);
                    }
                }
                if (objectInputStream == null) break block23;
                try {
                    objectInputStream.close();
                }
                catch (IOException e3) {
                    EmbLogger.logError("error closing input stream: %s", e3.toString());
                    throw new EmbraceSdkException("no file found for session info", e3);
                }
            }
            catch (ClassNotFoundException e2) {
                EmbLogger.logDebug("session info file incorrect format", new Object[0]);
                throw new EmbraceSdkException("session info file incorrect format", e2);
                {
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e4) {
                                EmbLogger.logError("error closing input stream: %s", e4.toString());
                                throw new EmbraceSdkException("no file found for session info", e4);
                            }
                        }
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException e5) {
                                EmbLogger.logError("error closing input stream: %s", e5.toString());
                                throw new EmbraceSdkException("no file found for session info", e5);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        return sessionContents;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void updateSessionInfoFileContents(Map<String, Object> sessionInfoContents) throws EmbraceSdkException {
        FileOutputStream fileOutputStream;
        block15: {
            File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.pathForSessionInfoFile().getLastPathSegment());
            ObjectOutputStream objectOutputStream = null;
            fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(sessionInfoContents);
                if (objectOutputStream == null) break block15;
            }
            catch (FileNotFoundException e) {
                try {
                    EmbLogger.logError("no file found for session info", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                    catch (IOException e2) {
                        EmbLogger.logError("error opening input stream: %s", e2.toString());
                        throw new EmbraceSdkException("error opening input stream", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException e3) {
                            EmbLogger.logError("error closing output stream: %s", e3.toString());
                            throw new EmbraceSdkException("error closing output stream", e3);
                        }
                    }
                    if (fileOutputStream == null) throw throwable;
                    try {
                        fileOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException e4) {
                        EmbLogger.logError("error closing output stream: %s", e4.toString());
                        throw new EmbraceSdkException("error closing output stream", e4);
                    }
                }
            }
            try {
                objectOutputStream.close();
            }
            catch (IOException e) {
                EmbLogger.logError("error closing output stream: %s", e.toString());
                throw new EmbraceSdkException("error closing output stream", e);
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                EmbLogger.logError("error closing output stream: %s", e.toString());
                throw new EmbraceSdkException("error closing output stream", e);
            }
        }
        EmbLogger.logDebug("session info file updated with contents %s", sessionInfoContents);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T extends Serializable> void saveMapToFile(Map<String, T> objectMap, EmbFileCache fileCache) throws EmbraceSdkException {
        FileOutputStream fileOutputStream;
        block15: {
            File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
            ObjectOutputStream objectOutputStream = null;
            fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(objectMap);
                if (objectOutputStream == null) break block15;
            }
            catch (FileNotFoundException e) {
                try {
                    EmbLogger.logError("no file found for " + fileCache.name(), e.toString());
                    throw new EmbraceSdkException("no file found for " + fileCache.name(), e);
                    catch (IOException e2) {
                        EmbLogger.logError("error opening input stream: %s", e2.toString());
                        e2.printStackTrace();
                        throw new EmbraceSdkException("error opening input stream", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException e3) {
                            EmbLogger.logError("error closing output stream: %s", e3.toString());
                            throw new EmbraceSdkException("error closing output stream", e3);
                        }
                    }
                    if (fileOutputStream == null) throw throwable;
                    try {
                        fileOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException e4) {
                        EmbLogger.logError("error closing output stream: %s", e4.toString());
                        throw new EmbraceSdkException("error closing output stream", e4);
                    }
                }
            }
            try {
                objectOutputStream.close();
            }
            catch (IOException e) {
                EmbLogger.logError("error closing output stream: %s", e.toString());
                throw new EmbraceSdkException("error closing output stream", e);
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                EmbLogger.logError("error closing output stream: %s", e.toString());
                throw new EmbraceSdkException("error closing output stream", e);
            }
        }
        EmbLogger.logDebug("file updated with contents %s", objectMap);
    }

    /*
     * Loose catch block
     */
    static <T extends Serializable> Map<String, T> readMapFromFile(EmbFileCache fileCache) throws EmbraceSdkException {
        HashMap map;
        block23: {
            ObjectInputStream objectInputStream;
            FileInputStream inputStream;
            block21: {
                map = new HashMap();
                File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
                inputStream = null;
                objectInputStream = null;
                inputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(inputStream);
                map.putAll((Map)objectInputStream.readObject());
                if (inputStream == null) break block21;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream: %s", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream: %s", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            break block23;
            catch (IOException e) {
                block22: {
                    EmbLogger.logDebug("no file at path " + fileCache.name(), new Object[0]);
                    if (inputStream == null) break block22;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        EmbLogger.logError("error closing input stream: %s", e2.toString());
                        throw new EmbraceSdkException("no file found for session info", e2);
                    }
                }
                if (objectInputStream == null) break block23;
                try {
                    objectInputStream.close();
                }
                catch (IOException e3) {
                    EmbLogger.logError("error closing input stream: %s", e3.toString());
                    throw new EmbraceSdkException("no file found for session info", e3);
                }
            }
            catch (ClassNotFoundException e2) {
                EmbLogger.logDebug("file incorrect format", new Object[0]);
                throw new EmbraceSdkException("file incorrect format", e2);
                {
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e4) {
                                EmbLogger.logError("error closing input stream: %s", e4.toString());
                                throw new EmbraceSdkException("no file found for session info", e4);
                            }
                        }
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException e5) {
                                EmbLogger.logError("error closing input stream: %s", e5.toString());
                                throw new EmbraceSdkException("no file found for session info", e5);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        return map;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T extends Serializable> void saveCollectionToFile(Collection<T> collection, EmbFileCache fileCache) throws EmbraceSdkException {
        FileOutputStream fileOutputStream;
        block15: {
            File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
            ObjectOutputStream objectOutputStream = null;
            fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(collection);
                if (objectOutputStream == null) break block15;
            }
            catch (FileNotFoundException e) {
                try {
                    EmbLogger.logError("no file found for " + fileCache.name(), e.toString());
                    throw new EmbraceSdkException("no file found for " + fileCache.name(), e);
                    catch (IOException e2) {
                        EmbLogger.logError("error opening input stream: %s", e2.toString());
                        throw new EmbraceSdkException("error opening input stream", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException e3) {
                            EmbLogger.logError("error closing output stream: %s", e3.toString());
                            throw new EmbraceSdkException("error closing output stream", e3);
                        }
                    }
                    if (fileOutputStream == null) throw throwable;
                    try {
                        fileOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException e4) {
                        EmbLogger.logError("error closing output stream: %s", e4.toString());
                        throw new EmbraceSdkException("error closing output stream", e4);
                    }
                }
            }
            try {
                objectOutputStream.close();
            }
            catch (IOException e) {
                EmbLogger.logError("error closing output stream: %s", e.toString());
                throw new EmbraceSdkException("error closing output stream", e);
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                EmbLogger.logError("error closing output stream: %s", e.toString());
                throw new EmbraceSdkException("error closing output stream", e);
            }
        }
        EmbLogger.logDebug("file updated with contents %s", collection);
    }

    /*
     * Loose catch block
     */
    static <T extends Serializable> Collection<T> readCollectionFromFile(EmbFileCache fileCache) throws EmbraceSdkException {
        ArrayList collection;
        block23: {
            ObjectInputStream objectInputStream;
            FileInputStream inputStream;
            block21: {
                collection = new ArrayList();
                File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
                inputStream = null;
                objectInputStream = null;
                inputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(inputStream);
                collection.addAll((Collection)objectInputStream.readObject());
                if (inputStream == null) break block21;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream: %s", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream: %s", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            break block23;
            catch (IOException e) {
                block22: {
                    EmbLogger.logDebug("no file at path " + fileCache.name(), new Object[0]);
                    if (inputStream == null) break block22;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        EmbLogger.logError("error closing input stream: %s", e2.toString());
                        throw new EmbraceSdkException("no file found for session info", e2);
                    }
                }
                if (objectInputStream == null) break block23;
                try {
                    objectInputStream.close();
                }
                catch (IOException e3) {
                    EmbLogger.logError("error closing input stream: %s", e3.toString());
                    throw new EmbraceSdkException("no file found for session info", e3);
                }
            }
            catch (ClassNotFoundException e2) {
                EmbLogger.logDebug("file incorrect format", new Object[0]);
                throw new EmbraceSdkException("file incorrect format", e2);
                {
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e4) {
                                EmbLogger.logError("error closing input stream: %s", e4.toString());
                                throw new EmbraceSdkException("no file found for session info", e4);
                            }
                        }
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException e5) {
                                EmbLogger.logError("error closing input stream: %s", e5.toString());
                                throw new EmbraceSdkException("no file found for session info", e5);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        return collection;
    }

    /*
     * Loose catch block
     */
    static String readStringFromFile(EmbFileCache fileCache) throws EmbraceSdkException {
        String string;
        block23: {
            ObjectInputStream objectInputStream;
            FileInputStream inputStream;
            block21: {
                string = null;
                File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
                inputStream = null;
                objectInputStream = null;
                inputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(inputStream);
                string = (String)objectInputStream.readObject();
                if (inputStream == null) break block21;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream: %s", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    EmbLogger.logError("error closing input stream: %s", e.toString());
                    throw new EmbraceSdkException("no file found for session info", e);
                }
            }
            break block23;
            catch (IOException e) {
                block22: {
                    EmbLogger.logDebug("no file at path " + fileCache.name(), new Object[0]);
                    if (inputStream == null) break block22;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        EmbLogger.logError("error closing input stream: %s", e2.toString());
                        throw new EmbraceSdkException("no file found for session info", e2);
                    }
                }
                if (objectInputStream == null) break block23;
                try {
                    objectInputStream.close();
                }
                catch (IOException e3) {
                    EmbLogger.logError("error closing input stream: %s", e3.toString());
                    throw new EmbraceSdkException("no file found for session info", e3);
                }
            }
            catch (ClassNotFoundException e2) {
                EmbLogger.logDebug("file incorrect format", new Object[0]);
                throw new EmbraceSdkException("file incorrect format", e2);
                {
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e4) {
                                EmbLogger.logError("error closing input stream: %s", e4.toString());
                                throw new EmbraceSdkException("no file found for session info", e4);
                            }
                        }
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException e5) {
                                EmbLogger.logError("error closing input stream: %s", e5.toString());
                                throw new EmbraceSdkException("no file found for session info", e5);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        return string;
    }

    static void removeFileAtPath(EmbFileCache fileCache) {
        File file = new File(Embrace.getContext().getFilesDir(), EmbFileUtils.getPathForCache(fileCache).getLastPathSegment());
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    private static Uri pathForSessionInfoFile() {
        File file = new File(Embrace.getContext().getFilesDir(), EmbCachesDirectory);
        file.mkdir();
        return FileProvider.getUriForFile((Context)Embrace.getContext(), (String)("io.embrace.android.embracesdk.fileprovider:" + EmbFileUtils.getApplicationId()), (File)new File(file, "sessions"));
    }

    private static String getApplicationId() {
        try {
            ApplicationInfo ai = Embrace.getContext().getPackageManager().getApplicationInfo(Embrace.getContext().getPackageName(), 128);
            return ai.metaData.get(EmbHostApplicationId).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            EmbLogger.logError("Unable to get application id %s", e.toString());
            return Embrace.getContext().getApplicationContext().getApplicationInfo().packageName;
        }
    }
}

