/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import io.embrace.android.embracesdk.EmbBreadcrumbManager;
import io.embrace.android.embracesdk.EmbLogger;
import io.embrace.android.embracesdk.EmbMemoryManager;
import io.embrace.android.embracesdk.EmbSessionManager;
import io.embrace.android.embracesdk.EmbraceSdkException;

public class EmbApplicationStateManager
implements ComponentCallbacks2,
Application.ActivityLifecycleCallbacks {
    private boolean isInBackground = true;
    private boolean foreground = false;
    private boolean paused = true;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable checkRunnable;
    private static final EmbApplicationStateManager manager = new EmbApplicationStateManager();

    static EmbApplicationStateManager getManager() {
        return manager;
    }

    private EmbApplicationStateManager() {
    }

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            EmbMemoryManager.getManager().handleMemoryWarning();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    public void enable() {
        if (this.isInBackground) {
            try {
                this.isInBackground = false;
                EmbSessionManager.manager.applicationEnteredForeground();
                this.removeHandlerCallbacks();
                this.setForeground(true);
                this.setPaused(false);
            }
            catch (EmbraceSdkException e) {
                EmbLogger.logError("Error while entering foreground", e);
            }
        }
    }

    private void disable() {
        if (!this.isInBackground) {
            EmbSessionManager.manager.applicationEnteredBackground();
            this.isInBackground = true;
        }
    }

    boolean isInBackground() {
        return this.isInBackground;
    }

    public void removeHandlerCallbacks() {
        if (this.checkRunnable != null) {
            this.handler.removeCallbacks(this.checkRunnable);
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    public void setForeground(boolean foreground) {
        this.foreground = foreground;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setCallbacks() {
        this.checkRunnable = new Runnable(){

            @Override
            public void run() {
                if (EmbApplicationStateManager.this.foreground && EmbApplicationStateManager.this.paused) {
                    EmbApplicationStateManager.this.foreground = false;
                    EmbApplicationStateManager.this.disable();
                }
            }
        };
        this.handler.postDelayed(this.checkRunnable, 500L);
    }

    public void setBackgroundCallbacks() {
        if (this.isPaused()) {
            this.removeHandlerCallbacks();
            this.setCallbacks();
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.enable();
    }

    public void onActivityStarted(Activity activity) {
        this.enable();
        EmbBreadcrumbManager.getManager().logView(activity.getClass().getName());
    }

    public void onActivityResumed(Activity activity) {
        this.setPaused(false);
    }

    public void onActivityPaused(Activity activity) {
        this.setPaused(true);
    }

    public void onActivityStopped(Activity activity) {
        this.setBackgroundCallbacks();
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.setBackgroundCallbacks();
    }
}

