/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.okhttp3;

import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.HttpPathOverrideRequest;
import io.embrace.android.embracesdk.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.okhttp3.EmbraceOkHttp3PathOverrideRequest;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class EmbraceOkHttp3ApplicationInterceptor
implements Interceptor {
    final Embrace embrace = Embrace.getInstance();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        long startTime = System.currentTimeMillis();
        Request request = chain.request();
        try {
            return chain.proceed(request);
        }
        catch (Exception e) {
            if (this.embrace.isStarted()) {
                String traceIdHeader = this.embrace.getTraceIdHeader();
                this.embrace.logNetworkClientError(EmbraceHttpPathOverride.getURLString((HttpPathOverrideRequest)new EmbraceOkHttp3PathOverrideRequest(request)), HttpMethod.fromString((String)request.method()), startTime, System.currentTimeMillis(), e.getClass().getCanonicalName(), e.getMessage(), request.header(traceIdHeader));
            }
            throw e;
        }
    }
}

